/*
 * Decompiled with CFR 0.152.
 */
package gay.zharel.hermes.geometry;

import gay.zharel.hermes.geometry.Pose2d;
import gay.zharel.hermes.geometry.Pose2dDual;
import gay.zharel.hermes.geometry.Rotation2d;
import gay.zharel.hermes.geometry.Rotation2dDual;
import gay.zharel.hermes.geometry.Rotation2dKt;
import gay.zharel.hermes.geometry.Vector2d;
import gay.zharel.hermes.geometry.Vector2dDual;
import gay.zharel.hermes.geometry.Vector2dKt;
import gay.zharel.hermes.math.DualParameter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a:\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\b\b\u0000\u0010\b*\u00020\t2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\b0\u00072\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\b0\u00072\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\n"}, d2={"lerpPose2d", "Lgay/zharel/hermes/geometry/Pose2d;", "start", "end", "t", "", "lerpPose2dDual", "Lgay/zharel/hermes/geometry/Pose2dDual;", "Param", "Lgay/zharel/hermes/math/DualParameter;", "core"})
@SourceDebugExtension(value={"SMAP\nPose2d.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pose2d.kt\ngay/zharel/hermes/geometry/Pose2dKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1#2:160\n*E\n"})
public final class Pose2dKt {
    @NotNull
    public static final Pose2d lerpPose2d(@NotNull Pose2d start, @NotNull Pose2d end, double t) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        if (!(0.0 <= t ? t <= 1.0 : false)) {
            boolean $i$a$-require-Pose2dKt$lerpPose2d$22 = false;
            String $i$a$-require-Pose2dKt$lerpPose2d$22 = "Interpolation parameter t must be between 0.0 and 1.0, but was " + t;
            throw new IllegalArgumentException($i$a$-require-Pose2dKt$lerpPose2d$22.toString());
        }
        Vector2d position = Vector2dKt.lerpVector2d(start.position, end.position, t);
        Rotation2d heading = Rotation2dKt.lerpRotation2d(start.heading, end.heading, t);
        return new Pose2d(position, heading);
    }

    @NotNull
    public static final <Param extends DualParameter> Pose2dDual<Param> lerpPose2dDual(@NotNull Pose2dDual<Param> start, @NotNull Pose2dDual<Param> end, double t) {
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        if (!(0.0 <= t ? t <= 1.0 : false)) {
            boolean $i$a$-require-Pose2dKt$lerpPose2dDual$22 = false;
            String $i$a$-require-Pose2dKt$lerpPose2dDual$22 = "Interpolation parameter t must be between 0.0 and 1.0, but was " + t;
            throw new IllegalArgumentException($i$a$-require-Pose2dKt$lerpPose2dDual$22.toString());
        }
        Vector2dDual position = Vector2dKt.lerpVector2dDual(start.position, end.position, t);
        Rotation2dDual heading = Rotation2dKt.lerpRotation2dDual(start.heading, end.heading, t);
        return new Pose2dDual(position, heading);
    }
}

