/*
 * Decompiled with CFR 0.152.
 */
package gay.zharel.hermes.paths;

import gay.zharel.hermes.math.DualNum;
import gay.zharel.hermes.math.Internal;
import gay.zharel.hermes.math.Math;
import gay.zharel.hermes.paths.BezierCurve1d$;
import gay.zharel.hermes.paths.QuinticSpline1d;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.DoubleSerializer;
import kotlinx.serialization.internal.IntSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 ,2\u00020\u0001:\u0002,-B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0005\u0010\bBC\b\u0010\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0003\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u0005\u0010\u000fJ\u0011\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0086\u0002J\u001f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\nH\u0086\u0002J\u0006\u0010\u001a\u001a\u00020\u0000J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\nJ\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\u001d\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\nH\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001J%\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0001\u00a2\u0006\u0002\b+R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006."}, d2={"Lgay/zharel/hermes/paths/BezierCurve1d;", "", "coefficients", "", "", "<init>", "(Ljava/util/List;)V", "", "([D)V", "seen0", "", "dim", "cache", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/util/List;ILjava/util/List;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getCoefficients", "()Ljava/util/List;", "getDim", "()I", "getCache", "get", "t", "Lgay/zharel/hermes/math/DualNum;", "Lgay/zharel/hermes/math/Internal;", "n", "derivative", "nthDerivative", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$core", "Companion", "$serializer", "core"})
@SourceDebugExtension(value={"SMAP\nBezierCurves.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BezierCurves.kt\ngay/zharel/hermes/paths/BezierCurve1d\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1563#2:104\n1634#2,3:105\n1803#2,3:109\n1634#2,3:112\n1#3:108\n*S KotlinDebug\n*F\n+ 1 BezierCurves.kt\ngay/zharel/hermes/paths/BezierCurve1d\n*L\n26#1:104\n26#1:105,3\n51#1:109,3\n26#1:112,3\n*E\n"})
public final class BezierCurve1d {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Double> coefficients;
    private final int dim;
    @NotNull
    private final List<Integer> cache;
    @JvmField
    @NotNull
    private static final Lazy<KSerializer<Object>>[] $childSerializers;

    /*
     * WARNING - void declaration
     */
    public BezierCurve1d(@NotNull List<Double> coefficients) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(coefficients, (String)"coefficients");
        this.coefficients = coefficients;
        this.dim = this.coefficients.size() - 1;
        Iterable iterable = (Iterable)CollectionsKt.getIndices((Collection)this.coefficients);
        BezierCurve1d bezierCurve1d = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(BezierCurve1d.Companion.bi(this.dim, (int)it));
        }
        bezierCurve1d.cache = (List)destination$iv$iv;
    }

    @NotNull
    public final List<Double> getCoefficients() {
        return this.coefficients;
    }

    public BezierCurve1d(@NotNull double[] coefficients) {
        Intrinsics.checkNotNullParameter((Object)coefficients, (String)"coefficients");
        this(ArraysKt.toList((double[])coefficients));
    }

    public final int getDim() {
        return this.dim;
    }

    @NotNull
    public final List<Integer> getCache() {
        return this.cache;
    }

    /*
     * WARNING - void declaration
     */
    public final double get(double t) {
        Iterable iterable = (Iterable)new IntRange(0, this.dim);
        double d = 0.0;
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            void i;
            int n;
            int n2 = n = ((IntIterator)iterator).nextInt();
            double d2 = d;
            boolean bl = false;
            double d3 = ((Number)this.cache.get((int)i)).doubleValue() * java.lang.Math.pow(1.0 - t, this.dim - i) * java.lang.Math.pow(t, (double)i) * ((Number)this.coefficients.get((int)i)).doubleValue();
            d = d2 + d3;
        }
        return d;
    }

    @NotNull
    public final DualNum<Internal> get(double t, int n) {
        int n2 = 0;
        double[] dArray = new double[n];
        while (n2 < n) {
            int n3 = n2++;
            dArray[n3] = this.nthDerivative(n3).get(t);
        }
        double[] dArray2 = dArray;
        return new DualNum<Internal>(dArray2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BezierCurve1d derivative() {
        int n = this.dim;
        ArrayList<Double> arrayList = new ArrayList<Double>(n);
        int n2 = 0;
        while (n2 < n) {
            void i;
            int n3;
            int n4 = n3 = n2++;
            ArrayList<Double> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add((double)this.dim * (((Number)this.coefficients.get((int)(i + true))).doubleValue() - ((Number)this.coefficients.get((int)i)).doubleValue()));
        }
        List list = arrayList;
        return new BezierCurve1d(list);
    }

    @NotNull
    public final BezierCurve1d nthDerivative(int n) {
        if (n == 0) {
            return this;
        }
        if (this.coefficients.size() <= n) {
            int n2 = this.coefficients.size();
            ArrayList<Double> arrayList = new ArrayList<Double>(n2);
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                int n5 = n4 = n3++;
                ArrayList<Double> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(0.0);
            }
            List list = arrayList;
            return new BezierCurve1d(list);
        }
        Iterable $this$fold$iv = (Iterable)RangesKt.until((int)0, (int)n);
        boolean $i$f$fold = false;
        BezierCurve1d accumulator$iv = this;
        Iterator iterator = $this$fold$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv = ((IntIterator)iterator).nextInt();
            BezierCurve1d acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.derivative();
        }
        return accumulator$iv;
    }

    @NotNull
    public final List<Double> component1() {
        return this.coefficients;
    }

    @NotNull
    public final BezierCurve1d copy(@NotNull List<Double> coefficients) {
        Intrinsics.checkNotNullParameter(coefficients, (String)"coefficients");
        return new BezierCurve1d(coefficients);
    }

    public static /* synthetic */ BezierCurve1d copy$default(BezierCurve1d bezierCurve1d, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = bezierCurve1d.coefficients;
        }
        return bezierCurve1d.copy(list);
    }

    @NotNull
    public String toString() {
        return "BezierCurve1d(coefficients=" + this.coefficients + ")";
    }

    public int hashCode() {
        return ((Object)this.coefficients).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BezierCurve1d)) {
            return false;
        }
        BezierCurve1d bezierCurve1d = (BezierCurve1d)other;
        return Intrinsics.areEqual(this.coefficients, bezierCurve1d.coefficients);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final /* synthetic */ void write$Self$core(BezierCurve1d self, CompositeEncoder output, SerialDescriptor serialDesc) {
        boolean bl;
        Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)lazyArray[0].getValue(), self.coefficients);
        if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : self.dim != self.coefficients.size() - 1) {
            output.encodeIntElement(serialDesc, 1, self.dim);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 2)) {
            bl = true;
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = (Iterable)CollectionsKt.getIndices((Collection)self.coefficients);
            List<Integer> list = self.cache;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(BezierCurve1d.Companion.bi(self.dim, (int)it));
            }
            bl = !Intrinsics.areEqual(list, (Object)((List)destination$iv$iv));
        }
        if (bl) {
            output.encodeSerializableElement(serialDesc, 2, (SerializationStrategy)lazyArray[2].getValue(), self.cache);
        }
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ BezierCurve1d(int seen0, List coefficients, int dim, List cache, SerializationConstructorMarker serializationConstructorMarker) {
        if (1 != (1 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.coefficients = coefficients;
        this.dim = (seen0 & 2) == 0 ? this.coefficients.size() - 1 : dim;
        if ((seen0 & 4) == 0) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = (Iterable)CollectionsKt.getIndices((Collection)this.coefficients);
            BezierCurve1d bezierCurve1d = this;
            boolean $i$f$map = false;
            void var8_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(BezierCurve1d.Companion.bi(this.dim, (int)it));
            }
            bezierCurve1d.cache = (List)destination$iv$iv;
        } else {
            this.cache = cache;
        }
    }

    public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        Lazy[] lazyArray = new Lazy[]{LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)DoubleSerializer.INSTANCE)), null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)IntSerializer.INSTANCE))};
        $childSerializers = lazyArray;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0082\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f\u00a8\u0006\r"}, d2={"Lgay/zharel/hermes/paths/BezierCurve1d$Companion;", "", "<init>", "()V", "bi", "", "other", "fromRRSpline", "Lgay/zharel/hermes/paths/BezierCurve1d;", "spline", "Lgay/zharel/hermes/paths/QuinticSpline1d;", "serializer", "Lkotlinx/serialization/KSerializer;", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final int bi(int $this$bi, int other) {
            if (other < 0 || other > $this$bi) {
                return 0;
            }
            if (other == 0 || other == $this$bi) {
                return 1;
            }
            return Math.fact($this$bi) / (Math.fact(other) * Math.fact($this$bi - other));
        }

        @NotNull
        public final BezierCurve1d fromRRSpline(@NotNull QuinticSpline1d spline) {
            Intrinsics.checkNotNullParameter((Object)spline, (String)"spline");
            double[] dArray = new double[]{spline.f, spline.f + 0.2 * spline.e, spline.f + 0.4 * spline.e + 0.1 * spline.d, spline.f + 0.6 * spline.e + 0.3 * spline.d + 0.1 * spline.c, spline.f + 0.8 * spline.e + 0.6 * spline.d + 0.4 * spline.c + 0.2 * spline.b, CollectionsKt.sumOfDouble((Iterable)spline.getCoefficients())};
            return new BezierCurve1d(dArray);
        }

        @NotNull
        public final KSerializer<BezierCurve1d> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

