/*
 * Decompiled with CFR 0.152.
 */
package gay.zharel.hermes.profiles;

import gay.zharel.hermes.math.DualNum;
import gay.zharel.hermes.math.Time;
import gay.zharel.hermes.paths.PosePath;
import gay.zharel.hermes.profiles.AccelConstraint;
import gay.zharel.hermes.profiles.DisplacementProfile$;
import gay.zharel.hermes.profiles.PathBasedProfilesKt;
import gay.zharel.hermes.profiles.Profile;
import gay.zharel.hermes.profiles.ProfileParams;
import gay.zharel.hermes.profiles.VelConstraint;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialName;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.DoubleSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@SerialName(value="DisplacementProfile")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 .2\u00020\u0001:\u0002./B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0007\u0010\bBS\b\u0010\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0004\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u0007\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0004H\u0096\u0002J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\nH\u0002J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\nH\u0002J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J9\u0010\u001f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u00d6\u0003J\t\u0010$\u001a\u00020\nH\u00d6\u0001J\t\u0010%\u001a\u00020&H\u00d6\u0001J%\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0001\u00a2\u0006\u0002\b-R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lgay/zharel/hermes/profiles/DisplacementProfile;", "Lgay/zharel/hermes/profiles/Profile;", "disps", "", "", "vels", "accels", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "seen0", "", "length", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/util/List;Ljava/util/List;Ljava/util/List;DLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "validateProfileData", "", "get", "Lgay/zharel/hermes/math/DualNum;", "Lgay/zharel/hermes/math/Time;", "x", "createDualNumAtEnd", "index", "createDualNumAtKnownPoint", "createDualNumByInterpolation", "negativeIndex", "interpolateVelocityAndAcceleration", "insertionIndex", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "", "write$Self", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$core", "Companion", "$serializer", "core"})
public final class DisplacementProfile
implements Profile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final List<Double> disps;
    @JvmField
    @NotNull
    public final List<Double> vels;
    @JvmField
    @NotNull
    public final List<Double> accels;
    @JvmField
    public final double length;
    @JvmField
    @NotNull
    private static final Lazy<KSerializer<Object>>[] $childSerializers;

    public DisplacementProfile(@NotNull List<Double> disps, @NotNull List<Double> vels, @NotNull List<Double> accels) {
        Intrinsics.checkNotNullParameter(disps, (String)"disps");
        Intrinsics.checkNotNullParameter(vels, (String)"vels");
        Intrinsics.checkNotNullParameter(accels, (String)"accels");
        this.disps = disps;
        this.vels = vels;
        this.accels = accels;
        this.length = ((Number)CollectionsKt.last(this.disps)).doubleValue();
        this.validateProfileData();
    }

    private final void validateProfileData() {
        if (!(this.disps.size() == this.vels.size())) {
            boolean $i$a$-require-DisplacementProfile$validateProfileData$32 = false;
            String $i$a$-require-DisplacementProfile$validateProfileData$32 = "disps.size() (" + this.disps.size() + ") != vels.size() (" + this.vels.size() + ")";
            throw new IllegalArgumentException($i$a$-require-DisplacementProfile$validateProfileData$32.toString());
        }
        if (!(this.disps.size() == this.accels.size() + 1)) {
            boolean bl = false;
            String string = "disps.size() (" + this.disps.size() + ") != accels.size() + 1 (" + (this.accels.size() + 1) + ")";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public DualNum<Time> get(double x) {
        int index = CollectionsKt.binarySearch$default(this.disps, (Comparable)Double.valueOf(x), (int)0, (int)0, (int)6, null);
        return index >= CollectionsKt.getLastIndex(this.disps) ? this.createDualNumAtEnd(x, index) : (index >= 0 ? this.createDualNumAtKnownPoint(x, index) : this.createDualNumByInterpolation(x, index));
    }

    private final DualNum<Time> createDualNumAtEnd(double x, int index) {
        double[] dArray = new double[]{x, ((Number)this.vels.get(index)).doubleValue(), 0.0};
        return new DualNum<Time>(dArray);
    }

    private final DualNum<Time> createDualNumAtKnownPoint(double x, int index) {
        double[] dArray = new double[]{x, ((Number)this.vels.get(index)).doubleValue(), ((Number)this.accels.get(index)).doubleValue()};
        return new DualNum<Time>(dArray);
    }

    private final DualNum<Time> createDualNumByInterpolation(double x, int negativeIndex) {
        DualNum<Time> dualNum;
        int insertionIndex = -(negativeIndex + 1);
        if (insertionIndex <= 0) {
            double[] dArray = new double[]{x, ((Number)CollectionsKt.first(this.vels)).doubleValue(), 0.0};
            DualNum<Time> dualNum2 = new DualNum<Time>(dArray);
            dualNum = dualNum2;
        } else if (insertionIndex >= this.disps.size()) {
            double[] dArray = new double[]{x, ((Number)CollectionsKt.last(this.vels)).doubleValue(), 0.0};
            DualNum dualNum3 = new DualNum(dArray);
            dualNum = dualNum3;
        } else {
            dualNum = this.interpolateVelocityAndAcceleration(x, insertionIndex);
        }
        return dualNum;
    }

    private final DualNum<Time> interpolateVelocityAndAcceleration(double x, int insertionIndex) {
        double dx = x - ((Number)this.disps.get(insertionIndex - 1)).doubleValue();
        double v0 = ((Number)this.vels.get(insertionIndex - 1)).doubleValue();
        double a = ((Number)this.accels.get(insertionIndex - 1)).doubleValue();
        double interpolatedVelocity = Math.sqrt(v0 * v0 + (double)2 * a * dx);
        double[] dArray = new double[]{x, interpolatedVelocity, a};
        return new DualNum<Time>(dArray);
    }

    @NotNull
    public final List<Double> component1() {
        return this.disps;
    }

    @NotNull
    public final List<Double> component2() {
        return this.vels;
    }

    @NotNull
    public final List<Double> component3() {
        return this.accels;
    }

    @NotNull
    public final DisplacementProfile copy(@NotNull List<Double> disps, @NotNull List<Double> vels, @NotNull List<Double> accels) {
        Intrinsics.checkNotNullParameter(disps, (String)"disps");
        Intrinsics.checkNotNullParameter(vels, (String)"vels");
        Intrinsics.checkNotNullParameter(accels, (String)"accels");
        return new DisplacementProfile(disps, vels, accels);
    }

    public static /* synthetic */ DisplacementProfile copy$default(DisplacementProfile displacementProfile, List list, List list2, List list3, int n, Object object) {
        if ((n & 1) != 0) {
            list = displacementProfile.disps;
        }
        if ((n & 2) != 0) {
            list2 = displacementProfile.vels;
        }
        if ((n & 4) != 0) {
            list3 = displacementProfile.accels;
        }
        return displacementProfile.copy(list, list2, list3);
    }

    @NotNull
    public String toString() {
        return "DisplacementProfile(disps=" + this.disps + ", vels=" + this.vels + ", accels=" + this.accels + ")";
    }

    public int hashCode() {
        int result = ((Object)this.disps).hashCode();
        result = result * 31 + ((Object)this.vels).hashCode();
        result = result * 31 + ((Object)this.accels).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DisplacementProfile)) {
            return false;
        }
        DisplacementProfile displacementProfile = (DisplacementProfile)other;
        if (!Intrinsics.areEqual(this.disps, displacementProfile.disps)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.vels, displacementProfile.vels)) {
            return false;
        }
        return Intrinsics.areEqual(this.accels, displacementProfile.accels);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$core(DisplacementProfile self, CompositeEncoder output, SerialDescriptor serialDesc) {
        Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)lazyArray[0].getValue(), self.disps);
        output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)lazyArray[1].getValue(), self.vels);
        output.encodeSerializableElement(serialDesc, 2, (SerializationStrategy)lazyArray[2].getValue(), self.accels);
        if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : Double.compare(self.length, ((Number)CollectionsKt.last(self.disps)).doubleValue()) != 0) {
            output.encodeDoubleElement(serialDesc, 3, self.length);
        }
    }

    public /* synthetic */ DisplacementProfile(int seen0, List disps, List vels, List accels, double length, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)7, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.disps = disps;
        this.vels = vels;
        this.accels = accels;
        this.length = (seen0 & 8) == 0 ? ((Number)CollectionsKt.last(this.disps)).doubleValue() : length;
        this.validateProfileData();
    }

    public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        Lazy[] lazyArray = new Lazy[]{LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)DoubleSerializer.INSTANCE)), LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)DoubleSerializer.INSTANCE)), LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)DoubleSerializer.INSTANCE)), null};
        $childSerializers = lazyArray;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJF\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00132\u0006\u0010\u0015\u001a\u00020\u000bJ\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0017\u00a8\u0006\u0018"}, d2={"Lgay/zharel/hermes/profiles/DisplacementProfile$Companion;", "", "<init>", "()V", "generate", "Lgay/zharel/hermes/profiles/DisplacementProfile;", "params", "Lgay/zharel/hermes/profiles/ProfileParams;", "path", "Lgay/zharel/hermes/paths/PosePath;", "beginVel", "", "velConstraint", "Lgay/zharel/hermes/profiles/VelConstraint;", "accelConstraint", "Lgay/zharel/hermes/profiles/AccelConstraint;", "createSimple", "length", "maxVel", "Lkotlin/Function1;", "maxAccel", "resolution", "serializer", "Lkotlinx/serialization/KSerializer;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DisplacementProfile generate(@NotNull ProfileParams params, @NotNull PosePath path, double beginVel, @NotNull VelConstraint velConstraint, @NotNull AccelConstraint accelConstraint) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)velConstraint, (String)"velConstraint");
            Intrinsics.checkNotNullParameter((Object)accelConstraint, (String)"accelConstraint");
            return PathBasedProfilesKt.createOptimalDisplacementProfile(params, path, beginVel, velConstraint, accelConstraint);
        }

        @NotNull
        public final DisplacementProfile createSimple(double length, double beginVel, @NotNull Function1<? super Double, Double> maxVel, @NotNull Function1<? super Double, Double> maxAccel, double resolution) {
            Intrinsics.checkNotNullParameter(maxVel, (String)"maxVel");
            Intrinsics.checkNotNullParameter(maxAccel, (String)"maxAccel");
            return PathBasedProfilesKt.createSimpleDisplacementProfile(length, beginVel, maxVel, maxAccel, resolution);
        }

        @NotNull
        public final KSerializer<DisplacementProfile> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

