/*
 * Decompiled with CFR 0.152.
 */
package gay.zharel.hermes.trajectories;

import gay.zharel.hermes.geometry.Rotation2d;
import gay.zharel.hermes.geometry.Vector2d;
import gay.zharel.hermes.geometry.Vector2dDual;
import gay.zharel.hermes.math.Arclength;
import gay.zharel.hermes.math.DualNum;
import gay.zharel.hermes.math.Internal;
import gay.zharel.hermes.paths.ArclengthReparamCurve2d;
import gay.zharel.hermes.paths.BezierCurve2dInternal;
import gay.zharel.hermes.paths.CompositePositionPath;
import gay.zharel.hermes.paths.Line;
import gay.zharel.hermes.paths.PositionPath;
import gay.zharel.hermes.paths.QuinticSpline1d;
import gay.zharel.hermes.paths.QuinticSpline2dInternal;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\u0018\u00002\u00020\u0001BI\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\t0\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fB!\b\u0016\u0012\u0006\u0010\u0010\u001a\u00020\u000b\u0012\u0006\u0010\u0011\u001a\u00020\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000e\u0010\u0012B!\b\u0016\u0012\u0006\u0010\u0010\u001a\u00020\u000b\u0012\u0006\u0010\u0011\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000e\u0010\u0013J\u0006\u0010\u0014\u001a\u00020\u0000J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\rJ\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0003J\u0016\u0010\u0017\u001a\u00020\u00002\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0002J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0003J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0003J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0003J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u000bJ\u0016\u0010!\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\rJ\u0016\u0010!\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u0003J\u0014\u0010#\u001a\u00020\u00002\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005J\u0012\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lgay/zharel/hermes/trajectories/PositionPathSeqBuilder;", "", "eps", "", "paths", "", "Lgay/zharel/hermes/paths/CompositePositionPath;", "Lgay/zharel/hermes/math/Arclength;", "segments", "Lgay/zharel/hermes/paths/PositionPath;", "nextBeginPos", "Lgay/zharel/hermes/geometry/Vector2d;", "nextBeginTangent", "Lgay/zharel/hermes/geometry/Rotation2d;", "<init>", "(DLjava/util/List;Ljava/util/List;Lgay/zharel/hermes/geometry/Vector2d;Lgay/zharel/hermes/geometry/Rotation2d;)V", "beginPos", "beginTangent", "(Lgay/zharel/hermes/geometry/Vector2d;Lgay/zharel/hermes/geometry/Rotation2d;D)V", "(Lgay/zharel/hermes/geometry/Vector2d;DD)V", "endPath", "setTangent", "newTangent", "addSegment", "seg", "forward", "ds", "lineToX", "posX", "lineToY", "posY", "strafeTo", "pos", "splineTo", "tangent", "bezierTo", "controlPoints", "build", "core"})
@SourceDebugExtension(value={"SMAP\nPathBuilders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathBuilders.kt\ngay/zharel/hermes/trajectories/PositionPathSeqBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,653:1\n1#2:654\n*E\n"})
public final class PositionPathSeqBuilder {
    private final double eps;
    @NotNull
    private final List<CompositePositionPath<Arclength>> paths;
    @NotNull
    private final List<PositionPath<Arclength>> segments;
    @NotNull
    private final Vector2d nextBeginPos;
    @NotNull
    private final Rotation2d nextBeginTangent;

    private PositionPathSeqBuilder(double eps, List<CompositePositionPath<Arclength>> paths, List<? extends PositionPath<Arclength>> segments, Vector2d nextBeginPos, Rotation2d nextBeginTangent) {
        this.eps = eps;
        this.paths = paths;
        this.segments = segments;
        this.nextBeginPos = nextBeginPos;
        this.nextBeginTangent = nextBeginTangent;
    }

    public PositionPathSeqBuilder(@NotNull Vector2d beginPos, @NotNull Rotation2d beginTangent, double eps) {
        Intrinsics.checkNotNullParameter((Object)beginPos, (String)"beginPos");
        Intrinsics.checkNotNullParameter((Object)beginTangent, (String)"beginTangent");
        this(eps, CollectionsKt.emptyList(), CollectionsKt.emptyList(), beginPos, beginTangent);
    }

    public PositionPathSeqBuilder(@NotNull Vector2d beginPos, double beginTangent, double eps) {
        Intrinsics.checkNotNullParameter((Object)beginPos, (String)"beginPos");
        this(beginPos, Rotation2d.Companion.exp(beginTangent), eps);
    }

    @NotNull
    public final PositionPathSeqBuilder endPath() {
        return new PositionPathSeqBuilder(this.eps, this.segments.isEmpty() ? this.paths : CollectionsKt.plus((Collection)this.paths, (Iterable)CollectionsKt.listOf(new CompositePositionPath(this.segments, null, 2, null))), CollectionsKt.emptyList(), this.nextBeginPos, this.nextBeginTangent);
    }

    @NotNull
    public final PositionPathSeqBuilder setTangent(@NotNull Rotation2d newTangent) {
        PositionPathSeqBuilder positionPathSeqBuilder;
        Intrinsics.checkNotNullParameter((Object)newTangent, (String)"newTangent");
        if (Math.abs(this.nextBeginTangent.minus(newTangent)) < 1.0E-6) {
            positionPathSeqBuilder = this;
        } else {
            PositionPathSeqBuilder b = this.endPath();
            positionPathSeqBuilder = new PositionPathSeqBuilder(b.eps, b.paths, b.segments, b.nextBeginPos, newTangent);
        }
        return positionPathSeqBuilder;
    }

    @NotNull
    public final PositionPathSeqBuilder setTangent(double newTangent) {
        return this.setTangent(Rotation2d.Companion.exp(newTangent));
    }

    private final PositionPathSeqBuilder addSegment(PositionPath<Arclength> seg) {
        Vector2dDual<Arclength> begin = seg.begin(2);
        Vector2d beginPos = begin.value();
        Rotation2d beginTangent = begin.drop(1).value().angleCast();
        Vector2dDual<Arclength> end = seg.end(2);
        PositionPathSeqBuilder b = Math.abs(this.nextBeginPos.x - beginPos.x) > this.eps || Math.abs(this.nextBeginPos.y - beginPos.y) > this.eps || Math.abs(this.nextBeginTangent.minus(beginTangent)) > 1.0E-6 ? this.endPath() : this;
        return new PositionPathSeqBuilder(b.eps, b.paths, CollectionsKt.plus((Collection)b.segments, (Iterable)CollectionsKt.listOf(seg)), end.value(), end.drop(1).value().angleCast());
    }

    @NotNull
    public final PositionPathSeqBuilder forward(double ds) {
        return this.addSegment(new Line(this.nextBeginPos, this.nextBeginPos.plus(this.nextBeginTangent.vec().times(ds))));
    }

    @NotNull
    public final PositionPathSeqBuilder lineToX(double posX) {
        if (!(Math.abs(this.nextBeginTangent.real) > 1.0E-6)) {
            boolean bl = false;
            String string = "Path tangent orthogonal to the x-axis, try using lineToY() instead";
            throw new IllegalArgumentException(string.toString());
        }
        return this.addSegment(new Line(this.nextBeginPos, new Vector2d(posX, (posX - this.nextBeginPos.x) / this.nextBeginTangent.real * this.nextBeginTangent.imag + this.nextBeginPos.y)));
    }

    @NotNull
    public final PositionPathSeqBuilder lineToY(double posY) {
        if (!(Math.abs(this.nextBeginTangent.imag) > 1.0E-6)) {
            boolean bl = false;
            String string = "Path tangent orthogonal to the y-axis, try using lineToX() instead";
            throw new IllegalArgumentException(string.toString());
        }
        return this.addSegment(new Line(this.nextBeginPos, new Vector2d((posY - this.nextBeginPos.y) / this.nextBeginTangent.imag * this.nextBeginTangent.real + this.nextBeginPos.x, posY)));
    }

    @NotNull
    public final PositionPathSeqBuilder strafeTo(@NotNull Vector2d pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Vector2d diff = pos.minus(this.nextBeginPos);
        double norm = diff.norm();
        this.setTangent(diff.div(norm).angleCast());
        return this.addSegment(new Line(this.nextBeginPos, pos));
    }

    @NotNull
    public final PositionPathSeqBuilder splineTo(@NotNull Vector2d pos, @NotNull Rotation2d tangent) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)tangent, (String)"tangent");
        double dist = pos.minus(this.nextBeginPos).norm();
        Vector2d beginDeriv = this.nextBeginTangent.vec().times(dist);
        Vector2d endDeriv = tangent.vec().times(dist);
        double[] dArray = new double[]{this.nextBeginPos.x, beginDeriv.x, 0.0};
        DualNum<Internal> dualNum = new DualNum<Internal>(dArray);
        dArray = new double[]{pos.x, endDeriv.x, 0.0};
        QuinticSpline1d quinticSpline1d = new QuinticSpline1d(dualNum, new DualNum<Internal>(dArray));
        dArray = new double[]{this.nextBeginPos.y, beginDeriv.y, 0.0};
        DualNum<Internal> dualNum2 = new DualNum<Internal>(dArray);
        dArray = new double[]{pos.y, endDeriv.y, 0.0};
        ArclengthReparamCurve2d spline = new ArclengthReparamCurve2d((PositionPath)new QuinticSpline2dInternal(quinticSpline1d, new QuinticSpline1d(dualNum2, new DualNum<Internal>(dArray))), this.eps);
        return this.addSegment(spline);
    }

    @NotNull
    public final PositionPathSeqBuilder splineTo(@NotNull Vector2d pos, double tangent) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return this.splineTo(pos, Rotation2d.Companion.exp(tangent));
    }

    @NotNull
    public final PositionPathSeqBuilder bezierTo(@NotNull List<Vector2d> controlPoints) {
        Intrinsics.checkNotNullParameter(controlPoints, (String)"controlPoints");
        if (!(!((Collection)controlPoints).isEmpty())) {
            boolean bl = false;
            String string = "At least two control points required";
            throw new IllegalArgumentException(string.toString());
        }
        return this.addSegment(new ArclengthReparamCurve2d((PositionPath)new BezierCurve2dInternal(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.nextBeginPos), (Iterable)CollectionsKt.toList((Iterable)controlPoints))), this.eps));
    }

    @NotNull
    public final List<CompositePositionPath<Arclength>> build() {
        return CollectionsKt.plus((Collection)this.paths, (Iterable)CollectionsKt.listOf(new CompositePositionPath(this.segments, null, 2, null)));
    }
}

