/*
 * Decompiled with CFR 0.152.
 */
package gay.zharel.hermes.control;

import gay.zharel.hermes.control.PosVelGain;
import gay.zharel.hermes.control.RobotPosVelController;
import gay.zharel.hermes.geometry.Pose2d;
import gay.zharel.hermes.geometry.Pose2dDual;
import gay.zharel.hermes.geometry.PoseVelocity2d;
import gay.zharel.hermes.geometry.PoseVelocity2dDual;
import gay.zharel.hermes.geometry.Vector2d;
import gay.zharel.hermes.math.Time;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B9\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\t\u0012\u0006\u0010\r\u001a\u00020\t\u0012\u0006\u0010\u000e\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\u000fB!\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\u0010J,\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lgay/zharel/hermes/control/HolonomicController;", "Lgay/zharel/hermes/control/RobotPosVelController;", "axialGains", "Lgay/zharel/hermes/control/PosVelGain;", "lateralGains", "headingGains", "<init>", "(Lgay/zharel/hermes/control/PosVelGain;Lgay/zharel/hermes/control/PosVelGain;Lgay/zharel/hermes/control/PosVelGain;)V", "axialPosGain", "", "lateralPosGain", "headingGain", "axialVelGain", "lateralVelGain", "headingVelGain", "(DDDDDD)V", "(DDD)V", "compute", "Lgay/zharel/hermes/geometry/PoseVelocity2dDual;", "Lgay/zharel/hermes/math/Time;", "targetPose", "Lgay/zharel/hermes/geometry/Pose2dDual;", "actualPose", "Lgay/zharel/hermes/geometry/Pose2d;", "actualVelActual", "Lgay/zharel/hermes/geometry/PoseVelocity2d;", "core"})
public final class HolonomicController
implements RobotPosVelController {
    @JvmField
    @NotNull
    public final PosVelGain axialGains;
    @JvmField
    @NotNull
    public final PosVelGain lateralGains;
    @JvmField
    @NotNull
    public final PosVelGain headingGains;

    public HolonomicController(@NotNull PosVelGain axialGains, @NotNull PosVelGain lateralGains, @NotNull PosVelGain headingGains) {
        Intrinsics.checkNotNullParameter((Object)axialGains, (String)"axialGains");
        Intrinsics.checkNotNullParameter((Object)lateralGains, (String)"lateralGains");
        Intrinsics.checkNotNullParameter((Object)headingGains, (String)"headingGains");
        this.axialGains = axialGains;
        this.lateralGains = lateralGains;
        this.headingGains = headingGains;
    }

    public HolonomicController(double axialPosGain, double lateralPosGain, double headingGain, double axialVelGain, double lateralVelGain, double headingVelGain) {
        this(new PosVelGain(axialPosGain, axialVelGain), new PosVelGain(lateralPosGain, lateralVelGain), new PosVelGain(headingGain, headingVelGain));
    }

    public HolonomicController(double axialPosGain, double lateralPosGain, double headingGain) {
        this(axialPosGain, lateralPosGain, headingGain, 0.0, 0.0, 0.0);
    }

    @Override
    @NotNull
    public PoseVelocity2dDual<Time> compute(@NotNull Pose2dDual<Time> targetPose, @NotNull Pose2d actualPose, @NotNull PoseVelocity2d actualVelActual) {
        Intrinsics.checkNotNullParameter(targetPose, (String)"targetPose");
        Intrinsics.checkNotNullParameter((Object)actualPose, (String)"actualPose");
        Intrinsics.checkNotNullParameter((Object)actualVelActual, (String)"actualVelActual");
        PoseVelocity2dDual<Time> targetVelWorld = targetPose.velocity();
        Pose2dDual<Time> txTargetWorld = Pose2dDual.Companion.constant(targetPose.value().inverse(), 2);
        PoseVelocity2dDual<Time> targetVelTarget = txTargetWorld.times(targetVelWorld);
        PoseVelocity2d velErrorActual = targetVelTarget.value().minus(actualVelActual);
        Pose2d error = targetPose.value().minusExp(actualPose);
        return targetVelTarget.plus(new PoseVelocity2d(new Vector2d(this.axialGains.posGain * error.position.x, this.lateralGains.posGain * error.position.y), this.headingGains.posGain * error.heading.log())).plus(new PoseVelocity2d(new Vector2d(this.axialGains.velGain * velErrorActual.linearVel.x, this.lateralGains.velGain * velErrorActual.linearVel.y), this.headingGains.velGain * velErrorActual.angVel));
    }
}

