/*
 * Decompiled with CFR 0.152.
 */
package gay.zharel.hermes.control;

import gay.zharel.hermes.control.LQRControllerKt;
import gay.zharel.hermes.control.RobotPosVelController;
import gay.zharel.hermes.geometry.Acceleration2d;
import gay.zharel.hermes.geometry.Pose2d;
import gay.zharel.hermes.geometry.Pose2dDual;
import gay.zharel.hermes.geometry.PoseVelocity2d;
import gay.zharel.hermes.geometry.PoseVelocity2dDual;
import gay.zharel.hermes.geometry.Twist2d;
import gay.zharel.hermes.geometry.Twist2dDual;
import gay.zharel.hermes.geometry.Vector2d;
import gay.zharel.hermes.math.DualParameter;
import gay.zharel.hermes.math.Matrices;
import gay.zharel.hermes.math.Matrix;
import gay.zharel.hermes.math.Time;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B[\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0004\b\r\u0010\u000eB3\b\u0017\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0010\u0012\u0006\u0010\u0013\u001a\u00020\u0010\u0012\b\b\u0002\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0004\b\r\u0010\u0014J\u000e\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0010J\u001e\u0010\u001b\u001a\u00020\u001d\"\b\b\u0000\u0010\u001e*\u00020\u001f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001e0 J,\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020#0%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016R\u000e\u0010\u0015\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001a\u00a8\u0006*"}, d2={"Lgay/zharel/hermes/control/LQRController;", "Lgay/zharel/hermes/control/RobotPosVelController;", "qX", "", "qY", "qHeading", "qVx", "qVy", "qOmega", "rAx", "rAy", "rAlpha", "dt", "<init>", "(DDDDDDDDDD)V", "A", "Lgay/zharel/hermes/math/Matrix;", "B", "Q", "R", "(Lgay/zharel/hermes/math/Matrix;Lgay/zharel/hermes/math/Matrix;Lgay/zharel/hermes/math/Matrix;Lgay/zharel/hermes/math/Matrix;D)V", "K", "timeSource", "Lkotlin/time/TimeSource$Monotonic;", "lastTimeStamp", "Lkotlin/time/TimeSource$Monotonic$ValueTimeMark;", "J", "update", "error", "Lgay/zharel/hermes/geometry/Acceleration2d;", "Param", "Lgay/zharel/hermes/math/DualParameter;", "Lgay/zharel/hermes/geometry/Twist2dDual;", "compute", "Lgay/zharel/hermes/geometry/PoseVelocity2dDual;", "Lgay/zharel/hermes/math/Time;", "targetPose", "Lgay/zharel/hermes/geometry/Pose2dDual;", "actualPose", "Lgay/zharel/hermes/geometry/Pose2d;", "actualVelActual", "Lgay/zharel/hermes/geometry/PoseVelocity2d;", "core"})
@SourceDebugExtension(value={"SMAP\nLQRController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LQRController.kt\ngay/zharel/hermes/control/LQRController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,313:1\n1#2:314\n*E\n"})
public final class LQRController
implements RobotPosVelController {
    @NotNull
    private final Matrix K;
    private final double dt;
    @NotNull
    private final TimeSource.Monotonic timeSource;
    private long lastTimeStamp;

    public LQRController(double qX, double qY, double qHeading, double qVx, double qVy, double qOmega, double rAx, double rAy, double rAlpha, double dt) {
        Matrix K;
        this.timeSource = TimeSource.Monotonic.INSTANCE;
        this.lastTimeStamp = this.timeSource.markNow-z9LOYto();
        Matrix A_cont = Matrix.Companion.zero(6, 6);
        A_cont.set(0, 3, 1.0);
        A_cont.set(1, 4, 1.0);
        A_cont.set(2, 5, 1.0);
        Matrix B_cont = Matrix.Companion.zero(6, 3);
        B_cont.set(3, 0, 1.0);
        B_cont.set(4, 1, 1.0);
        B_cont.set(5, 2, 1.0);
        Pair pair = LQRControllerKt.discretizeSystem$default(A_cont, B_cont, dt, 0, 8, null);
        Matrix Ad = (Matrix)pair.component1();
        Matrix Bd = (Matrix)pair.component2();
        double[] dArray = new double[]{qX, qY, qHeading, qVx, qVy, qOmega};
        Matrix Q = Matrices.makeBrysonMatrix(dArray);
        double[] dArray2 = new double[]{rAx, rAy, rAlpha};
        Matrix R = Matrices.makeBrysonMatrix(dArray2);
        this.K = K = (Matrix)LQRControllerKt.computeLQRGain$default(Ad, Bd, Q, R, 0, 0.0, 48, null).component2();
        this.dt = dt;
    }

    public /* synthetic */ LQRController(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x200) != 0) {
            d10 = 0.0303;
        }
        this(d, d2, d3, d4, d5, d6, d7, d8, d9, d10);
    }

    @JvmOverloads
    public LQRController(@NotNull Matrix A, @NotNull Matrix B, @NotNull Matrix Q, @NotNull Matrix R, double dt) {
        Matrix K;
        Intrinsics.checkNotNullParameter((Object)A, (String)"A");
        Intrinsics.checkNotNullParameter((Object)B, (String)"B");
        Intrinsics.checkNotNullParameter((Object)Q, (String)"Q");
        Intrinsics.checkNotNullParameter((Object)R, (String)"R");
        this.timeSource = TimeSource.Monotonic.INSTANCE;
        this.lastTimeStamp = this.timeSource.markNow-z9LOYto();
        if (!(dt > 0.0)) {
            boolean $i$a$-require-LQRController$42 = false;
            String $i$a$-require-LQRController$42 = "Time step (dt) must be positive";
            throw new IllegalArgumentException($i$a$-require-LQRController$42.toString());
        }
        if (!(A.numRows == A.numColumns && A.numRows == Q.numRows && Q.numRows == Q.numColumns)) {
            boolean $i$a$-require-LQRController$52 = false;
            String $i$a$-require-LQRController$52 = "A and Q must be square and match dimensions.";
            throw new IllegalArgumentException($i$a$-require-LQRController$52.toString());
        }
        if (!(B.numRows == A.numRows && B.numColumns == R.numRows && R.numRows == R.numColumns)) {
            boolean $i$a$-require-LQRController$62 = false;
            String $i$a$-require-LQRController$62 = "B and R must have compatible dimensions with A and each other.";
            throw new IllegalArgumentException($i$a$-require-LQRController$62.toString());
        }
        Pair pair = LQRControllerKt.discretizeSystem$default(A, B, dt, 0, 8, null);
        Matrix Ad = (Matrix)pair.component1();
        Matrix Bd = (Matrix)pair.component2();
        this.K = K = (Matrix)LQRControllerKt.computeLQRGain$default(Ad, Bd, Q, R, 0, 0.0, 48, null).component2();
        this.dt = dt;
    }

    public /* synthetic */ LQRController(Matrix matrix, Matrix matrix2, Matrix matrix3, Matrix matrix4, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            d = 0.0303;
        }
        this(matrix, matrix2, matrix3, matrix4, d);
    }

    @NotNull
    public final Matrix update(@NotNull Matrix error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        if (!(error.numColumns == this.K.numColumns)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.K.unaryMinus().times(error);
    }

    @NotNull
    public final <Param extends DualParameter> Acceleration2d update(@NotNull Twist2dDual<Param> error) {
        Intrinsics.checkNotNullParameter(error, (String)"error");
        if (!(LQRControllerKt.size(error) >= 2)) {
            boolean $i$a$-require-LQRController$update$22 = false;
            String $i$a$-require-LQRController$update$22 = "Position and velocity errors must be provided";
            throw new IllegalArgumentException($i$a$-require-LQRController$update$22.toString());
        }
        Twist2d posError = error.value();
        PoseVelocity2d velError = error.velocity().value();
        double[] dArray = new double[]{posError.line.x, posError.line.y, posError.angle, velError.linearVel.x, velError.linearVel.y, velError.angVel};
        Matrix input = Matrix.Companion.column(dArray);
        Matrix output = this.update(input);
        return new Acceleration2d(new Vector2d(output.get(0, 0), output.get(1, 0)), output.get(2, 0));
    }

    @Override
    @NotNull
    public PoseVelocity2dDual<Time> compute(@NotNull Pose2dDual<Time> targetPose, @NotNull Pose2d actualPose, @NotNull PoseVelocity2d actualVelActual) {
        Intrinsics.checkNotNullParameter(targetPose, (String)"targetPose");
        Intrinsics.checkNotNullParameter((Object)actualPose, (String)"actualPose");
        Intrinsics.checkNotNullParameter((Object)actualVelActual, (String)"actualVelActual");
        long newStamp = this.timeSource.markNow-z9LOYto();
        Twist2d posError = targetPose.value().minus(actualPose);
        PoseVelocity2d it = targetPose.velocity().value().minus(actualVelActual);
        boolean bl = false;
        Twist2d velError = new Twist2d(it.linearVel, it.angVel);
        Acceleration2d acc = this.update(LQRControllerKt.concat(posError, velError));
        double dt = Duration.toDouble-impl((long)TimeSource.Monotonic.ValueTimeMark.minus-6eNON_k((long)newStamp, (long)this.lastTimeStamp), (DurationUnit)DurationUnit.SECONDS);
        PoseVelocity2d vel = acc.integrateToVel(dt, actualVelActual);
        this.lastTimeStamp = newStamp;
        return LQRControllerKt.concat(vel, acc);
    }

    @JvmOverloads
    public LQRController(@NotNull Matrix A, @NotNull Matrix B, @NotNull Matrix Q, @NotNull Matrix R) {
        Intrinsics.checkNotNullParameter((Object)A, (String)"A");
        Intrinsics.checkNotNullParameter((Object)B, (String)"B");
        Intrinsics.checkNotNullParameter((Object)Q, (String)"Q");
        Intrinsics.checkNotNullParameter((Object)R, (String)"R");
        this(A, B, Q, R, 0.0, 16, null);
    }
}

