/*
 * Decompiled with CFR 0.152.
 */
package gay.zharel.hermes.control;

import gay.zharel.hermes.geometry.Acceleration2d;
import gay.zharel.hermes.geometry.PoseVelocity2d;
import gay.zharel.hermes.geometry.PoseVelocity2dDual;
import gay.zharel.hermes.geometry.Twist2d;
import gay.zharel.hermes.geometry.Twist2dDual;
import gay.zharel.hermes.geometry.Vector2d;
import gay.zharel.hermes.geometry.Vector2dDual;
import gay.zharel.hermes.math.DualNum;
import gay.zharel.hermes.math.DualParameter;
import gay.zharel.hermes.math.Matrix;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a<\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0000\u001aH\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u000b2\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0000\u001a6\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u000b2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\t2\b\b\u0002\u0010\u0010\u001a\u00020\u0007H\u0000\u001a$\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0012\"\b\b\u0000\u0010\u0013*\u00020\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0000\u001a$\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0017\"\b\b\u0000\u0010\u0013*\u00020\u0014*\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0018H\u0000\u001a$\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0019\"\b\b\u0000\u0010\u0013*\u00020\u0014*\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u001bH\u0000\u001a\u001c\u0010\u001c\u001a\u00020\u0007\"\b\b\u0000\u0010\u0013*\u00020\u0014*\b\u0012\u0004\u0012\u0002H\u00130\u0012H\u0000\u00a8\u0006\u001d"}, d2={"solveDARE", "Lgay/zharel/hermes/math/Matrix;", "Ad", "Bd", "Q", "R", "maxIter", "", "epsilon", "", "computeLQRGain", "Lkotlin/Pair;", "discretizeSystem", "A", "B", "dt", "taylorTerms", "concat", "Lgay/zharel/hermes/geometry/Twist2dDual;", "Param", "Lgay/zharel/hermes/math/DualParameter;", "Lgay/zharel/hermes/geometry/Twist2d;", "other", "Lgay/zharel/hermes/geometry/Vector2dDual;", "Lgay/zharel/hermes/geometry/Vector2d;", "Lgay/zharel/hermes/geometry/PoseVelocity2dDual;", "Lgay/zharel/hermes/geometry/PoseVelocity2d;", "Lgay/zharel/hermes/geometry/Acceleration2d;", "size", "core"})
public final class LQRControllerKt {
    @NotNull
    public static final Matrix solveDARE(@NotNull Matrix Ad, @NotNull Matrix Bd, @NotNull Matrix Q, @NotNull Matrix R, int maxIter, double epsilon) {
        Intrinsics.checkNotNullParameter((Object)Ad, (String)"Ad");
        Intrinsics.checkNotNullParameter((Object)Bd, (String)"Bd");
        Intrinsics.checkNotNullParameter((Object)Q, (String)"Q");
        Intrinsics.checkNotNullParameter((Object)R, (String)"R");
        Matrix A_K = Ad.copy();
        Matrix G_K = Bd.times(R.solve(Bd.transpose()));
        Matrix H_K1 = Q.copy();
        Matrix H_K = null;
        int i = 0;
        do {
            H_K = H_K1.copy();
            Matrix W = Matrix.Companion.identity(H_K.numRows).plus(G_K.times(H_K));
            Matrix v1 = W.solve(A_K);
            Matrix v2 = W.solve(G_K.transpose()).transpose();
            G_K = G_K.plus(A_K.times(v2).times(A_K.transpose()));
            H_K1 = H_K1.plus(v1.transpose().times(H_K).times(A_K));
            A_K = A_K.times(v1);
        } while (H_K1.minus(H_K).norm() > epsilon * H_K1.norm() && (maxIter < 0 || i++ < maxIter));
        return H_K1;
    }

    public static /* synthetic */ Matrix solveDARE$default(Matrix matrix, Matrix matrix2, Matrix matrix3, Matrix matrix4, int n, double d, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = -1;
        }
        if ((n2 & 0x20) != 0) {
            d = 1.0E-6;
        }
        return LQRControllerKt.solveDARE(matrix, matrix2, matrix3, matrix4, n, d);
    }

    @NotNull
    public static final Pair<Matrix, Matrix> computeLQRGain(@NotNull Matrix Ad, @NotNull Matrix Bd, @NotNull Matrix Q, @NotNull Matrix R, int maxIter, double epsilon) {
        Intrinsics.checkNotNullParameter((Object)Ad, (String)"Ad");
        Intrinsics.checkNotNullParameter((Object)Bd, (String)"Bd");
        Intrinsics.checkNotNullParameter((Object)Q, (String)"Q");
        Intrinsics.checkNotNullParameter((Object)R, (String)"R");
        Matrix X = LQRControllerKt.solveDARE(Ad, Bd, Q, R, maxIter, epsilon);
        Matrix btx = Bd.transpose().times(X);
        Matrix btxb = btx.times(Bd);
        Matrix K = R.plus(btxb).inverse().times(btx).times(Ad);
        return TuplesKt.to((Object)X, (Object)K);
    }

    public static /* synthetic */ Pair computeLQRGain$default(Matrix matrix, Matrix matrix2, Matrix matrix3, Matrix matrix4, int n, double d, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = -1;
        }
        if ((n2 & 0x20) != 0) {
            d = 1.0E-6;
        }
        return LQRControllerKt.computeLQRGain(matrix, matrix2, matrix3, matrix4, n, d);
    }

    @NotNull
    public static final Pair<Matrix, Matrix> discretizeSystem(@NotNull Matrix A, @NotNull Matrix B, double dt, int taylorTerms) {
        Intrinsics.checkNotNullParameter((Object)A, (String)"A");
        Intrinsics.checkNotNullParameter((Object)B, (String)"B");
        int n = A.numRows;
        Matrix Ad = Matrix.Companion.identity(n);
        Matrix Bd_integral = Matrix.Companion.identity(n).times(dt);
        Matrix APowerDt = A.times(dt);
        double dtPower = dt;
        double factorial = 1.0;
        int i = 1;
        if (i <= taylorTerms) {
            while (true) {
                Ad = Ad.plus(APowerDt.times(1.0 / factorial));
                dtPower *= dt;
                factorial *= (double)(i + 1);
                Bd_integral = Bd_integral.plus(APowerDt.times(dt / (double)(i + 1)));
                APowerDt = APowerDt.times(A.times(dt));
                factorial *= (double)(i + 1);
                if (i == taylorTerms) break;
                ++i;
            }
        }
        Matrix Bd = Bd_integral.times(B);
        return new Pair((Object)Ad, (Object)Bd);
    }

    public static /* synthetic */ Pair discretizeSystem$default(Matrix matrix, Matrix matrix2, double d, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = 10;
        }
        return LQRControllerKt.discretizeSystem(matrix, matrix2, d, n);
    }

    @NotNull
    public static final <Param extends DualParameter> Twist2dDual<Param> concat(@NotNull Twist2d $this$concat, @NotNull Twist2d other) {
        Intrinsics.checkNotNullParameter((Object)$this$concat, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        double[] dArray = new double[]{$this$concat.angle, other.angle};
        return new Twist2dDual<Param>(LQRControllerKt.concat($this$concat.line, other.line), new DualNum(dArray));
    }

    @NotNull
    public static final <Param extends DualParameter> Vector2dDual<Param> concat(@NotNull Vector2d $this$concat, @NotNull Vector2d other) {
        Intrinsics.checkNotNullParameter((Object)$this$concat, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        double[] dArray = new double[]{$this$concat.x, other.x};
        DualNum dualNum = new DualNum(dArray);
        dArray = new double[]{$this$concat.y, other.y};
        return new Vector2dDual(dualNum, new DualNum(dArray));
    }

    @NotNull
    public static final <Param extends DualParameter> PoseVelocity2dDual<Param> concat(@NotNull PoseVelocity2d $this$concat, @NotNull Acceleration2d other) {
        Intrinsics.checkNotNullParameter((Object)$this$concat, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        double[] dArray = new double[]{$this$concat.angVel, other.angAcc};
        return new PoseVelocity2dDual<Param>(LQRControllerKt.concat($this$concat.linearVel, other.linearAcc), new DualNum(dArray));
    }

    public static final <Param extends DualParameter> int size(@NotNull Twist2dDual<Param> $this$size) {
        Intrinsics.checkNotNullParameter($this$size, (String)"<this>");
        return $this$size.angle.size();
    }
}

