/*
 * Decompiled with CFR 0.152.
 */
package gay.zharel.hermes.control;

import gay.zharel.hermes.control.LQRControllerKt;
import gay.zharel.hermes.control.LTVUController;
import gay.zharel.hermes.control.RobotPosVelController;
import gay.zharel.hermes.geometry.Acceleration2d;
import gay.zharel.hermes.geometry.Pose2d;
import gay.zharel.hermes.geometry.Pose2dDual;
import gay.zharel.hermes.geometry.PoseVelocity2d;
import gay.zharel.hermes.geometry.PoseVelocity2dDual;
import gay.zharel.hermes.geometry.Twist2d;
import gay.zharel.hermes.geometry.Vector2d;
import gay.zharel.hermes.math.InterpolatingMap;
import gay.zharel.hermes.math.Math;
import gay.zharel.hermes.math.Matrices;
import gay.zharel.hermes.math.Matrix;
import gay.zharel.hermes.math.Time;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BS\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0004\b\f\u0010\rJ,\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lgay/zharel/hermes/control/LTVUController;", "Lgay/zharel/hermes/control/RobotPosVelController;", "qX", "", "qY", "qHeading", "qV", "qOmega", "rA", "rAlpha", "maxVel", "dt", "<init>", "(DDDDDDDDD)V", "timeSource", "Lkotlin/time/TimeSource$Monotonic;", "lastTimeStamp", "Lkotlin/time/TimeSource$Monotonic$ValueTimeMark;", "J", "times", "Lkotlin/collections/ArrayDeque;", "matrices", "Lgay/zharel/hermes/math/Matrix;", "interpolator", "Lgay/zharel/hermes/math/InterpolatingMap;", "compute", "Lgay/zharel/hermes/geometry/PoseVelocity2dDual;", "Lgay/zharel/hermes/math/Time;", "targetPose", "Lgay/zharel/hermes/geometry/Pose2dDual;", "actualPose", "Lgay/zharel/hermes/geometry/Pose2d;", "actualVelActual", "Lgay/zharel/hermes/geometry/PoseVelocity2d;", "core"})
@SourceDebugExtension(value={"SMAP\nLTVUController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LTVUController.kt\ngay/zharel/hermes/control/LTVUController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1563#2:130\n1634#2,3:131\n*S KotlinDebug\n*F\n+ 1 LTVUController.kt\ngay/zharel/hermes/control/LTVUController\n*L\n84#1:130\n84#1:131,3\n*E\n"})
public final class LTVUController
implements RobotPosVelController {
    @NotNull
    private final TimeSource.Monotonic timeSource;
    private long lastTimeStamp;
    @NotNull
    private final ArrayDeque<Double> times;
    @NotNull
    private final ArrayDeque<Matrix> matrices;
    @NotNull
    private final InterpolatingMap<Matrix> interpolator;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public LTVUController(double qX, double qY, double qHeading, double qV, double qOmega, double rA, double rAlpha, double maxVel, double dt) {
        void $this$mapTo$iv$iv;
        this.timeSource = TimeSource.Monotonic.INSTANCE;
        this.lastTimeStamp = this.timeSource.markNow-z9LOYto();
        this.times = new ArrayDeque();
        this.matrices = new ArrayDeque();
        this.interpolator = new InterpolatingMap(interpolator.1.INSTANCE);
        Matrix A_cont = Matrix.Companion.zero(5, 5);
        Matrix matrix = Matrix.Companion.zero(5, 2);
        Object $this$_init__u24lambda_u240 = matrix;
        boolean $i$a$-apply-LTVUController$B_cont$22 = false;
        ((Matrix)$this$_init__u24lambda_u240).set(0, 0, 1.0);
        ((Matrix)$this$_init__u24lambda_u240).set(1, 2, 1.0);
        Matrix B_cont = matrix;
        $this$_init__u24lambda_u240 = new double[5];
        $this$_init__u24lambda_u240[0] = qX;
        $this$_init__u24lambda_u240[1] = qY;
        $this$_init__u24lambda_u240[2] = qHeading;
        $this$_init__u24lambda_u240[3] = qV;
        $this$_init__u24lambda_u240[4] = qOmega;
        Matrix Q = Matrices.makeBrysonMatrix((double[])$this$_init__u24lambda_u240);
        double[] $i$a$-apply-LTVUController$B_cont$22 = new double[]{rA, rAlpha};
        Matrix R = Matrices.makeBrysonMatrix($i$a$-apply-LTVUController$B_cont$22);
        Iterable $this$map$iv = Math.rangeCentered(-maxVel, maxVel, 100);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            double d = ((Number)item$iv$iv).doubleValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            A_cont.set(1, 2, java.lang.Math.abs((double)it) < 1.0E-4 ? 1.0E-4 : it);
            Pair pair = LQRControllerKt.discretizeSystem$default(A_cont, B_cont, dt, 0, 8, null);
            Matrix Ad = (Matrix)pair.component1();
            Matrix Bd = (Matrix)pair.component2();
            Matrix K = (Matrix)LQRControllerKt.computeLQRGain$default(Ad, Bd, Q, R, 0, 0.0, 48, null).component2();
            this.times.add((Object)((double)it));
            collection.add(this.matrices.add((Object)K));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    public /* synthetic */ LTVUController(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x100) != 0) {
            d9 = 0.0303;
        }
        this(d, d2, d3, d4, d5, d6, d7, d8, d9);
    }

    @Override
    @NotNull
    public PoseVelocity2dDual<Time> compute(@NotNull Pose2dDual<Time> targetPose, @NotNull Pose2d actualPose, @NotNull PoseVelocity2d actualVelActual) {
        Intrinsics.checkNotNullParameter(targetPose, (String)"targetPose");
        Intrinsics.checkNotNullParameter((Object)actualPose, (String)"actualPose");
        Intrinsics.checkNotNullParameter((Object)actualVelActual, (String)"actualVelActual");
        long newStamp = this.timeSource.markNow-z9LOYto();
        PoseVelocity2d targetVel = targetPose.velocity().value();
        Twist2d posError = targetPose.value().minus(actualPose);
        PoseVelocity2d velError = targetPose.velocity().value().minus(actualVelActual);
        Matrix K = this.interpolator.get((Object)targetVel.linearVel.x);
        double[] dArray = new double[]{posError.line.x, posError.line.y, posError.angle, velError.linearVel.x, velError.angVel};
        Matrix error = Matrix.Companion.column(dArray);
        Matrix u = K.times(error);
        Acceleration2d acc = new Acceleration2d(new Vector2d(u.get(0, 0), 0.0), u.get(1, 0));
        double dt = Duration.toDouble-impl((long)TimeSource.Monotonic.ValueTimeMark.minus-6eNON_k((long)newStamp, (long)this.lastTimeStamp), (DurationUnit)DurationUnit.SECONDS);
        PoseVelocity2d vel = acc.integrateToVel(dt, actualVelActual);
        this.lastTimeStamp = newStamp;
        return LQRControllerKt.concat(vel, acc);
    }

    @JvmOverloads
    public LTVUController(double qX, double qY, double qHeading, double qV, double qOmega, double rA, double rAlpha, double maxVel) {
        this(qX, qY, qHeading, qV, qOmega, rA, rAlpha, maxVel, 0.0, 256, null);
    }
}

