/*
 * Decompiled with CFR 0.152.
 */
package gay.zharel.hermes.kinematics;

import gay.zharel.hermes.geometry.PoseVelocity2dDual;
import gay.zharel.hermes.geometry.Twist2dDual;
import gay.zharel.hermes.geometry.Vector2dDual;
import gay.zharel.hermes.kinematics.RobotKinematics;
import gay.zharel.hermes.kinematics.WheelIncrements;
import gay.zharel.hermes.kinematics.WheelVelocities;
import gay.zharel.hermes.math.DualNum;
import gay.zharel.hermes.math.DualParameter;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0001:\u0002!\"B#\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ$\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\b\b\u0000\u0010\r*\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J$\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\r0\u0010\"\b\b\u0000\u0010\r*\u00020\u000e2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0016J&\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\r0\u0013\"\b\b\u0000\u0010\r*\u00020\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\r0\u0010H\u0016J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lgay/zharel/hermes/kinematics/MecanumKinematics;", "Lgay/zharel/hermes/kinematics/RobotKinematics;", "Lgay/zharel/hermes/kinematics/MecanumKinematics$MecanumWheelIncrements;", "Lgay/zharel/hermes/kinematics/WheelVelocities;", "trackWidth", "", "wheelbase", "lateralMultiplier", "<init>", "(DDD)V", "effectiveRadius", "forward", "Lgay/zharel/hermes/geometry/Twist2dDual;", "Param", "Lgay/zharel/hermes/math/DualParameter;", "increments", "Lgay/zharel/hermes/geometry/PoseVelocity2dDual;", "velocities", "inverse", "Lgay/zharel/hermes/kinematics/MecanumKinematics$MecanumWheelVelocities;", "velocity", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "MecanumWheelIncrements", "MecanumWheelVelocities", "core"})
public final class MecanumKinematics
implements RobotKinematics<MecanumWheelIncrements<?>, WheelVelocities<?>> {
    @JvmField
    public final double trackWidth;
    @JvmField
    public final double wheelbase;
    @JvmField
    public final double lateralMultiplier;
    private final double effectiveRadius;

    @JvmOverloads
    public MecanumKinematics(double trackWidth, double wheelbase, double lateralMultiplier) {
        this.trackWidth = trackWidth;
        this.wheelbase = wheelbase;
        this.lateralMultiplier = lateralMultiplier;
        this.effectiveRadius = (this.trackWidth + this.wheelbase) / 2.0;
    }

    public /* synthetic */ MecanumKinematics(double d, double d2, double d3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            d3 = 1.0;
        }
        this(d, d2, d3);
    }

    @Override
    @NotNull
    public <Param extends DualParameter> Twist2dDual<Param> forward(@NotNull MecanumWheelIncrements<?> increments) {
        Intrinsics.checkNotNullParameter(increments, (String)"increments");
        return new Twist2dDual(new Vector2dDual(increments.leftFront.plus(increments.leftBack).plus(increments.rightBack).plus(increments.rightFront).times(0.25), increments.leftFront.unaryMinus().plus(increments.leftBack).minus(increments.rightBack).plus(increments.rightFront).times(0.25 / this.lateralMultiplier)), increments.leftFront.unaryMinus().minus(increments.leftBack).plus(increments.rightBack).plus(increments.rightFront).times(0.25 / this.effectiveRadius));
    }

    @Override
    @NotNull
    public <Param extends DualParameter> PoseVelocity2dDual<Param> forward(@NotNull WheelVelocities<?> velocities) {
        Intrinsics.checkNotNullParameter(velocities, (String)"velocities");
        MecanumWheelVelocities cfr_ignored_0 = (MecanumWheelVelocities)velocities;
        return new PoseVelocity2dDual(new Vector2dDual(((MecanumWheelVelocities)velocities).leftFront.plus(((MecanumWheelVelocities)velocities).leftBack).plus(((MecanumWheelVelocities)velocities).rightBack).plus(((MecanumWheelVelocities)velocities).rightFront).times(0.25), ((MecanumWheelVelocities)velocities).leftFront.unaryMinus().plus(((MecanumWheelVelocities)velocities).leftBack).minus(((MecanumWheelVelocities)velocities).rightBack).plus(((MecanumWheelVelocities)velocities).rightFront).times(0.25 / this.lateralMultiplier)), ((MecanumWheelVelocities)velocities).leftFront.unaryMinus().minus(((MecanumWheelVelocities)velocities).leftBack).plus(((MecanumWheelVelocities)velocities).rightBack).plus(((MecanumWheelVelocities)velocities).rightFront).times(0.25 / this.effectiveRadius));
    }

    @Override
    @NotNull
    public <Param extends DualParameter> MecanumWheelVelocities<Param> inverse(@NotNull PoseVelocity2dDual<Param> velocity) {
        Intrinsics.checkNotNullParameter(velocity, (String)"velocity");
        return new MecanumWheelVelocities(velocity.linearVel.x.minus(velocity.linearVel.y.times(this.lateralMultiplier)).minus(velocity.angVel.times(this.effectiveRadius)), velocity.linearVel.x.plus(velocity.linearVel.y.times(this.lateralMultiplier)).minus(velocity.angVel.times(this.effectiveRadius)), velocity.linearVel.x.minus(velocity.linearVel.y.times(this.lateralMultiplier)).plus(velocity.angVel.times(this.effectiveRadius)), velocity.linearVel.x.plus(velocity.linearVel.y.times(this.lateralMultiplier)).plus(velocity.angVel.times(this.effectiveRadius)));
    }

    public final double component1() {
        return this.trackWidth;
    }

    public final double component2() {
        return this.wheelbase;
    }

    public final double component3() {
        return this.lateralMultiplier;
    }

    @NotNull
    public final MecanumKinematics copy(double trackWidth, double wheelbase, double lateralMultiplier) {
        return new MecanumKinematics(trackWidth, wheelbase, lateralMultiplier);
    }

    public static /* synthetic */ MecanumKinematics copy$default(MecanumKinematics mecanumKinematics, double d, double d2, double d3, int n, Object object) {
        if ((n & 1) != 0) {
            d = mecanumKinematics.trackWidth;
        }
        if ((n & 2) != 0) {
            d2 = mecanumKinematics.wheelbase;
        }
        if ((n & 4) != 0) {
            d3 = mecanumKinematics.lateralMultiplier;
        }
        return mecanumKinematics.copy(d, d2, d3);
    }

    @NotNull
    public String toString() {
        return "MecanumKinematics(trackWidth=" + this.trackWidth + ", wheelbase=" + this.wheelbase + ", lateralMultiplier=" + this.lateralMultiplier + ")";
    }

    public int hashCode() {
        int result = Double.hashCode(this.trackWidth);
        result = result * 31 + Double.hashCode(this.wheelbase);
        result = result * 31 + Double.hashCode(this.lateralMultiplier);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MecanumKinematics)) {
            return false;
        }
        MecanumKinematics mecanumKinematics = (MecanumKinematics)other;
        if (Double.compare(this.trackWidth, mecanumKinematics.trackWidth) != 0) {
            return false;
        }
        if (Double.compare(this.wheelbase, mecanumKinematics.wheelbase) != 0) {
            return false;
        }
        return Double.compare(this.lateralMultiplier, mecanumKinematics.lateralMultiplier) == 0;
    }

    @JvmOverloads
    public MecanumKinematics(double trackWidth, double wheelbase) {
        this(trackWidth, wheelbase, 0.0, 4, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B?\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0003JO\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lgay/zharel/hermes/kinematics/MecanumKinematics$MecanumWheelIncrements;", "Param", "Lgay/zharel/hermes/math/DualParameter;", "Lgay/zharel/hermes/kinematics/WheelIncrements;", "leftFront", "Lgay/zharel/hermes/math/DualNum;", "leftBack", "rightBack", "rightFront", "<init>", "(Lgay/zharel/hermes/math/DualNum;Lgay/zharel/hermes/math/DualNum;Lgay/zharel/hermes/math/DualNum;Lgay/zharel/hermes/math/DualNum;)V", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "core"})
    public static final class MecanumWheelIncrements<Param extends DualParameter>
    implements WheelIncrements<Param> {
        @JvmField
        @NotNull
        public final DualNum<Param> leftFront;
        @JvmField
        @NotNull
        public final DualNum<Param> leftBack;
        @JvmField
        @NotNull
        public final DualNum<Param> rightBack;
        @JvmField
        @NotNull
        public final DualNum<Param> rightFront;

        public MecanumWheelIncrements(@NotNull DualNum<Param> leftFront, @NotNull DualNum<Param> leftBack, @NotNull DualNum<Param> rightBack, @NotNull DualNum<Param> rightFront) {
            Intrinsics.checkNotNullParameter(leftFront, (String)"leftFront");
            Intrinsics.checkNotNullParameter(leftBack, (String)"leftBack");
            Intrinsics.checkNotNullParameter(rightBack, (String)"rightBack");
            Intrinsics.checkNotNullParameter(rightFront, (String)"rightFront");
            this.leftFront = leftFront;
            this.leftBack = leftBack;
            this.rightBack = rightBack;
            this.rightFront = rightFront;
        }

        @NotNull
        public final DualNum<Param> component1() {
            return this.leftFront;
        }

        @NotNull
        public final DualNum<Param> component2() {
            return this.leftBack;
        }

        @NotNull
        public final DualNum<Param> component3() {
            return this.rightBack;
        }

        @NotNull
        public final DualNum<Param> component4() {
            return this.rightFront;
        }

        @NotNull
        public final MecanumWheelIncrements<Param> copy(@NotNull DualNum<Param> leftFront, @NotNull DualNum<Param> leftBack, @NotNull DualNum<Param> rightBack, @NotNull DualNum<Param> rightFront) {
            Intrinsics.checkNotNullParameter(leftFront, (String)"leftFront");
            Intrinsics.checkNotNullParameter(leftBack, (String)"leftBack");
            Intrinsics.checkNotNullParameter(rightBack, (String)"rightBack");
            Intrinsics.checkNotNullParameter(rightFront, (String)"rightFront");
            return new MecanumWheelIncrements<Param>(leftFront, leftBack, rightBack, rightFront);
        }

        public static /* synthetic */ MecanumWheelIncrements copy$default(MecanumWheelIncrements mecanumWheelIncrements, DualNum dualNum, DualNum dualNum2, DualNum dualNum3, DualNum dualNum4, int n, Object object) {
            if ((n & 1) != 0) {
                dualNum = mecanumWheelIncrements.leftFront;
            }
            if ((n & 2) != 0) {
                dualNum2 = mecanumWheelIncrements.leftBack;
            }
            if ((n & 4) != 0) {
                dualNum3 = mecanumWheelIncrements.rightBack;
            }
            if ((n & 8) != 0) {
                dualNum4 = mecanumWheelIncrements.rightFront;
            }
            return mecanumWheelIncrements.copy(dualNum, dualNum2, dualNum3, dualNum4);
        }

        @NotNull
        public String toString() {
            return "MecanumWheelIncrements(leftFront=" + this.leftFront + ", leftBack=" + this.leftBack + ", rightBack=" + this.rightBack + ", rightFront=" + this.rightFront + ")";
        }

        public int hashCode() {
            int result = this.leftFront.hashCode();
            result = result * 31 + this.leftBack.hashCode();
            result = result * 31 + this.rightBack.hashCode();
            result = result * 31 + this.rightFront.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MecanumWheelIncrements)) {
                return false;
            }
            MecanumWheelIncrements mecanumWheelIncrements = (MecanumWheelIncrements)other;
            if (!Intrinsics.areEqual(this.leftFront, mecanumWheelIncrements.leftFront)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.leftBack, mecanumWheelIncrements.leftBack)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.rightBack, mecanumWheelIncrements.rightBack)) {
                return false;
            }
            return Intrinsics.areEqual(this.rightFront, mecanumWheelIncrements.rightFront);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B?\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0014\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0003JO\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lgay/zharel/hermes/kinematics/MecanumKinematics$MecanumWheelVelocities;", "Param", "Lgay/zharel/hermes/math/DualParameter;", "Lgay/zharel/hermes/kinematics/WheelVelocities;", "leftFront", "Lgay/zharel/hermes/math/DualNum;", "leftBack", "rightBack", "rightFront", "<init>", "(Lgay/zharel/hermes/math/DualNum;Lgay/zharel/hermes/math/DualNum;Lgay/zharel/hermes/math/DualNum;Lgay/zharel/hermes/math/DualNum;)V", "all", "", "desaturate", "maxPhysicalSpeed", "", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "core"})
    @SourceDebugExtension(value={"SMAP\nMecanumKinematics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MecanumKinematics.kt\ngay/zharel/hermes/kinematics/MecanumKinematics$MecanumWheelVelocities\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
    public static final class MecanumWheelVelocities<Param extends DualParameter>
    implements WheelVelocities<Param> {
        @JvmField
        @NotNull
        public final DualNum<Param> leftFront;
        @JvmField
        @NotNull
        public final DualNum<Param> leftBack;
        @JvmField
        @NotNull
        public final DualNum<Param> rightBack;
        @JvmField
        @NotNull
        public final DualNum<Param> rightFront;

        public MecanumWheelVelocities(@NotNull DualNum<Param> leftFront, @NotNull DualNum<Param> leftBack, @NotNull DualNum<Param> rightBack, @NotNull DualNum<Param> rightFront) {
            Intrinsics.checkNotNullParameter(leftFront, (String)"leftFront");
            Intrinsics.checkNotNullParameter(leftBack, (String)"leftBack");
            Intrinsics.checkNotNullParameter(rightBack, (String)"rightBack");
            Intrinsics.checkNotNullParameter(rightFront, (String)"rightFront");
            this.leftFront = leftFront;
            this.leftBack = leftBack;
            this.rightBack = rightBack;
            this.rightFront = rightFront;
        }

        @Override
        @NotNull
        public List<DualNum<Param>> all() {
            Object[] objectArray = new DualNum[]{this.leftFront, this.leftBack, this.rightBack, this.rightFront};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @Override
        @NotNull
        public WheelVelocities<Param> desaturate(double maxPhysicalSpeed) {
            Iterator iterator = ((Iterable)this.all()).iterator();
            if (!iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            DualNum it = (DualNum)iterator.next();
            boolean bl = false;
            double d = Math.abs(it.value());
            while (iterator.hasNext()) {
                DualNum it2 = (DualNum)iterator.next();
                $i$a$-maxOf-MecanumKinematics$MecanumWheelVelocities$desaturate$realMax$1 = false;
                double d2 = Math.abs(it2.value());
                d = Math.max(d, d2);
            }
            double realMax = d;
            return realMax > maxPhysicalSpeed ? (WheelVelocities)new MecanumWheelVelocities<Param>(this.leftFront.times(maxPhysicalSpeed).div(realMax), this.leftBack.times(maxPhysicalSpeed).div(realMax), this.rightBack.times(maxPhysicalSpeed).div(realMax), this.rightFront.times(maxPhysicalSpeed).div(realMax)) : (WheelVelocities)this;
        }

        @NotNull
        public final DualNum<Param> component1() {
            return this.leftFront;
        }

        @NotNull
        public final DualNum<Param> component2() {
            return this.leftBack;
        }

        @NotNull
        public final DualNum<Param> component3() {
            return this.rightBack;
        }

        @NotNull
        public final DualNum<Param> component4() {
            return this.rightFront;
        }

        @NotNull
        public final MecanumWheelVelocities<Param> copy(@NotNull DualNum<Param> leftFront, @NotNull DualNum<Param> leftBack, @NotNull DualNum<Param> rightBack, @NotNull DualNum<Param> rightFront) {
            Intrinsics.checkNotNullParameter(leftFront, (String)"leftFront");
            Intrinsics.checkNotNullParameter(leftBack, (String)"leftBack");
            Intrinsics.checkNotNullParameter(rightBack, (String)"rightBack");
            Intrinsics.checkNotNullParameter(rightFront, (String)"rightFront");
            return new MecanumWheelVelocities<Param>(leftFront, leftBack, rightBack, rightFront);
        }

        public static /* synthetic */ MecanumWheelVelocities copy$default(MecanumWheelVelocities mecanumWheelVelocities, DualNum dualNum, DualNum dualNum2, DualNum dualNum3, DualNum dualNum4, int n, Object object) {
            if ((n & 1) != 0) {
                dualNum = mecanumWheelVelocities.leftFront;
            }
            if ((n & 2) != 0) {
                dualNum2 = mecanumWheelVelocities.leftBack;
            }
            if ((n & 4) != 0) {
                dualNum3 = mecanumWheelVelocities.rightBack;
            }
            if ((n & 8) != 0) {
                dualNum4 = mecanumWheelVelocities.rightFront;
            }
            return mecanumWheelVelocities.copy(dualNum, dualNum2, dualNum3, dualNum4);
        }

        @NotNull
        public String toString() {
            return "MecanumWheelVelocities(leftFront=" + this.leftFront + ", leftBack=" + this.leftBack + ", rightBack=" + this.rightBack + ", rightFront=" + this.rightFront + ")";
        }

        public int hashCode() {
            int result = this.leftFront.hashCode();
            result = result * 31 + this.leftBack.hashCode();
            result = result * 31 + this.rightBack.hashCode();
            result = result * 31 + this.rightFront.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MecanumWheelVelocities)) {
                return false;
            }
            MecanumWheelVelocities mecanumWheelVelocities = (MecanumWheelVelocities)other;
            if (!Intrinsics.areEqual(this.leftFront, mecanumWheelVelocities.leftFront)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.leftBack, mecanumWheelVelocities.leftBack)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.rightBack, mecanumWheelVelocities.rightBack)) {
                return false;
            }
            return Intrinsics.areEqual(this.rightFront, mecanumWheelVelocities.rightFront);
        }
    }
}

