/*
 * Decompiled with CFR 0.152.
 */
package gay.zharel.hermes.kinematics;

import gay.zharel.hermes.math.DualNum;
import gay.zharel.hermes.math.Time;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003J\u0014\u0010\b\u001a\u00020\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0016\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003J\u0016\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lgay/zharel/hermes/kinematics/MotorFeedforward;", "", "kS", "", "kV", "kA", "<init>", "(DDD)V", "compute", "vel", "accel", "Lgay/zharel/hermes/math/DualNum;", "Lgay/zharel/hermes/math/Time;", "maxAchievableAcceleration", "maxVoltage", "velocity", "minAchievableAcceleration", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "core"})
public final class MotorFeedforward {
    @JvmField
    public final double kS;
    @JvmField
    public final double kV;
    @JvmField
    public final double kA;

    public MotorFeedforward(double kS, double kV, double kA) {
        this.kS = kS;
        this.kV = kV;
        this.kA = kA;
    }

    public final double compute(double vel, double accel) {
        return Math.copySign(this.kS, vel) + this.kV * vel + this.kA * accel;
    }

    public final double compute(@NotNull DualNum<Time> vel) {
        Intrinsics.checkNotNullParameter(vel, (String)"vel");
        return this.compute(vel.get(0), vel.get(1));
    }

    public final double maxAchievableAcceleration(double maxVoltage, double velocity) {
        return (maxVoltage - this.kS * Math.signum(velocity) - velocity * this.kV) / this.kA;
    }

    public final double minAchievableAcceleration(double maxVoltage, double velocity) {
        return this.maxAchievableAcceleration(-maxVoltage, velocity);
    }

    public final double component1() {
        return this.kS;
    }

    public final double component2() {
        return this.kV;
    }

    public final double component3() {
        return this.kA;
    }

    @NotNull
    public final MotorFeedforward copy(double kS, double kV, double kA) {
        return new MotorFeedforward(kS, kV, kA);
    }

    public static /* synthetic */ MotorFeedforward copy$default(MotorFeedforward motorFeedforward, double d, double d2, double d3, int n, Object object) {
        if ((n & 1) != 0) {
            d = motorFeedforward.kS;
        }
        if ((n & 2) != 0) {
            d2 = motorFeedforward.kV;
        }
        if ((n & 4) != 0) {
            d3 = motorFeedforward.kA;
        }
        return motorFeedforward.copy(d, d2, d3);
    }

    @NotNull
    public String toString() {
        return "MotorFeedforward(kS=" + this.kS + ", kV=" + this.kV + ", kA=" + this.kA + ")";
    }

    public int hashCode() {
        int result = Double.hashCode(this.kS);
        result = result * 31 + Double.hashCode(this.kV);
        result = result * 31 + Double.hashCode(this.kA);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MotorFeedforward)) {
            return false;
        }
        MotorFeedforward motorFeedforward = (MotorFeedforward)other;
        if (Double.compare(this.kS, motorFeedforward.kS) != 0) {
            return false;
        }
        if (Double.compare(this.kV, motorFeedforward.kV) != 0) {
            return false;
        }
        return Double.compare(this.kA, motorFeedforward.kA) == 0;
    }
}

