/*
 * Decompiled with CFR 0.152.
 */
package gay.zharel.hermes.kinematics;

import gay.zharel.hermes.geometry.PoseVelocity2dDual;
import gay.zharel.hermes.geometry.Twist2dDual;
import gay.zharel.hermes.geometry.Vector2d;
import gay.zharel.hermes.geometry.Vector2dDual;
import gay.zharel.hermes.kinematics.RobotKinematics;
import gay.zharel.hermes.kinematics.SwerveModuleIncrements;
import gay.zharel.hermes.kinematics.SwerveModuleState;
import gay.zharel.hermes.kinematics.WheelIncrements;
import gay.zharel.hermes.kinematics.WheelVelocities;
import gay.zharel.hermes.math.DualNum;
import gay.zharel.hermes.math.DualNumKt;
import gay.zharel.hermes.math.DualParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0001:\u0002 !B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJh\u0010\t\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u000b0\n\"\b\b\u0000\u0010\f*\u00020\r20\u0010\u000e\u001a,\u0012(\u0012&\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u000b0\n0\u0005H\u0002J$\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\f0\u0010\"\b\b\u0000\u0010\f*\u00020\r2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J$\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\f0\u0012\"\b\b\u0000\u0010\f*\u00020\r2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0016J&\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\f0\u0003\"\b\b\u0000\u0010\f*\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\f0\u0012H\u0016J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u0019\u0010\u0017\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lgay/zharel/hermes/kinematics/SwerveKinematics;", "Lgay/zharel/hermes/kinematics/RobotKinematics;", "Lgay/zharel/hermes/kinematics/SwerveKinematics$SwerveWheelIncrements;", "Lgay/zharel/hermes/kinematics/SwerveKinematics$SwerveWheelVelocities;", "modules", "", "Lgay/zharel/hermes/geometry/Vector2d;", "<init>", "(Ljava/util/List;)V", "averageModuleContributions", "Lkotlin/Triple;", "Lgay/zharel/hermes/math/DualNum;", "Param", "Lgay/zharel/hermes/math/DualParameter;", "moduleContributions", "forward", "Lgay/zharel/hermes/geometry/Twist2dDual;", "increments", "Lgay/zharel/hermes/geometry/PoseVelocity2dDual;", "velocities", "inverse", "velocity", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "SwerveWheelIncrements", "SwerveWheelVelocities", "core"})
@SourceDebugExtension(value={"SMAP\nSwerveKinematics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwerveKinematics.kt\ngay/zharel/hermes/kinematics/SwerveKinematics\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,201:1\n3550#2,7:202\n3550#2,7:209\n1869#2,2:216\n1563#2:218\n1634#2,3:219\n*S KotlinDebug\n*F\n+ 1 SwerveKinematics.kt\ngay/zharel/hermes/kinematics/SwerveKinematics\n*L\n94#1:202,7\n143#1:209,7\n175#1:216,2\n196#1:218\n196#1:219,3\n*E\n"})
public final class SwerveKinematics
implements RobotKinematics<SwerveWheelIncrements<?>, SwerveWheelVelocities<?>> {
    @JvmField
    @NotNull
    public final List<Vector2d> modules;

    public SwerveKinematics(@NotNull List<Vector2d> modules) {
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        this.modules = modules;
    }

    private final <Param extends DualParameter> Triple<DualNum<Param>, DualNum<Param>, DualNum<Param>> averageModuleContributions(List<Triple<DualNum<Param>, DualNum<Param>, DualNum<Param>>> moduleContributions) {
        double numModules = this.modules.size();
        DualNum sumX = (DualNum)moduleContributions.get(0).getFirst();
        DualNum sumY = (DualNum)moduleContributions.get(0).getSecond();
        DualNum sumAngular = (DualNum)moduleContributions.get(0).getThird();
        int n = moduleContributions.size();
        for (int i = 1; i < n; ++i) {
            sumX = sumX.plus((DualNum)moduleContributions.get(i).getFirst());
            sumY = sumY.plus((DualNum)moduleContributions.get(i).getSecond());
            sumAngular = sumAngular.plus((DualNum)moduleContributions.get(i).getThird());
        }
        return new Triple(sumX.div(numModules), sumY.div(numModules), sumAngular.div(numModules));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <Param extends DualParameter> Twist2dDual<Param> forward(@NotNull SwerveWheelIncrements<?> increments) {
        void $this$zip$iv;
        Intrinsics.checkNotNullParameter(increments, (String)"increments");
        Triple<DualNum<Param>, DualNum<Param>, DualNum<Param>> triple = (Triple<DualNum<Param>, DualNum<Param>, DualNum<Param>>)this.modules;
        Iterable other$iv = increments.deltas;
        boolean $i$f$zip = false;
        Iterator first$iv = $this$zip$iv.iterator();
        Iterator second$iv = other$iv.iterator();
        ArrayList<Triple> list$iv = new ArrayList<Triple>(Math.min(CollectionsKt.collectionSizeOrDefault((Iterable)$this$zip$iv, (int)10), CollectionsKt.collectionSizeOrDefault((Iterable)other$iv, (int)10)));
        while (first$iv.hasNext() && second$iv.hasNext()) {
            void module;
            void delta;
            SwerveModuleIncrements swerveModuleIncrements = (SwerveModuleIncrements)second$iv.next();
            Vector2d vector2d = (Vector2d)first$iv.next();
            ArrayList<Triple> arrayList = list$iv;
            boolean bl = false;
            double cosAngle = Math.cos(delta.angle);
            double sinAngle = Math.sin(delta.angle);
            DualNum moduleX = delta.wheelDelta.times(cosAngle);
            DualNum moduleY = delta.wheelDelta.times(sinAngle);
            double rSquared = module.x * module.x + module.y * module.y;
            DualNum angularContribution = rSquared > 1.0E-9 ? moduleY.times(module.x).minus(moduleX.times(module.y)).div(rSquared) : delta.wheelDelta.times(0.0);
            arrayList.add(new Triple(moduleX, moduleY, angularContribution));
        }
        List contributions = list$iv;
        triple = this.averageModuleContributions(contributions);
        DualNum avgX = (DualNum)triple.component1();
        DualNum avgY = (DualNum)triple.component2();
        DualNum avgAngular = (DualNum)triple.component3();
        return new Twist2dDual(new Vector2dDual(avgX, avgY), avgAngular);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <Param extends DualParameter> PoseVelocity2dDual<Param> forward(@NotNull SwerveWheelVelocities<?> velocities) {
        void $this$zip$iv;
        Intrinsics.checkNotNullParameter(velocities, (String)"velocities");
        Triple<DualNum<Param>, DualNum<Param>, DualNum<Param>> triple = (Triple<DualNum<Param>, DualNum<Param>, DualNum<Param>>)this.modules;
        Iterable other$iv = velocities.states;
        boolean $i$f$zip = false;
        Iterator first$iv = $this$zip$iv.iterator();
        Iterator second$iv = other$iv.iterator();
        ArrayList<Triple> list$iv = new ArrayList<Triple>(Math.min(CollectionsKt.collectionSizeOrDefault((Iterable)$this$zip$iv, (int)10), CollectionsKt.collectionSizeOrDefault((Iterable)other$iv, (int)10)));
        while (first$iv.hasNext() && second$iv.hasNext()) {
            void module;
            void state;
            SwerveModuleState swerveModuleState = (SwerveModuleState)second$iv.next();
            Vector2d vector2d = (Vector2d)first$iv.next();
            ArrayList<Triple> arrayList = list$iv;
            boolean bl = false;
            DualNum cosAngle = state.angle.cos();
            DualNum sinAngle = state.angle.sin();
            DualNum moduleX = state.velocity.times(cosAngle);
            DualNum moduleY = state.velocity.times(sinAngle);
            double rSquared = module.x * module.x + module.y * module.y;
            DualNum angularContribution = rSquared > 1.0E-9 ? moduleY.times(module.x).minus(moduleX.times(module.y)).div(rSquared) : state.velocity.times(0.0);
            arrayList.add(new Triple(moduleX, moduleY, angularContribution));
        }
        List contributions = list$iv;
        triple = this.averageModuleContributions(contributions);
        DualNum avgX = (DualNum)triple.component1();
        DualNum avgY = (DualNum)triple.component2();
        DualNum avgAngular = (DualNum)triple.component3();
        return new PoseVelocity2dDual(new Vector2dDual(avgX, avgY), avgAngular);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <Param extends DualParameter> SwerveWheelVelocities<Param> inverse(@NotNull PoseVelocity2dDual<Param> velocity) {
        void $this$mapTo$iv$iv;
        Pair rotVelY;
        Intrinsics.checkNotNullParameter(velocity, (String)"velocity");
        List wheelVels = new ArrayList();
        List steeringAngles = new ArrayList();
        Iterable $this$forEach$iv = this.modules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Vector2d module = (Vector2d)element$iv;
            boolean bl = false;
            DualNum rotVelX = velocity.angVel.times(-module.y);
            rotVelY = velocity.angVel.times(module.x);
            DualNum totalVelX = velocity.linearVel.x.plus(rotVelX);
            DualNum totalVelY = velocity.linearVel.y.plus(rotVelY);
            DualNum wheelVel = totalVelX.times(totalVelX).plus(totalVelY.times(totalVelY)).sqrt();
            wheelVels.add(wheelVel);
            DualNum steeringAngle = DualNumKt.atan2(totalVelY, totalVelX);
            steeringAngles.add(steeringAngle);
        }
        Iterable $this$map$iv = CollectionsKt.zip((Iterable)wheelVels, (Iterable)steeringAngles);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            rotVelY = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SwerveModuleState((DualNum)it.getFirst(), (DualNum)it.getSecond()));
        }
        List list = (List)destination$iv$iv;
        return new SwerveWheelVelocities(list);
    }

    @NotNull
    public final List<Vector2d> component1() {
        return this.modules;
    }

    @NotNull
    public final SwerveKinematics copy(@NotNull List<Vector2d> modules) {
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        return new SwerveKinematics(modules);
    }

    public static /* synthetic */ SwerveKinematics copy$default(SwerveKinematics swerveKinematics, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = swerveKinematics.modules;
        }
        return swerveKinematics.copy(list);
    }

    @NotNull
    public String toString() {
        return "SwerveKinematics(modules=" + this.modules + ")";
    }

    public int hashCode() {
        return ((Object)this.modules).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SwerveKinematics)) {
            return false;
        }
        SwerveKinematics swerveKinematics = (SwerveKinematics)other;
        return Intrinsics.areEqual(this.modules, swerveKinematics.modules);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005H\u00c6\u0003J%\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u001c\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lgay/zharel/hermes/kinematics/SwerveKinematics$SwerveWheelIncrements;", "Param", "Lgay/zharel/hermes/math/DualParameter;", "Lgay/zharel/hermes/kinematics/WheelIncrements;", "deltas", "", "Lgay/zharel/hermes/kinematics/SwerveModuleIncrements;", "<init>", "(Ljava/util/List;)V", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "core"})
    public static final class SwerveWheelIncrements<Param extends DualParameter>
    implements WheelIncrements<Param> {
        @JvmField
        @NotNull
        public final List<SwerveModuleIncrements<Param>> deltas;

        public SwerveWheelIncrements(@NotNull List<SwerveModuleIncrements<Param>> deltas) {
            Intrinsics.checkNotNullParameter(deltas, (String)"deltas");
            this.deltas = deltas;
        }

        @NotNull
        public final List<SwerveModuleIncrements<Param>> component1() {
            return this.deltas;
        }

        @NotNull
        public final SwerveWheelIncrements<Param> copy(@NotNull List<SwerveModuleIncrements<Param>> deltas) {
            Intrinsics.checkNotNullParameter(deltas, (String)"deltas");
            return new SwerveWheelIncrements<Param>(deltas);
        }

        public static /* synthetic */ SwerveWheelIncrements copy$default(SwerveWheelIncrements swerveWheelIncrements, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = swerveWheelIncrements.deltas;
            }
            return swerveWheelIncrements.copy(list);
        }

        @NotNull
        public String toString() {
            return "SwerveWheelIncrements(deltas=" + this.deltas + ")";
        }

        public int hashCode() {
            return ((Object)this.deltas).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SwerveWheelIncrements)) {
                return false;
            }
            SwerveWheelIncrements swerveWheelIncrements = (SwerveWheelIncrements)other;
            return Intrinsics.areEqual(this.deltas, swerveWheelIncrements.deltas);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\u0005H\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\f\u001a\u00020\rH\u0016J\u0015\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005H\u00c6\u0003J%\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u001c\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lgay/zharel/hermes/kinematics/SwerveKinematics$SwerveWheelVelocities;", "Param", "Lgay/zharel/hermes/math/DualParameter;", "Lgay/zharel/hermes/kinematics/WheelVelocities;", "states", "", "Lgay/zharel/hermes/kinematics/SwerveModuleState;", "<init>", "(Ljava/util/List;)V", "all", "Lgay/zharel/hermes/math/DualNum;", "desaturate", "maxPhysicalSpeed", "", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "core"})
    @SourceDebugExtension(value={"SMAP\nSwerveKinematics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwerveKinematics.kt\ngay/zharel/hermes/kinematics/SwerveKinematics$SwerveWheelVelocities\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,201:1\n1563#2:202\n1634#2,3:203\n1563#2:207\n1634#2,3:208\n1#3:206\n*S KotlinDebug\n*F\n+ 1 SwerveKinematics.kt\ngay/zharel/hermes/kinematics/SwerveKinematics$SwerveWheelVelocities\n*L\n125#1:202\n125#1:203,3\n131#1:207\n131#1:208,3\n*E\n"})
    public static final class SwerveWheelVelocities<Param extends DualParameter>
    implements WheelVelocities<Param> {
        @JvmField
        @NotNull
        public final List<SwerveModuleState<Param>> states;

        public SwerveWheelVelocities(@NotNull List<SwerveModuleState<Param>> states) {
            Intrinsics.checkNotNullParameter(states, (String)"states");
            this.states = states;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<DualNum<Param>> all() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.states;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SwerveModuleState swerveModuleState = (SwerveModuleState)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.velocity);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public SwerveWheelVelocities<Param> desaturate(double maxPhysicalSpeed) {
            SwerveWheelVelocities swerveWheelVelocities;
            Iterator iterator = ((Iterable)this.all()).iterator();
            if (!iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            Object it = (DualNum)iterator.next();
            boolean bl = false;
            double d = Math.abs(((DualNum)it).value());
            while (iterator.hasNext()) {
                DualNum it2 = (DualNum)iterator.next();
                swerveModuleState = false;
                double d2 = Math.abs(it2.value());
                d = Math.max(d, d2);
            }
            double realMax = d;
            if (realMax > maxPhysicalSpeed) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.states;
                boolean $i$f$map = false;
                it = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it3;
                    SwerveModuleState swerveModuleState = (SwerveModuleState)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(SwerveModuleState.copy$default((SwerveModuleState)it3, it3.velocity.times(maxPhysicalSpeed).div(realMax), null, 2, null));
                }
                List list = (List)destination$iv$iv;
                swerveWheelVelocities = new SwerveWheelVelocities<Param>(list);
            } else {
                swerveWheelVelocities = this;
            }
            return swerveWheelVelocities;
        }

        @NotNull
        public final List<SwerveModuleState<Param>> component1() {
            return this.states;
        }

        @NotNull
        public final SwerveWheelVelocities<Param> copy(@NotNull List<SwerveModuleState<Param>> states) {
            Intrinsics.checkNotNullParameter(states, (String)"states");
            return new SwerveWheelVelocities<Param>(states);
        }

        public static /* synthetic */ SwerveWheelVelocities copy$default(SwerveWheelVelocities swerveWheelVelocities, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = swerveWheelVelocities.states;
            }
            return swerveWheelVelocities.copy(list);
        }

        @NotNull
        public String toString() {
            return "SwerveWheelVelocities(states=" + this.states + ")";
        }

        public int hashCode() {
            return ((Object)this.states).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SwerveWheelVelocities)) {
                return false;
            }
            SwerveWheelVelocities swerveWheelVelocities = (SwerveWheelVelocities)other;
            return Intrinsics.areEqual(this.states, swerveWheelVelocities.states);
        }
    }
}

