/*
 * Decompiled with CFR 0.152.
 */
package gay.zharel.hermes.kinematics;

import gay.zharel.hermes.geometry.Pose2d;
import gay.zharel.hermes.geometry.PoseVelocity2d;
import gay.zharel.hermes.geometry.PoseVelocity2dDual;
import gay.zharel.hermes.geometry.RobotState;
import gay.zharel.hermes.kinematics.MotorFeedforward;
import gay.zharel.hermes.kinematics.RobotKinematics;
import gay.zharel.hermes.kinematics.WheelIncrements;
import gay.zharel.hermes.kinematics.WheelVelocities;
import gay.zharel.hermes.math.DualNum;
import gay.zharel.hermes.math.MinMax;
import gay.zharel.hermes.paths.PosePath;
import gay.zharel.hermes.profiles.AccelConstraint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u0002*\f\b\u0001\u0010\u0003*\u0006\u0012\u0002\b\u00030\u00042\u00020\u0005B+\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0016R\u001c\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lgay/zharel/hermes/kinematics/VoltageConstraint;", "WI", "Lgay/zharel/hermes/kinematics/WheelIncrements;", "WV", "Lgay/zharel/hermes/kinematics/WheelVelocities;", "Lgay/zharel/hermes/profiles/AccelConstraint;", "kinematics", "Lgay/zharel/hermes/kinematics/RobotKinematics;", "feedforward", "Lgay/zharel/hermes/kinematics/MotorFeedforward;", "maxVoltage", "", "<init>", "(Lgay/zharel/hermes/kinematics/RobotKinematics;Lgay/zharel/hermes/kinematics/MotorFeedforward;D)V", "minMaxProfileAccel", "Lgay/zharel/hermes/math/MinMax;", "robotState", "Lgay/zharel/hermes/geometry/RobotState;", "path", "Lgay/zharel/hermes/paths/PosePath;", "s", "core"})
@SourceDebugExtension(value={"SMAP\nKinematicConstraints.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KinematicConstraints.kt\ngay/zharel/hermes/kinematics/VoltageConstraint\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n1563#2:128\n1634#2,3:129\n1563#2:132\n1634#2,3:133\n1563#2:136\n1634#2,3:137\n*S KotlinDebug\n*F\n+ 1 KinematicConstraints.kt\ngay/zharel/hermes/kinematics/VoltageConstraint\n*L\n79#1:128\n79#1:129,3\n81#1:132\n81#1:133,3\n82#1:136\n82#1:137,3\n*E\n"})
public final class VoltageConstraint<WI extends WheelIncrements<?>, WV extends WheelVelocities<?>>
implements AccelConstraint {
    @JvmField
    @NotNull
    public final RobotKinematics<WI, WV> kinematics;
    @JvmField
    @NotNull
    public final MotorFeedforward feedforward;
    @JvmField
    public final double maxVoltage;

    public VoltageConstraint(@NotNull RobotKinematics<? super WI, ? super WV> kinematics, @NotNull MotorFeedforward feedforward, double maxVoltage) {
        Intrinsics.checkNotNullParameter(kinematics, (String)"kinematics");
        Intrinsics.checkNotNullParameter((Object)feedforward, (String)"feedforward");
        this.kinematics = kinematics;
        this.feedforward = feedforward;
        this.maxVoltage = maxVoltage;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MinMax minMaxProfileAccel(@NotNull RobotState robotState, @NotNull PosePath path, double s) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        Collection collection;
        void $this$mapTo$iv$iv3;
        Intrinsics.checkNotNullParameter((Object)robotState, (String)"robotState");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Pose2d txRobotWorld = robotState.pose.inverse();
        PoseVelocity2d robotVelWorld = robotState.vel;
        PoseVelocity2d robotVelRobot = txRobotWorld.times(robotVelWorld);
        WheelVelocities wheelVelocities = this.kinematics.inverse(PoseVelocity2dDual.Companion.constant(robotVelRobot, 1));
        Intrinsics.checkNotNull(wheelVelocities, (String)"null cannot be cast to non-null type WV of gay.zharel.hermes.kinematics.VoltageConstraint");
        WheelVelocities wheelVels = wheelVelocities;
        Iterable $this$map$iv = wheelVels.all();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            DualNum dualNum = (DualNum)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.value());
        }
        List wheelVelValues = (List)destination$iv$iv;
        Iterable $this$map$iv2 = wheelVelValues;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void v;
            double bl = ((Number)item$iv$iv).doubleValue();
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(this.feedforward.maxAchievableAcceleration(this.maxVoltage, (double)v));
        }
        List maxWheelAccels = (List)destination$iv$iv2;
        Iterable $this$map$iv3 = wheelVelValues;
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void v;
            double d = ((Number)item$iv$iv).doubleValue();
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(this.feedforward.minAchievableAcceleration(this.maxVoltage, (double)v));
        }
        List minWheelAccels = (List)destination$iv$iv3;
        DualNum vVar = DualNum.Companion.variable(0.0, 2);
        PoseVelocity2dDual velDual = new PoseVelocity2dDual(vVar.times(robotVelRobot.linearVel), vVar.times(robotVelRobot.angVel));
        List wheelVelsDual = this.kinematics.inverse(velDual).all();
        double asMin = Double.NEGATIVE_INFINITY;
        double asMax = Double.POSITIVE_INFINITY;
        double eps = 1.0E-9;
        int n = ((Collection)wheelVelsDual).size();
        for (int i = 0; i < n; ++i) {
            double Ai = wheelVelsDual.get(i).get(1);
            double wMin = ((Number)minWheelAccels.get(i)).doubleValue();
            double wMax = ((Number)maxWheelAccels.get(i)).doubleValue();
            if (Math.abs(Ai) < eps) continue;
            double bound1 = wMin / Ai;
            double bound2 = wMax / Ai;
            double lo = Math.min(bound1, bound2);
            double hi = Math.max(bound1, bound2);
            if (lo > asMin) {
                asMin = lo;
            }
            if (!(hi < asMax)) continue;
            asMax = hi;
        }
        if (asMin > asMax) {
            double mid;
            asMin = mid = 0.0;
            asMax = mid;
        }
        return new MinMax(asMin, asMax);
    }
}

