/*
 * Decompiled with CFR 0.152.
 */
package gay.zharel.hermes.kinematics;

import gay.zharel.hermes.geometry.Pose2d;
import gay.zharel.hermes.geometry.PoseVelocity2d;
import gay.zharel.hermes.geometry.PoseVelocity2dDual;
import gay.zharel.hermes.geometry.RobotState;
import gay.zharel.hermes.kinematics.RobotKinematics;
import gay.zharel.hermes.kinematics.WheelIncrements;
import gay.zharel.hermes.kinematics.WheelVelocities;
import gay.zharel.hermes.paths.PosePath;
import gay.zharel.hermes.profiles.VelConstraint;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u0002*\f\b\u0001\u0010\u0003*\u0006\u0012\u0002\b\u00030\u00042\u00020\u0005B#\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ \u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0016R\u001c\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lgay/zharel/hermes/kinematics/WheelVelConstraint;", "WI", "Lgay/zharel/hermes/kinematics/WheelIncrements;", "WV", "Lgay/zharel/hermes/kinematics/WheelVelocities;", "Lgay/zharel/hermes/profiles/VelConstraint;", "kinematics", "Lgay/zharel/hermes/kinematics/RobotKinematics;", "maxWheelVel", "", "<init>", "(Lgay/zharel/hermes/kinematics/RobotKinematics;D)V", "maxRobotVel", "robotState", "Lgay/zharel/hermes/geometry/RobotState;", "path", "Lgay/zharel/hermes/paths/PosePath;", "s", "core"})
public final class WheelVelConstraint<WI extends WheelIncrements<?>, WV extends WheelVelocities<?>>
implements VelConstraint {
    @JvmField
    @NotNull
    public final RobotKinematics<WI, WV> kinematics;
    @JvmField
    public final double maxWheelVel;

    public WheelVelConstraint(@NotNull RobotKinematics<? super WI, ? super WV> kinematics, double maxWheelVel) {
        Intrinsics.checkNotNullParameter(kinematics, (String)"kinematics");
        this.kinematics = kinematics;
        this.maxWheelVel = maxWheelVel;
    }

    @Override
    public double maxRobotVel(@NotNull RobotState robotState, @NotNull PosePath path, double s) {
        Intrinsics.checkNotNullParameter((Object)robotState, (String)"robotState");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Pose2d txRobotWorld = robotState.pose.inverse();
        PoseVelocity2d robotVelWorld = robotState.vel;
        PoseVelocity2d robotVelRobot = txRobotWorld.times(robotVelWorld);
        WheelVelocities wheelVelocities = this.kinematics.inverse(PoseVelocity2dDual.Companion.constant(robotVelRobot, 1)).desaturate(this.maxWheelVel);
        Intrinsics.checkNotNull(wheelVelocities, (String)"null cannot be cast to non-null type WV of gay.zharel.hermes.kinematics.WheelVelConstraint");
        WheelVelocities wheelVels = wheelVelocities;
        PoseVelocity2dDual poseVel = this.kinematics.forward(wheelVels);
        return poseVel.linearVel.norm().value();
    }
}

