/*
 * Decompiled with CFR 0.152.
 */
package gay.zharel.hermes.math;

import gay.zharel.hermes.math.IntegralScanResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u001e\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001\u001a$\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r\u001a$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r\u001a2\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00012\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0015\u001a\n\u0010\u0016\u001a\u00020\r*\u00020\r\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"EPS", "", "snz", "x", "sinc", "clamp", "lo", "hi", "range", "", "begin", "end", "samples", "", "rangeCentered", "integralScan", "Lgay/zharel/hermes/math/IntegralScanResult;", "a", "b", "eps", "f", "Lkotlin/Function1;", "fact", "core"})
@JvmName(name="Math")
@SourceDebugExtension(value={"SMAP\nMathUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MathUtil.kt\ngay/zharel/hermes/math/Math\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n1#2:194\n1563#3:195\n1634#3,3:196\n1563#3:199\n1634#3,3:200\n*S KotlinDebug\n*F\n+ 1 MathUtil.kt\ngay/zharel/hermes/math/Math\n*L\n87#1:195\n87#1:196,3\n104#1:199\n104#1:200,3\n*E\n"})
public final class Math {
    private static final double EPS = 2.2E-15;

    public static final double snz(double x) {
        return x >= 0.0 ? 2.2E-15 : -2.2E-15;
    }

    public static final double sinc(double x) {
        double u = x + Math.snz(x);
        return java.lang.Math.sin(u) / u;
    }

    public static final double clamp(double x, double lo, double hi) {
        if (x < lo) {
            return lo;
        }
        if (x > hi) {
            return hi;
        }
        return x;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Double> range(double begin, double end, int samples) {
        void $this$mapTo$iv$iv;
        if (!(samples >= 2)) {
            boolean bl = false;
            String string = "Number of samples (" + samples + ") must be at least 2";
            throw new IllegalArgumentException(string.toString());
        }
        double dx = (end - begin) / (double)(samples - 1);
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)samples);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(begin + dx * (double)it);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Double> rangeCentered(double begin, double end, int samples) {
        void $this$mapTo$iv$iv;
        if (!(samples >= 1)) {
            boolean bl = false;
            String string = "Number of samples must be at least 1";
            throw new IllegalArgumentException(string.toString());
        }
        double dx = (end - begin) / (double)samples;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)samples);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(begin + 0.5 * dx + dx * (double)it);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final IntegralScanResult integralScan(double a, double b, double eps, @NotNull Function1<? super Double, Double> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        double m = (a + b) / (double)2;
        double fa = ((Number)f.invoke((Object)a)).doubleValue();
        double fm = ((Number)f.invoke((Object)m)).doubleValue();
        double fb = ((Number)f.invoke((Object)b)).doubleValue();
        Ref.DoubleRef i = new Ref.DoubleRef();
        i.element = (b - a) / (double)8 * (fa + fm + fb + ((Number)f.invoke((Object)(a + 0.9501 * (b - a)))).doubleValue() + ((Number)f.invoke((Object)(a + 0.2311 * (b - a)))).doubleValue() + ((Number)f.invoke((Object)(a + 0.6068 * (b - a)))).doubleValue() + ((Number)f.invoke((Object)(a + 0.486 * (b - a)))).doubleValue() + ((Number)f.invoke((Object)(a + 0.8913 * (b - a)))).doubleValue());
        if (i.element == 0.0) {
            i.element = b - a;
        }
        i.element *= eps / java.lang.Math.ulp(1.0);
        Object[] objectArray = new Double[]{0.0};
        List values = CollectionsKt.mutableListOf((Object[])objectArray);
        Object[] objectArray2 = new Double[]{0.0};
        List sums = CollectionsKt.mutableListOf((Object[])objectArray2);
        Math.integralScan$helper(f, i, values, sums, a, m, b, fa, fm, fb);
        return new IntegralScanResult(values, sums);
    }

    public static final int fact(int $this$fact) {
        if (!($this$fact >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return switch ($this$fact) {
            case 0 -> 1;
            case 1 -> 1;
            default -> $this$fact * Math.fact($this$fact - 1);
        };
    }

    private static final void integralScan$helper(Function1<? super Double, Double> $f, Ref.DoubleRef i, List<Double> values, List<Double> sums, double a, double m, double b, double fa, double fm, double fb) {
        double h = (b - a) / (double)4;
        double ml = a + h;
        double mr = b - h;
        double fml = ((Number)$f.invoke((Object)ml)).doubleValue();
        double fmr = ((Number)$f.invoke((Object)mr)).doubleValue();
        double i1 = h / 1.5 * (fa + (double)4 * fm + fb);
        double i2 = h / (double)3 * (fa + (double)4 * (fml + fmr) + (double)2 * fm + fb);
        if (i.element + ((i1 = ((double)16 * i2 - i1) / (double)15) - i2) == i.element || m <= a || b <= m) {
            values.add(b);
            sums.add(((Number)CollectionsKt.last(sums)).doubleValue() + i1);
        } else {
            Math.integralScan$helper($f, i, values, sums, a, ml, m, fa, fml, fm);
            Math.integralScan$helper($f, i, values, sums, m, mr, b, fm, fmr, fb);
        }
    }
}

