/*
 * Decompiled with CFR 0.152.
 */
package gay.zharel.hermes.math;

import gay.zharel.hermes.math.LDLTDecomposition;
import gay.zharel.hermes.math.LLTDecomposition;
import gay.zharel.hermes.math.LUDecomposition;
import gay.zharel.hermes.math.Matrices;
import gay.zharel.hermes.math.QRDecomposition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.decomposition.chol.CholeskyDecompositionInner_DDRM;
import org.ejml.dense.row.decomposition.chol.CholeskyDecompositionLDL_DDRM;
import org.ejml.dense.row.decomposition.lu.LUDecompositionAlt_DDRM;
import org.ejml.dense.row.decomposition.qr.QRDecompositionHouseholder_DDRM;
import org.ejml.interfaces.decomposition.CholeskyDecomposition;
import org.ejml.simple.ConstMatrix;
import org.ejml.simple.SimpleBase;
import org.ejml.simple.SimpleMatrix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 >2\u00020\u0001:\u0001>B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0017\b\u0016\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\u0004\u0010\tB\u001d\b\u0016\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\n\u00a2\u0006\u0004\b\u0004\u0010\fJ\u0006\u0010\u0016\u001a\u00020\u0000J\t\u0010\u001b\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u000bH\u0086\u0002J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0010H\u0086\u0002J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0000J\u0019\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0010H\u0086\u0002J!\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u000bH\u0086\u0002J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u0010J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u0010J\u0006\u0010+\u001a\u00020\u0000J&\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u00102\u0006\u0010.\u001a\u00020\u00102\u0006\u0010/\u001a\u00020\u00102\u0006\u00100\u001a\u00020\u0010J\u0006\u00101\u001a\u000202J\u0006\u00103\u001a\u000204J\u0006\u00105\u001a\u000206J\u0006\u00107\u001a\u000208J\b\u00109\u001a\u00020:H\u0016J\u0013\u0010;\u001a\u00020<2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010=\u001a\u00020\u0010H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u00020\u00108\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00108\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u00138\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00008G\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0017\u001a\u00020\u00008G\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0018\u001a\u00020\u00008G\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0015R\u0011\u0010\u0019\u001a\u00020\u000b8G\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006?"}, d2={"Lgay/zharel/hermes/math/Matrix;", "", "simple", "Lorg/ejml/simple/SimpleMatrix;", "<init>", "(Lorg/ejml/simple/SimpleMatrix;)V", "data", "", "", "([[D)V", "", "", "(Ljava/util/Collection;)V", "getSimple$core", "()Lorg/ejml/simple/SimpleMatrix;", "numColumns", "", "numRows", "size", "Lkotlin/Pair;", "transpose", "()Lgay/zharel/hermes/math/Matrix;", "copy", "inverse", "pseudoInverse", "norm", "()D", "unaryMinus", "plus", "other", "minus", "times", "scalar", "solve", "get", "i", "j", "set", "", "value", "row", "n", "column", "diagonals", "slice", "startRow", "endRow", "startCol", "endCol", "llt", "Lgay/zharel/hermes/math/LLTDecomposition;", "ldlt", "Lgay/zharel/hermes/math/LDLTDecomposition;", "lu", "Lgay/zharel/hermes/math/LUDecomposition;", "qr", "Lgay/zharel/hermes/math/QRDecomposition;", "toString", "", "equals", "", "hashCode", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nMatrices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Matrices.kt\ngay/zharel/hermes/math/Matrix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,399:1\n1563#2:400\n1634#2,3:401\n37#3:404\n36#3,3:405\n1#4:408\n*S KotlinDebug\n*F\n+ 1 Matrices.kt\ngay/zharel/hermes/math/Matrix\n*L\n41#1:400\n41#1:401,3\n41#1:404\n41#1:405,3\n*E\n"})
public final class Matrix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SimpleMatrix simple;
    @JvmField
    public final int numColumns;
    @JvmField
    public final int numRows;
    @JvmField
    @NotNull
    public final Pair<Integer, Integer> size;

    public Matrix(@NotNull SimpleMatrix simple) {
        Intrinsics.checkNotNullParameter((Object)simple, (String)"simple");
        this.simple = simple;
        this.numColumns = this.simple.getNumCols();
        this.numRows = this.simple.getNumRows();
        this.size = TuplesKt.to((Object)this.numRows, (Object)this.numColumns);
    }

    @NotNull
    public final SimpleMatrix getSimple$core() {
        return this.simple;
    }

    public Matrix(@NotNull double[][] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this(new SimpleMatrix(data));
    }

    /*
     * WARNING - void declaration
     */
    public Matrix(@NotNull Collection<? extends Collection<Double>> data) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Iterable iterable = data;
        Matrix matrix = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Collection collection = (Collection)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(CollectionsKt.toDoubleArray((Collection)it));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        matrix((double[][])thisCollection$iv.toArray((T[])new double[0][]));
    }

    @JvmName(name="transpose")
    @NotNull
    public final Matrix transpose() {
        SimpleBase simpleBase = this.simple.transpose();
        Intrinsics.checkNotNullExpressionValue((Object)simpleBase, (String)"transpose(...)");
        return new Matrix((SimpleMatrix)simpleBase);
    }

    @NotNull
    public final Matrix copy() {
        SimpleBase simpleBase = this.simple.copy();
        Intrinsics.checkNotNullExpressionValue((Object)simpleBase, (String)"copy(...)");
        return new Matrix((SimpleMatrix)simpleBase);
    }

    @JvmName(name="inverse")
    @NotNull
    public final Matrix inverse() {
        SimpleBase simpleBase = this.simple.invert();
        Intrinsics.checkNotNullExpressionValue((Object)simpleBase, (String)"invert(...)");
        return new Matrix((SimpleMatrix)simpleBase);
    }

    @JvmName(name="pseudoInverse")
    @NotNull
    public final Matrix pseudoInverse() {
        SimpleBase simpleBase = this.simple.pseudoInverse();
        Intrinsics.checkNotNullExpressionValue((Object)simpleBase, (String)"pseudoInverse(...)");
        return new Matrix((SimpleMatrix)simpleBase);
    }

    @JvmName(name="norm")
    public final double norm() {
        return this.simple.normF();
    }

    @NotNull
    public final Matrix unaryMinus() {
        return new Matrix(Matrices.unaryMinus(this.simple));
    }

    @NotNull
    public final Matrix plus(@NotNull Matrix other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        SimpleBase simpleBase = this.simple.plus((ConstMatrix)other.simple);
        Intrinsics.checkNotNullExpressionValue((Object)simpleBase, (String)"plus(...)");
        return new Matrix((SimpleMatrix)simpleBase);
    }

    @NotNull
    public final Matrix minus(@NotNull Matrix other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        SimpleBase simpleBase = this.simple.minus((ConstMatrix)other.simple);
        Intrinsics.checkNotNullExpressionValue((Object)simpleBase, (String)"minus(...)");
        return new Matrix((SimpleMatrix)simpleBase);
    }

    @NotNull
    public final Matrix times(@NotNull Matrix other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Matrix(Matrices.times(this.simple, other.simple));
    }

    @NotNull
    public final Matrix times(double scalar) {
        return new Matrix(Matrices.times(this.simple, scalar));
    }

    @NotNull
    public final Matrix times(int scalar) {
        return new Matrix(Matrices.times(this.simple, scalar));
    }

    @NotNull
    public final Matrix solve(@NotNull Matrix other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        SimpleBase simpleBase = this.simple.solve((ConstMatrix)other.simple);
        Intrinsics.checkNotNullExpressionValue((Object)simpleBase, (String)"solve(...)");
        return new Matrix((SimpleMatrix)simpleBase);
    }

    public final double get(int i, int j) {
        return this.simple.get(i, j);
    }

    public final void set(int i, int j, double value) {
        this.simple.set(i, j, value);
    }

    @NotNull
    public final Matrix row(int n) {
        SimpleBase simpleBase = this.simple.getRow(n);
        Intrinsics.checkNotNullExpressionValue((Object)simpleBase, (String)"getRow(...)");
        return new Matrix((SimpleMatrix)simpleBase);
    }

    @NotNull
    public final Matrix column(int n) {
        SimpleBase simpleBase = this.simple.getColumn(n);
        Intrinsics.checkNotNullExpressionValue((Object)simpleBase, (String)"getColumn(...)");
        return new Matrix((SimpleMatrix)simpleBase);
    }

    @NotNull
    public final Matrix diagonals() {
        SimpleBase simpleBase = this.simple.diag();
        Intrinsics.checkNotNullExpressionValue((Object)simpleBase, (String)"diag(...)");
        return new Matrix((SimpleMatrix)simpleBase);
    }

    @NotNull
    public final Matrix slice(int startRow, int endRow, int startCol, int endCol) {
        SimpleBase simpleBase = this.simple.extractMatrix(startRow, endRow, startCol, endCol);
        Intrinsics.checkNotNullExpressionValue((Object)simpleBase, (String)"extractMatrix(...)");
        return new Matrix((SimpleMatrix)simpleBase);
    }

    @NotNull
    public final LLTDecomposition llt() {
        CholeskyDecompositionInner_DDRM chol = new CholeskyDecompositionInner_DDRM(true);
        DMatrixRMaj mat = this.simple.getDDRM().copy();
        if (!chol.decompose(mat)) {
            boolean bl = false;
            String string = "Matrix is not symmetric positive-definite";
            throw new IllegalArgumentException(string.toString());
        }
        CholeskyDecomposition choleskyDecomposition = (CholeskyDecomposition)chol;
        Intrinsics.checkNotNull((Object)mat);
        return new LLTDecomposition((CholeskyDecomposition<DMatrixRMaj>)choleskyDecomposition, mat);
    }

    @NotNull
    public final LDLTDecomposition ldlt() {
        CholeskyDecompositionLDL_DDRM ldlt = new CholeskyDecompositionLDL_DDRM();
        DMatrixRMaj mat = this.simple.getDDRM().copy();
        if (!ldlt.decompose(mat)) {
            boolean bl = false;
            String string = "Matrix is not positive definite";
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)mat);
        return new LDLTDecomposition(ldlt, mat);
    }

    @NotNull
    public final LUDecomposition lu() {
        LUDecompositionAlt_DDRM lu = new LUDecompositionAlt_DDRM();
        DMatrixRMaj mat = this.simple.getDDRM().copy();
        if (!lu.decompose(mat)) {
            boolean bl = false;
            String string = "Matrix is singular or not square";
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)mat);
        return new LUDecomposition(lu, mat);
    }

    @NotNull
    public final QRDecomposition qr() {
        QRDecompositionHouseholder_DDRM qr = new QRDecompositionHouseholder_DDRM();
        DMatrixRMaj mat = this.simple.getDDRM().copy();
        if (!qr.decompose(mat)) {
            boolean bl = false;
            String string = "QR decomposition failed";
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)mat);
        return new QRDecomposition(qr, mat);
    }

    @NotNull
    public String toString() {
        return ArraysKt.contentDeepToString((Object[])((Object[])this.simple.toArray2()));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Matrix && this.simple.isIdentical((ConstMatrix)((Matrix)other).simple, 1.0E-6);
    }

    public int hashCode() {
        return this.simple.hashCode();
    }

    @JvmStatic
    @NotNull
    public static final Matrix zero(int rows, int cols) {
        return Companion.zero(rows, cols);
    }

    @JvmStatic
    @NotNull
    public static final Matrix zero(int size) {
        return Companion.zero(size);
    }

    @JvmStatic
    @NotNull
    public static final Matrix identity(int size) {
        return Companion.identity(size);
    }

    @JvmStatic
    @NotNull
    public static final Matrix diagonal(double ... data) {
        return Companion.diagonal(data);
    }

    @JvmStatic
    @NotNull
    public static final Matrix diagonal(@NotNull Collection<Double> data) {
        return Companion.diagonal(data);
    }

    @JvmStatic
    @NotNull
    public static final Matrix row(double ... data) {
        return Companion.row(data);
    }

    @JvmStatic
    @NotNull
    public static final Matrix row(@NotNull Collection<Double> data) {
        return Companion.row(data);
    }

    @JvmStatic
    @NotNull
    public static final Matrix column(double ... data) {
        return Companion.column(data);
    }

    @JvmStatic
    @NotNull
    public static final Matrix column(@NotNull Collection<Double> data) {
        return Companion.column(data);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0013\n\u0002\u0010\u0006\n\u0002\u0010\u001e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0007J\u0014\u0010\u000b\u001a\u00020\u00052\n\u0010\f\u001a\u00020\r\"\u00020\u000eH\u0007J\u0016\u0010\u000b\u001a\u00020\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000fH\u0007J\u0014\u0010\u0010\u001a\u00020\u00052\n\u0010\f\u001a\u00020\r\"\u00020\u000eH\u0007J\u0016\u0010\u0010\u001a\u00020\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000fH\u0007J\u0014\u0010\u0011\u001a\u00020\u00052\n\u0010\f\u001a\u00020\r\"\u00020\u000eH\u0007J\u0016\u0010\u0011\u001a\u00020\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000fH\u0007\u00a8\u0006\u0012"}, d2={"Lgay/zharel/hermes/math/Matrix$Companion;", "", "<init>", "()V", "zero", "Lgay/zharel/hermes/math/Matrix;", "rows", "", "cols", "size", "identity", "diagonal", "data", "", "", "", "row", "column", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Matrix zero(int rows, int cols) {
            return new Matrix(new SimpleMatrix(rows, cols));
        }

        @JvmStatic
        @NotNull
        public final Matrix zero(int size) {
            return this.zero(size, size);
        }

        @JvmStatic
        @NotNull
        public final Matrix identity(int size) {
            SimpleMatrix simpleMatrix = SimpleMatrix.identity((int)size);
            Intrinsics.checkNotNullExpressionValue((Object)simpleMatrix, (String)"identity(...)");
            return new Matrix(simpleMatrix);
        }

        @JvmStatic
        @NotNull
        public final Matrix diagonal(double ... data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            SimpleMatrix simpleMatrix = SimpleMatrix.diag((double[])Arrays.copyOf(data, data.length));
            Intrinsics.checkNotNullExpressionValue((Object)simpleMatrix, (String)"diag(...)");
            return new Matrix(simpleMatrix);
        }

        @JvmStatic
        @NotNull
        public final Matrix diagonal(@NotNull Collection<Double> data) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            double[] dArray = CollectionsKt.toDoubleArray(data);
            return this.diagonal(Arrays.copyOf(dArray, dArray.length));
        }

        @JvmStatic
        @NotNull
        public final Matrix row(double ... data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return new Matrix(new SimpleMatrix(1, data.length, true, Arrays.copyOf(data, data.length)));
        }

        @JvmStatic
        @NotNull
        public final Matrix row(@NotNull Collection<Double> data) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            double[] dArray = CollectionsKt.toDoubleArray(data);
            return this.row(Arrays.copyOf(dArray, dArray.length));
        }

        @JvmStatic
        @NotNull
        public final Matrix column(double ... data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return new Matrix(new SimpleMatrix(data.length, 1, false, Arrays.copyOf(data, data.length)));
        }

        @JvmStatic
        @NotNull
        public final Matrix column(@NotNull Collection<Double> data) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            double[] dArray = CollectionsKt.toDoubleArray(data);
            return this.column(Arrays.copyOf(dArray, dArray.length));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

