/*
 * Decompiled with CFR 0.152.
 */
package gay.zharel.hermes.profiles;

import gay.zharel.hermes.geometry.RobotState;
import gay.zharel.hermes.paths.PosePath;
import gay.zharel.hermes.profiles.VelConstraint;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0016R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lgay/zharel/hermes/profiles/CompositeVelConstraint;", "Lgay/zharel/hermes/profiles/VelConstraint;", "constraints", "", "offsets", "", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "maxRobotVel", "robotState", "Lgay/zharel/hermes/geometry/RobotState;", "path", "Lgay/zharel/hermes/paths/PosePath;", "s", "core"})
public final class CompositeVelConstraint
implements VelConstraint {
    @JvmField
    @NotNull
    public final List<VelConstraint> constraints;
    @JvmField
    @NotNull
    public final List<Double> offsets;

    public CompositeVelConstraint(@NotNull List<? extends VelConstraint> constraints, @NotNull List<Double> offsets) {
        Intrinsics.checkNotNullParameter(constraints, (String)"constraints");
        Intrinsics.checkNotNullParameter(offsets, (String)"offsets");
        this.constraints = constraints;
        this.offsets = offsets;
        if (!(this.constraints.size() + 1 == this.offsets.size())) {
            boolean bl = false;
            String string = "constraints.size() (" + this.constraints.size() + ") + 1 != offsets.size() (" + this.offsets.size() + ")";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public double maxRobotVel(@NotNull RobotState robotState, @NotNull PosePath path, double s) {
        Intrinsics.checkNotNullParameter((Object)robotState, (String)"robotState");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        for (Pair pair : CollectionsKt.reversed((Iterable)CollectionsKt.drop((Iterable)CollectionsKt.zip((Iterable)this.offsets, (Iterable)this.constraints), (int)1))) {
            double offset = ((Number)pair.component1()).doubleValue();
            VelConstraint constraint = (VelConstraint)pair.component2();
            if (!(s >= offset)) continue;
            return constraint.maxRobotVel(robotState, path, s);
        }
        return ((VelConstraint)CollectionsKt.first(this.constraints)).maxRobotVel(robotState, path, s);
    }
}

