/*
 * Decompiled with CFR 0.152.
 */
package gay.zharel.hermes.profiles;

import gay.zharel.hermes.geometry.Pose2dDual;
import gay.zharel.hermes.geometry.RobotState;
import gay.zharel.hermes.math.Arclength;
import gay.zharel.hermes.math.Math;
import gay.zharel.hermes.paths.PosePath;
import gay.zharel.hermes.profiles.AccelConstraint;
import gay.zharel.hermes.profiles.DisplacementProfile;
import gay.zharel.hermes.profiles.ProfileGenerationKt;
import gay.zharel.hermes.profiles.ProfileMergingKt;
import gay.zharel.hermes.profiles.ProfileParams;
import gay.zharel.hermes.profiles.Profiles;
import gay.zharel.hermes.profiles.VelConstraint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a.\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a.\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001aD\u0010\u0011\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00100\u00122\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001aD\u0010\u0014\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00100\u00122\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\"\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\u0006\u0010\u0016\u001a\u00020\u0007\u001aF\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u001a2\u0006\u0010\u001c\u001a\u00020\u0007\u001aF\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00072\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u001a2\u0006\u0010\u000e\u001a\u00020\u00072\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u001a2\u0006\u0010\u001c\u001a\u00020\u0007\u00a8\u0006\u001f"}, d2={"createOptimalDisplacementProfile", "Lgay/zharel/hermes/profiles/DisplacementProfile;", "params", "Lgay/zharel/hermes/profiles/ProfileParams;", "path", "Lgay/zharel/hermes/paths/PosePath;", "beginVel", "", "velConstraint", "Lgay/zharel/hermes/profiles/VelConstraint;", "accelConstraint", "Lgay/zharel/hermes/profiles/AccelConstraint;", "generatePathBasedForwardProfile", "generatePathBasedBackwardProfile", "endVel", "generatePathSamples", "", "evaluateConstraintsAtSamples", "Lkotlin/Pair;", "samples", "evaluateBackwardConstraintsAtSamples", "createDisplacementPoints", "pathLength", "createSimpleDisplacementProfile", "length", "maxVel", "Lkotlin/Function1;", "maxAccel", "resolution", "generateSimpleBackwardProfile", "minAccel", "core"})
@SourceDebugExtension(value={"SMAP\nPathBasedProfiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathBasedProfiles.kt\ngay/zharel/hermes/profiles/PathBasedProfilesKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n1563#2:201\n1634#2,3:202\n1563#2:206\n1634#2,3:207\n1563#2:210\n1634#2,3:211\n1563#2:214\n1634#2,3:215\n1563#2:218\n1634#2,3:219\n1#3:205\n*S KotlinDebug\n*F\n+ 1 PathBasedProfiles.kt\ngay/zharel/hermes/profiles/PathBasedProfilesKt\n*L\n152#1:201\n152#1:202,3\n172#1:206\n172#1:207,3\n173#1:210\n173#1:211,3\n195#1:214\n195#1:215,3\n196#1:218\n196#1:219,3\n*E\n"})
public final class PathBasedProfilesKt {
    @NotNull
    public static final DisplacementProfile createOptimalDisplacementProfile(@NotNull ProfileParams params, @NotNull PosePath path, double beginVel, @NotNull VelConstraint velConstraint, @NotNull AccelConstraint accelConstraint) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)velConstraint, (String)"velConstraint");
        Intrinsics.checkNotNullParameter((Object)accelConstraint, (String)"accelConstraint");
        DisplacementProfile forwardProfile = PathBasedProfilesKt.generatePathBasedForwardProfile(params, path, beginVel, velConstraint, accelConstraint);
        DisplacementProfile backwardProfile = PathBasedProfilesKt.generatePathBasedBackwardProfile(params, path, beginVel, velConstraint, accelConstraint);
        return ProfileMergingKt.mergeDisplacementProfiles(forwardProfile, backwardProfile);
    }

    @NotNull
    public static final DisplacementProfile generatePathBasedForwardProfile(@NotNull ProfileParams params, @NotNull PosePath path, double beginVel, @NotNull VelConstraint velConstraint, @NotNull AccelConstraint accelConstraint) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)velConstraint, (String)"velConstraint");
        Intrinsics.checkNotNullParameter((Object)accelConstraint, (String)"accelConstraint");
        List<Double> samples = PathBasedProfilesKt.generatePathSamples(path, params);
        Pair<List<Double>, List<Double>> pair = PathBasedProfilesKt.evaluateConstraintsAtSamples(path, samples, velConstraint, accelConstraint);
        List maxVels = (List)pair.component1();
        List maxAccels = (List)pair.component2();
        List<Double> displacements = PathBasedProfilesKt.createDisplacementPoints(samples, path.length());
        return ProfileGenerationKt.generateForwardProfile(displacements, beginVel, maxVels, maxAccels);
    }

    @NotNull
    public static final DisplacementProfile generatePathBasedBackwardProfile(@NotNull ProfileParams params, @NotNull PosePath path, double endVel, @NotNull VelConstraint velConstraint, @NotNull AccelConstraint accelConstraint) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)velConstraint, (String)"velConstraint");
        Intrinsics.checkNotNullParameter((Object)accelConstraint, (String)"accelConstraint");
        List<Double> samples = PathBasedProfilesKt.generatePathSamples(path, params);
        Pair<List<Double>, List<Double>> pair = PathBasedProfilesKt.evaluateBackwardConstraintsAtSamples(path, samples, velConstraint, accelConstraint);
        List maxVels = (List)pair.component1();
        List minAccels = (List)pair.component2();
        List<Double> displacements = PathBasedProfilesKt.createDisplacementPoints(samples, path.length());
        return ProfileGenerationKt.generateBackwardProfile(displacements, maxVels, endVel, minAccels);
    }

    @NotNull
    public static final List<Double> generatePathSamples(@NotNull PosePath path, @NotNull ProfileParams params) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        double pathLength = path.length();
        List<Double> dispSamples = Math.rangeCentered(0.0, pathLength, java.lang.Math.max(1, (int)java.lang.Math.ceil(pathLength / params.getDispResolution())));
        List<Double> angSamples = Profiles.samplePathByRotation(path, params.getAngResolution(), params.getAngSamplingEps());
        return CollectionsKt.sorted((Iterable)CollectionsKt.plus((Collection)dispSamples, (Iterable)angSamples));
    }

    @NotNull
    public static final Pair<List<Double>, List<Double>> evaluateConstraintsAtSamples(@NotNull PosePath path, @NotNull List<Double> samples, @NotNull VelConstraint velConstraint, @NotNull AccelConstraint accelConstraint) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(samples, (String)"samples");
        Intrinsics.checkNotNullParameter((Object)velConstraint, (String)"velConstraint");
        Intrinsics.checkNotNullParameter((Object)accelConstraint, (String)"accelConstraint");
        List maxVels = new ArrayList();
        List maxAccels = new ArrayList();
        Iterator<Double> iterator = samples.iterator();
        while (iterator.hasNext()) {
            double s = ((Number)iterator.next()).doubleValue();
            Pose2dDual<Arclength> pose = path.get(s, 2);
            RobotState robotState = RobotState.Companion.fromDualPose(pose);
            maxVels.add(velConstraint.maxRobotVel(robotState, path, s));
            double maxAccel = accelConstraint.minMaxProfileAccel(robotState, path, s).component2();
            maxAccels.add(maxAccel);
        }
        return new Pair((Object)maxVels, (Object)maxAccels);
    }

    @NotNull
    public static final Pair<List<Double>, List<Double>> evaluateBackwardConstraintsAtSamples(@NotNull PosePath path, @NotNull List<Double> samples, @NotNull VelConstraint velConstraint, @NotNull AccelConstraint accelConstraint) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(samples, (String)"samples");
        Intrinsics.checkNotNullParameter((Object)velConstraint, (String)"velConstraint");
        Intrinsics.checkNotNullParameter((Object)accelConstraint, (String)"accelConstraint");
        List maxVels = new ArrayList();
        List minAccels = new ArrayList();
        Iterator<Double> iterator = samples.iterator();
        while (iterator.hasNext()) {
            double s = ((Number)iterator.next()).doubleValue();
            Pose2dDual<Arclength> pose = path.get(s, 2);
            RobotState robotState = RobotState.Companion.fromDualPose(pose);
            maxVels.add(velConstraint.maxRobotVel(robotState, path, s));
            double minAccel = accelConstraint.minMaxProfileAccel(robotState, path, s).component1();
            minAccels.add(minAccel);
        }
        return new Pair((Object)maxVels, (Object)minAccels);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Double> createDisplacementPoints(@NotNull List<Double> samples, double pathLength) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(samples, (String)"samples");
        Iterable $this$map$iv = CollectionsKt.zip((Iterable)samples, (Iterable)CollectionsKt.drop((Iterable)samples, (int)1));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            double a = ((Number)pair.component1()).doubleValue();
            double b = ((Number)pair.component2()).doubleValue();
            collection.add(0.5 * (a + b));
        }
        List midpoints = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)0.0), (Iterable)midpoints), (Iterable)CollectionsKt.listOf((Object)pathLength));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DisplacementProfile createSimpleDisplacementProfile(double length, double beginVel, @NotNull Function1<? super Double, Double> maxVel, @NotNull Function1<? super Double, Double> maxAccel, double resolution) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(maxVel, (String)"maxVel");
        Intrinsics.checkNotNullParameter(maxAccel, (String)"maxAccel");
        if (!(length > 0.0)) {
            boolean $i$a$-require-PathBasedProfilesKt$createSimpleDisplacementProfile$42 = false;
            String $i$a$-require-PathBasedProfilesKt$createSimpleDisplacementProfile$42 = "length (" + length + ") must be positive";
            throw new IllegalArgumentException($i$a$-require-PathBasedProfilesKt$createSimpleDisplacementProfile$42.toString());
        }
        if (!(resolution > 0.0)) {
            boolean $i$a$-require-PathBasedProfilesKt$createSimpleDisplacementProfile$52 = false;
            String $i$a$-require-PathBasedProfilesKt$createSimpleDisplacementProfile$52 = "resolution (" + resolution + ") must be positive";
            throw new IllegalArgumentException($i$a$-require-PathBasedProfilesKt$createSimpleDisplacementProfile$52.toString());
        }
        if (!(beginVel >= 0.0)) {
            boolean $i$a$-require-PathBasedProfilesKt$createSimpleDisplacementProfile$62 = false;
            String $i$a$-require-PathBasedProfilesKt$createSimpleDisplacementProfile$62 = "beginVel (" + beginVel + ") must be non-negative";
            throw new IllegalArgumentException($i$a$-require-PathBasedProfilesKt$createSimpleDisplacementProfile$62.toString());
        }
        int samples = java.lang.Math.max(1, (int)java.lang.Math.ceil(length / resolution));
        List<Double> disps = Math.rangeCentered(0.0, length, samples);
        Iterable $this$map$iv = disps;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            destination$iv$iv.add(maxVel.invoke(item$iv$iv));
        }
        List maxVels = (List)destination$iv$iv;
        Iterable $this$map$iv2 = disps;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            destination$iv$iv2.add(maxAccel.invoke(item$iv$iv));
        }
        List maxAccels = (List)destination$iv$iv2;
        DisplacementProfile forwardProfile = ProfileGenerationKt.generateForwardProfile(Math.range(0.0, length, samples + 1), beginVel, maxVels, maxAccels);
        DisplacementProfile backwardProfile = PathBasedProfilesKt.generateSimpleBackwardProfile(length, maxVel, beginVel, (Function1<? super Double, Double>)((Function1)arg_0 -> PathBasedProfilesKt.createSimpleDisplacementProfile$lambda$4(maxAccel, arg_0)), resolution);
        return ProfileMergingKt.mergeDisplacementProfiles(forwardProfile, backwardProfile);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DisplacementProfile generateSimpleBackwardProfile(double length, @NotNull Function1<? super Double, Double> maxVel, double endVel, @NotNull Function1<? super Double, Double> minAccel, double resolution) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(maxVel, (String)"maxVel");
        Intrinsics.checkNotNullParameter(minAccel, (String)"minAccel");
        if (!(endVel >= 0.0)) {
            boolean $i$a$-require-PathBasedProfilesKt$generateSimpleBackwardProfile$22 = false;
            String $i$a$-require-PathBasedProfilesKt$generateSimpleBackwardProfile$22 = "endVel (" + endVel + ") must be non-negative";
            throw new IllegalArgumentException($i$a$-require-PathBasedProfilesKt$generateSimpleBackwardProfile$22.toString());
        }
        int samples = java.lang.Math.max(1, (int)java.lang.Math.ceil(length / resolution));
        List<Double> disps = Math.rangeCentered(0.0, length, samples);
        Iterable $this$map$iv = disps;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            destination$iv$iv.add(maxVel.invoke(item$iv$iv));
        }
        List maxVels = (List)destination$iv$iv;
        Iterable $this$map$iv2 = disps;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            destination$iv$iv2.add(minAccel.invoke(item$iv$iv));
        }
        List minAccels = (List)destination$iv$iv2;
        return ProfileGenerationKt.generateBackwardProfile(Math.range(0.0, length, samples + 1), maxVels, endVel, minAccels);
    }

    private static final double createSimpleDisplacementProfile$lambda$4(Function1 $maxAccel, double s) {
        return -((Number)$maxAccel.invoke((Object)s)).doubleValue();
    }
}

