/*
 * Decompiled with CFR 0.152.
 */
package gay.zharel.hermes.profiles;

import gay.zharel.hermes.profiles.DisplacementProfile;
import gay.zharel.hermes.profiles.VoltageProfileUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\b\r\u001a8\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a8\u0010\b\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\t\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a:\u0010\u000b\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a:\u0010\u000f\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001aB\u0010\u0010\u001a\u00020\u00112\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0002\u001aJ\u0010\u0017\u001a\u00020\u00112\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0002\u001a \u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0002\u001a \u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004H\u0002\u00a8\u0006\u001f"}, d2={"generateForwardProfile", "Lgay/zharel/hermes/profiles/DisplacementProfile;", "disps", "", "", "beginVel", "maxVels", "maxAccels", "generateBackwardProfile", "endVel", "minAccels", "generateVoltageConstrainedForwardProfile", "kV", "kA", "maxVoltages", "generateVoltageConstrainedBackwardProfile", "addConstantVelocitySegment", "", "", "vels", "accels", "endDisp", "velocity", "addAccelerationSegment", "accel", "calculateVelocityAfterAcceleration", "initialVel", "acceleration", "distance", "calculateDistanceToReachVelocity", "targetVel", "core"})
@SourceDebugExtension(value={"SMAP\nProfileGeneration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileGeneration.kt\ngay/zharel/hermes/profiles/ProfileGenerationKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,234:1\n1#2:235\n1740#3,3:236\n1740#3,3:239\n1803#3,3:242\n1563#3:245\n1634#3,3:246\n1563#3:249\n1634#3,3:250\n1563#3:253\n1634#3,3:254\n1563#3:257\n1634#3,3:258\n1740#3,3:261\n1803#3,3:264\n1563#3:267\n1634#3,3:268\n1563#3:271\n1634#3,3:272\n1563#3:275\n1634#3,3:276\n*S KotlinDebug\n*F\n+ 1 ProfileGeneration.kt\ngay/zharel/hermes/profiles/ProfileGenerationKt\n*L\n35#1:236,3\n36#1:239,3\n45#1:242,3\n94#1:245\n94#1:246,3\n96#1:249\n96#1:250,3\n102#1:253\n102#1:254,3\n104#1:257\n104#1:258,3\n126#1:261,3\n138#1:264,3\n180#1:267\n180#1:268,3\n186#1:271\n186#1:272,3\n188#1:275\n188#1:276,3\n*E\n"})
public final class ProfileGenerationKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DisplacementProfile generateForwardProfile(@NotNull List<Double> disps, double beginVel, @NotNull List<Double> maxVels, @NotNull List<Double> maxAccels) {
        void $this$fold$iv;
        boolean bl;
        Object element$iv2;
        block15: {
            double v;
            boolean bl2;
            boolean $i$f$all;
            Iterable $this$all$iv;
            block14: {
                Intrinsics.checkNotNullParameter(disps, (String)"disps");
                Intrinsics.checkNotNullParameter(maxVels, (String)"maxVels");
                Intrinsics.checkNotNullParameter(maxAccels, (String)"maxAccels");
                if (!(beginVel >= 0.0)) {
                    boolean $i$a$-require-ProfileGenerationKt$generateForwardProfile$22 = false;
                    String $i$a$-require-ProfileGenerationKt$generateForwardProfile$22 = "beginVel (" + beginVel + ") must be non-negative";
                    throw new IllegalArgumentException($i$a$-require-ProfileGenerationKt$generateForwardProfile$22.toString());
                }
                $this$all$iv = maxVels;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv2 : $this$all$iv) {
                        v = ((Number)element$iv2).doubleValue();
                        boolean bl3 = false;
                        if (v > 0.0) continue;
                        bl2 = false;
                        break block14;
                    }
                    bl2 = true;
                }
            }
            if (!bl2) {
                boolean $i$a$-require-ProfileGenerationKt$generateForwardProfile$42 = false;
                String $i$a$-require-ProfileGenerationKt$generateForwardProfile$42 = "maxVels must be positive";
                throw new IllegalArgumentException($i$a$-require-ProfileGenerationKt$generateForwardProfile$42.toString());
            }
            $this$all$iv = maxAccels;
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv2 : $this$all$iv) {
                    v = ((Number)element$iv2).doubleValue();
                    boolean bl4 = false;
                    if (v > 0.0) continue;
                    bl = false;
                    break block15;
                }
                bl = true;
            }
        }
        if (!bl) {
            boolean $i$a$-require-ProfileGenerationKt$generateForwardProfile$62 = false;
            String $i$a$-require-ProfileGenerationKt$generateForwardProfile$62 = "maxAccels must be positive";
            throw new IllegalArgumentException($i$a$-require-ProfileGenerationKt$generateForwardProfile$62.toString());
        }
        Object[] $i$a$-require-ProfileGenerationKt$generateForwardProfile$62 = new Double[]{0.0};
        List newDisps = CollectionsKt.mutableListOf((Object[])$i$a$-require-ProfileGenerationKt$generateForwardProfile$62);
        Object[] objectArray = new Double[]{beginVel};
        List vels = CollectionsKt.mutableListOf((Object[])objectArray);
        List accels = new ArrayList();
        element$iv2 = CollectionsKt.zip((Iterable)CollectionsKt.zip((Iterable)maxVels, (Iterable)maxAccels), (Iterable)CollectionsKt.drop((Iterable)disps, (int)1));
        Double initial$iv = disps.get(0);
        boolean $i$f$fold = false;
        Double accumulator$iv = initial$iv;
        for (Object element$iv3 : $this$fold$iv) {
            Pair pair = (Pair)element$iv3;
            double beginDisp = ((Number)accumulator$iv).doubleValue();
            boolean bl5 = false;
            Pair constraints = (Pair)pair.component1();
            double endDisp = ((Number)pair.component2()).doubleValue();
            double maxVel = ((Number)constraints.component1()).doubleValue();
            double maxAccel = ((Number)constraints.component2()).doubleValue();
            double currentVel = ((Number)CollectionsKt.last((List)vels)).doubleValue();
            if (currentVel >= maxVel) {
                ProfileGenerationKt.addConstantVelocitySegment(newDisps, vels, accels, endDisp, maxVel);
            } else {
                double projectedEndVel = ProfileGenerationKt.calculateVelocityAfterAcceleration(currentVel, maxAccel, endDisp - beginDisp);
                if (projectedEndVel <= maxVel) {
                    ProfileGenerationKt.addAccelerationSegment(newDisps, vels, accels, endDisp, projectedEndVel, maxAccel);
                } else {
                    double accelDistance = ProfileGenerationKt.calculateDistanceToReachVelocity(currentVel, maxVel, maxAccel);
                    ProfileGenerationKt.addAccelerationSegment(newDisps, vels, accels, beginDisp + accelDistance, maxVel, maxAccel);
                    ProfileGenerationKt.addConstantVelocitySegment(newDisps, vels, accels, endDisp, maxVel);
                }
            }
            accumulator$iv = endDisp;
        }
        return new DisplacementProfile(newDisps, vels, accels);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DisplacementProfile generateBackwardProfile(@NotNull List<Double> disps, @NotNull List<Double> maxVels, double endVel, @NotNull List<Double> minAccels) {
        Collection<Double> collection;
        double x;
        Collection collection2;
        Iterable $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        Collection collection3;
        void $this$mapTo$iv$iv3;
        Intrinsics.checkNotNullParameter(disps, (String)"disps");
        Intrinsics.checkNotNullParameter(maxVels, (String)"maxVels");
        Intrinsics.checkNotNullParameter(minAccels, (String)"minAccels");
        Iterable $this$map$iv = CollectionsKt.reversed((Iterable)disps);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            double d = ((Number)item$iv$iv).doubleValue();
            collection3 = destination$iv$iv;
            boolean bl = false;
            collection3.add(((Number)CollectionsKt.last(disps)).doubleValue() - it);
        }
        List reversedDisps = (List)destination$iv$iv;
        List reversedMaxVels = CollectionsKt.reversed((Iterable)maxVels);
        Iterable $this$map$iv2 = CollectionsKt.reversed((Iterable)minAccels);
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            double bl = ((Number)item$iv$iv).doubleValue();
            collection3 = destination$iv$iv2;
            boolean bl2 = false;
            collection3.add((double)(-it));
        }
        List reversedMaxAccels = (List)destination$iv$iv2;
        DisplacementProfile forwardProfile = ProfileGenerationKt.generateForwardProfile(reversedDisps, endVel, reversedMaxVels, reversedMaxAccels);
        Iterable $this$map$iv3 = forwardProfile.disps;
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            double d = ((Number)item$iv$iv).doubleValue();
            collection2 = destination$iv$iv3;
            boolean bl = false;
            collection2.add(forwardProfile.length - x);
        }
        $this$map$iv3 = CollectionsKt.reversed((Iterable)forwardProfile.accels);
        List list = CollectionsKt.reversed((Iterable)forwardProfile.vels);
        collection2 = CollectionsKt.reversed((Iterable)((List)destination$iv$iv3));
        $i$f$map3 = false;
        $this$mapTo$iv$iv = $this$map$iv3;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void a;
            x = ((Number)item$iv$iv).doubleValue();
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add((double)(-a));
        }
        collection = (List)destination$iv$iv3;
        List list2 = collection;
        List list3 = list;
        Collection collection4 = collection2;
        return new DisplacementProfile((List<Double>)collection4, list3, list2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DisplacementProfile generateVoltageConstrainedForwardProfile(@NotNull List<Double> disps, double beginVel, double kV, double kA, @NotNull List<Double> maxVoltages) {
        void $this$fold$iv;
        boolean bl;
        block10: {
            Intrinsics.checkNotNullParameter(disps, (String)"disps");
            Intrinsics.checkNotNullParameter(maxVoltages, (String)"maxVoltages");
            if (!(beginVel >= 0.0)) {
                boolean $i$a$-require-ProfileGenerationKt$generateVoltageConstrainedForwardProfile$22 = false;
                String $i$a$-require-ProfileGenerationKt$generateVoltageConstrainedForwardProfile$22 = "beginVel (" + beginVel + ") must be non-negative";
                throw new IllegalArgumentException($i$a$-require-ProfileGenerationKt$generateVoltageConstrainedForwardProfile$22.toString());
            }
            Iterable $this$all$iv = maxVoltages;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    double v = ((Number)element$iv).doubleValue();
                    boolean bl2 = false;
                    if (v > 0.0) continue;
                    bl = false;
                    break block10;
                }
                bl = true;
            }
        }
        if (!bl) {
            boolean $i$a$-require-ProfileGenerationKt$generateVoltageConstrainedForwardProfile$42 = false;
            String $i$a$-require-ProfileGenerationKt$generateVoltageConstrainedForwardProfile$42 = "maxVoltages must be positive";
            throw new IllegalArgumentException($i$a$-require-ProfileGenerationKt$generateVoltageConstrainedForwardProfile$42.toString());
        }
        Object[] $i$a$-require-ProfileGenerationKt$generateVoltageConstrainedForwardProfile$42 = new Double[]{0.0};
        List newDisps = CollectionsKt.mutableListOf((Object[])$i$a$-require-ProfileGenerationKt$generateVoltageConstrainedForwardProfile$42);
        Object[] objectArray = new Double[]{beginVel};
        List vels = CollectionsKt.mutableListOf((Object[])objectArray);
        List accels = new ArrayList();
        Function1<Double, Double> getVel = VoltageProfileUtilsKt.velocityFromVoltage(kV);
        Function1<Double, Double> getAccel = VoltageProfileUtilsKt.accelerationFromVoltage(kA);
        Function1<Double, Double> getVelVolt = VoltageProfileUtilsKt.voltageFromVelocity(kV);
        Iterable bl2 = CollectionsKt.zip((Iterable)maxVoltages, (Iterable)CollectionsKt.drop((Iterable)disps, (int)1));
        Double initial$iv = disps.get(0);
        boolean $i$f$fold = false;
        Double accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            Pair pair = (Pair)element$iv;
            double beginDisp = ((Number)accumulator$iv).doubleValue();
            boolean bl3 = false;
            double maxVoltage = ((Number)pair.component1()).doubleValue();
            double endDisp = ((Number)pair.component2()).doubleValue();
            double currentVel = ((Number)CollectionsKt.last((List)vels)).doubleValue();
            double maxVel = ((Number)getVel.invoke((Object)maxVoltage)).doubleValue();
            double availableAccelVoltage = maxVoltage - ((Number)getVelVolt.invoke((Object)currentVel)).doubleValue();
            double maxAccel = ((Number)getAccel.invoke((Object)availableAccelVoltage)).doubleValue();
            if (currentVel >= maxVel) {
                ProfileGenerationKt.addConstantVelocitySegment(newDisps, vels, accels, endDisp, maxVel);
            } else {
                double projectedEndVel = ProfileGenerationKt.calculateVelocityAfterAcceleration(currentVel, maxAccel, endDisp - beginDisp);
                if (projectedEndVel <= maxVel) {
                    ProfileGenerationKt.addAccelerationSegment(newDisps, vels, accels, endDisp, projectedEndVel, maxAccel);
                } else {
                    double accelDistance = ProfileGenerationKt.calculateDistanceToReachVelocity(currentVel, maxVel, maxAccel);
                    ProfileGenerationKt.addAccelerationSegment(newDisps, vels, accels, beginDisp + accelDistance, maxVel, maxAccel);
                    ProfileGenerationKt.addConstantVelocitySegment(newDisps, vels, accels, endDisp, maxVel);
                }
            }
            accumulator$iv = endDisp;
        }
        return new DisplacementProfile(newDisps, vels, accels);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DisplacementProfile generateVoltageConstrainedBackwardProfile(@NotNull List<Double> disps, double endVel, double kV, double kA, @NotNull List<Double> maxVoltages) {
        Collection<Double> collection;
        double x;
        Collection collection2;
        double it;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(disps, (String)"disps");
        Intrinsics.checkNotNullParameter(maxVoltages, (String)"maxVoltages");
        Iterable $this$map$iv = CollectionsKt.reversed((Iterable)disps);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            double d = ((Number)item$iv$iv).doubleValue();
            Collection collection3 = destination$iv$iv;
            boolean bl = false;
            collection3.add(((Number)CollectionsKt.last(disps)).doubleValue() - it);
        }
        DisplacementProfile reversedProfile = ProfileGenerationKt.generateVoltageConstrainedForwardProfile((List)destination$iv$iv, endVel, kV, kA, CollectionsKt.reversed((Iterable)maxVoltages));
        $this$map$iv = reversedProfile.disps;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = ((Number)item$iv$iv).doubleValue();
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(reversedProfile.length - x);
        }
        $this$map$iv = CollectionsKt.reversed((Iterable)reversedProfile.accels);
        List list = CollectionsKt.reversed((Iterable)reversedProfile.vels);
        collection2 = CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void a;
            x = ((Number)item$iv$iv).doubleValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((double)(-a));
        }
        collection = (List)destination$iv$iv;
        List list2 = collection;
        List list3 = list;
        Collection collection4 = collection2;
        return new DisplacementProfile((List<Double>)collection4, list3, list2);
    }

    private static final void addConstantVelocitySegment(List<Double> disps, List<Double> vels, List<Double> accels, double endDisp, double velocity) {
        disps.add(endDisp);
        vels.add(velocity);
        accels.add(0.0);
    }

    private static final void addAccelerationSegment(List<Double> disps, List<Double> vels, List<Double> accels, double endDisp, double endVel, double accel) {
        disps.add(endDisp);
        vels.add(endVel);
        accels.add(accel);
    }

    private static final double calculateVelocityAfterAcceleration(double initialVel, double acceleration, double distance) {
        return Math.sqrt(initialVel * initialVel + (double)2 * acceleration * distance);
    }

    private static final double calculateDistanceToReachVelocity(double initialVel, double targetVel, double acceleration) {
        return (targetVel * targetVel - initialVel * initialVel) / ((double)2 * acceleration);
    }
}

