/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.convert.jsp;

import gg.jte.convert.ConverterOutput;
import gg.jte.convert.IoUtils;
import gg.jte.convert.cc.CamelCaseConverter;
import gg.jte.convert.jsp.Converter;
import gg.jte.convert.jsp.converter.JspChooseConverter;
import gg.jte.convert.jsp.converter.JspForEachConverter;
import gg.jte.convert.jsp.converter.JspIfConverter;
import gg.jte.convert.jsp.converter.JspJteConverter;
import gg.jte.convert.jsp.converter.JspNoopConverter;
import gg.jte.convert.jsp.converter.JspOtherwiseConverter;
import gg.jte.convert.jsp.converter.JspSetConverter;
import gg.jte.convert.jsp.converter.JspWhenConverter;
import gg.jte.convert.jsp.converter.JstlFmtMessageConverter;
import gg.jte.convert.jsp.converter.JstlFmtParamConverter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.jasper.compiler.JtpConverter;

public class JspToJteConverter {
    private static final Pattern UNCONVERTED_TAG_REFERENCES = Pattern.compile("<[a-zA-Z0-9\\-]+:[a-zA-Z0-9\\-]+\\b");
    private final Path jspRoot;
    private final Path jteRoot;
    private final String jteTag;

    public static void convertFromIntelliJPlugin(String[] commandLineArgs, JspToJteConverter converter, Consumer<Converter> parserSetup) {
        if (commandLineArgs.length < 1) {
            throw new IllegalArgumentException("Missing JSP file, it should be the first argument on the command line.");
        }
        Path jspFile = Paths.get(commandLineArgs[0], new String[0]);
        jspFile = converter.jspRoot.toAbsolutePath().relativize(jspFile);
        converter.convertTag(jspFile.toString(), parserSetup);
    }

    public JspToJteConverter(Path jspRoot, Path jteRoot, String jteTag) {
        this.jspRoot = jspRoot;
        this.jteRoot = jteRoot;
        this.jteTag = jteTag;
    }

    public void convertTag(String jspTag, Consumer<Converter> parserSetup) {
        Path jspTagFile = this.jspRoot.resolve(jspTag);
        String relativeFilePath = this.jspRoot.relativize(jspTagFile).toString();
        JtpConverter converter = new JtpConverter(relativeFilePath, this.readFile(jspTagFile).replace("\r", "").getBytes(), this.getResourceBase(), relativeFilePath.endsWith(".tag"), new ConverterOutput());
        converter.register("c:if", new JspIfConverter());
        converter.register("c:forEach", new JspForEachConverter());
        converter.register("c:choose", new JspChooseConverter());
        converter.register("c:when", new JspWhenConverter());
        converter.register("c:otherwise", new JspOtherwiseConverter());
        converter.register("c:set", new JspSetConverter());
        converter.register("fmt:message", new JstlFmtMessageConverter());
        converter.register("fmt:param", new JstlFmtParamConverter());
        converter.register(this.jteTag, new JspJteConverter());
        if (this.getNotConvertedTags() != null) {
            for (String notConvertedTag : this.getNotConvertedTags()) {
                converter.register(notConvertedTag, new JspNoopConverter());
            }
        }
        if (parserSetup != null) {
            parserSetup.accept(converter);
        }
        String jte = converter.convert();
        System.out.println(jte);
        this.checkDependencies(jte);
        String jteTemplate = this.suggestJteFile(jspTag.replace('\\', '/'));
        Path jteTemplateFile = this.jteRoot.resolve(jteTemplate);
        IoUtils.writeFile(jteTemplateFile, jte);
        this.replaceUsages(jspTagFile, jteTemplateFile);
    }

    public void replaceUsages(String jspTag, String jteTag) {
        this.replaceUsages(this.jspRoot.resolve(jspTag), this.jteRoot.resolve(jteTag));
    }

    public void replaceUsages(Path jspTag, Path jteTag) {
        String oldJspTagPrefix = this.extractTagPrefix(jspTag);
        String oldJspTagClosing = "</" + oldJspTagPrefix.substring(1) + ">";
        String newJteFile = this.jteRoot.relativize(jteTag).toString().replace('\\', '/');
        IoUtils.deleteFile(jspTag);
        try (Stream<Path> stream = Files.walk(this.jspRoot, new FileVisitOption[0]);){
            stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> !Files.isDirectory(p, new LinkOption[0])).filter(p -> {
                String fileName = p.toString();
                return fileName.endsWith(".jsp") || fileName.endsWith(".jsp.inc") || fileName.endsWith(".tag");
            }).forEach(jspFile -> this.replaceUsages((Path)jspFile, oldJspTagPrefix, oldJspTagClosing, newJteFile));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected String readFile(Path jspTag) {
        return IoUtils.readFile(jspTag);
    }

    private void replaceUsages(Path jspFile, String oldJspTagPrefix, String oldJspTagClosing, String newJteFile) {
        boolean modified = false;
        StringBuilder jspContent = new StringBuilder(IoUtils.readFile(jspFile));
        int lastIndex = 0;
        while ((lastIndex = jspContent.indexOf(oldJspTagPrefix, lastIndex)) >= 0 && lastIndex < jspContent.length()) {
            char character = jspContent.charAt(lastIndex + oldJspTagPrefix.length());
            if (Character.isWhitespace(character) || character == '/' || character == '>') {
                jspContent.replace(lastIndex, lastIndex + oldJspTagPrefix.length(), "<" + this.jteTag + " jte=\"" + newJteFile + "\"");
                modified = true;
                continue;
            }
            ++lastIndex;
        }
        lastIndex = 0;
        while ((lastIndex = jspContent.indexOf(oldJspTagClosing, lastIndex)) >= 0 && lastIndex < jspContent.length()) {
            jspContent.replace(lastIndex, lastIndex + oldJspTagClosing.length(), "</" + this.jteTag + ">");
            modified = true;
        }
        if (modified) {
            IoUtils.writeFile(jspFile, jspContent.toString());
        }
    }

    private String extractTagPrefix(Path jspTag) {
        String fileName = jspTag.getFileName().toString();
        String tagName = fileName.substring(0, fileName.indexOf(46));
        String namespace = jspTag.getParent().getFileName().toString();
        if ("tags".equals(namespace)) {
            namespace = "include";
        }
        return "<" + namespace + ":" + tagName;
    }

    protected URL getResourceBase() {
        try {
            return Paths.get("", new String[0]).toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String suggestJteFile(String jspFile) {
        int fileSeparatorIndex = jspFile.indexOf(46);
        if (fileSeparatorIndex == -1) {
            throw new IllegalArgumentException("JSP file without file extension " + jspFile);
        }
        String jspFileWithoutExtension = jspFile.substring(0, fileSeparatorIndex);
        StringBuilder jteFile = new StringBuilder();
        jteFile.append(jspFileWithoutExtension);
        CamelCaseConverter.convertTo(jteFile);
        jteFile.append(".jte");
        return jteFile.toString();
    }

    protected void checkDependencies(String jteCode) {
        List<String> unresolvedJspTags = this.findUnresolvedJspTags(jteCode);
        if (unresolvedJspTags.isEmpty()) {
            return;
        }
        Set<String> notConvertedTagsSet = this.getNotConvertedTagsAsSet();
        LinkedHashSet<CallSite> errors = new LinkedHashSet<CallSite>();
        for (String unresolvedJspTag : unresolvedJspTags) {
            if (notConvertedTagsSet.contains(unresolvedJspTag)) continue;
            errors.add((CallSite)((Object)("The tag " + unresolvedJspTag + "/> is used by this tag and not converted to jte yet. You should convert " + unresolvedJspTag + "/> first. If this is a tag that should be always converted by hand, implement getNotConvertedTags() and add it there.")));
        }
        if (!errors.isEmpty()) {
            throw new UnsupportedOperationException(String.join((CharSequence)"\n", errors));
        }
    }

    private Set<String> getNotConvertedTagsAsSet() {
        String[] notConvertedTags = this.getNotConvertedTags();
        HashSet<String> notConvertedTagsSet = new HashSet<String>();
        if (notConvertedTags != null) {
            for (String notConvertedTag : notConvertedTags) {
                notConvertedTagsSet.add("<" + notConvertedTag);
            }
        }
        return notConvertedTagsSet;
    }

    protected List<String> findUnresolvedJspTags(String jteCode) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = UNCONVERTED_TAG_REFERENCES.matcher(jteCode);
        while (matcher.find()) {
            result.add(matcher.group());
        }
        return result;
    }

    protected String[] getNotConvertedTags() {
        return null;
    }
}

