/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.convert.jsp.converter;

import gg.jte.runtime.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.el.lang.ExpressionBuilder;
import org.apache.el.parser.AstAnd;
import org.apache.el.parser.AstBracketSuffix;
import org.apache.el.parser.AstChoice;
import org.apache.el.parser.AstCompositeExpression;
import org.apache.el.parser.AstConcatenation;
import org.apache.el.parser.AstDiv;
import org.apache.el.parser.AstDotSuffix;
import org.apache.el.parser.AstDynamicExpression;
import org.apache.el.parser.AstEmpty;
import org.apache.el.parser.AstEqual;
import org.apache.el.parser.AstFalse;
import org.apache.el.parser.AstFloatingPoint;
import org.apache.el.parser.AstFunction;
import org.apache.el.parser.AstGreaterThan;
import org.apache.el.parser.AstGreaterThanEqual;
import org.apache.el.parser.AstIdentifier;
import org.apache.el.parser.AstInteger;
import org.apache.el.parser.AstLessThan;
import org.apache.el.parser.AstLessThanEqual;
import org.apache.el.parser.AstListData;
import org.apache.el.parser.AstLiteralExpression;
import org.apache.el.parser.AstMethodParameters;
import org.apache.el.parser.AstMinus;
import org.apache.el.parser.AstMod;
import org.apache.el.parser.AstMult;
import org.apache.el.parser.AstNegative;
import org.apache.el.parser.AstNot;
import org.apache.el.parser.AstNotEqual;
import org.apache.el.parser.AstNull;
import org.apache.el.parser.AstOr;
import org.apache.el.parser.AstPlus;
import org.apache.el.parser.AstString;
import org.apache.el.parser.AstTrue;
import org.apache.el.parser.AstValue;
import org.apache.el.parser.Node;

public class JspExpressionConverter {
    private final String el;
    private final Node root;
    private final StringBuilder result;
    private final Map<Class<? extends Node>, Visitor> visitorMap = new HashMap<Class<? extends Node>, Visitor>();

    public static String convertAttributeValue(String value) {
        if (value != null) {
            if (value.trim().startsWith("${")) {
                return new JspExpressionConverter(value).getJavaCode();
            }
            return "\"" + value + "\"";
        }
        return "???";
    }

    public JspExpressionConverter(String el) {
        this.el = el;
        if (el == null || StringUtils.isBlank((CharSequence)el)) {
            this.root = null;
            this.result = new StringBuilder();
        } else {
            this.root = ExpressionBuilder.createNode((String)el);
            this.result = new StringBuilder(el.length());
            this.visitorMap.put(AstMethodParameters.class, new AstMethodParametersVisitor());
            this.visitorMap.put(AstIdentifier.class, new AstIdentifierVisitor());
            this.visitorMap.put(AstEmpty.class, new AstEmptyVisitor());
            this.visitorMap.put(AstNot.class, new AstNotVisitor());
            this.visitorMap.put(AstOr.class, new AstOrVisitor());
            this.visitorMap.put(AstAnd.class, new AstAndVisitor());
            this.visitorMap.put(AstTrue.class, new AstTrueVisitor());
            this.visitorMap.put(AstFalse.class, new AstFalseVisitor());
            this.visitorMap.put(AstValue.class, new AstValueVisitor());
            this.visitorMap.put(AstEqual.class, new AstEqualVisitor());
            this.visitorMap.put(AstNotEqual.class, new AstNotEqualVisitor());
            this.visitorMap.put(AstInteger.class, new AstIntegerVisitor());
            this.visitorMap.put(AstDotSuffix.class, new AstDotSuffixVisitor());
            this.visitorMap.put(AstChoice.class, new AstChoiceVisitor());
            this.visitorMap.put(AstString.class, new AstStringVisitor());
            this.visitorMap.put(AstFloatingPoint.class, new AstFloatingPointVisitor());
            this.visitorMap.put(AstPlus.class, new AstPlusVisitor());
            this.visitorMap.put(AstMinus.class, new AstMinusVisitor());
            this.visitorMap.put(AstMult.class, new AstMultVisitor());
            this.visitorMap.put(AstDiv.class, new AstDivVisitor());
            this.visitorMap.put(AstMod.class, new AstModVisitor());
            this.visitorMap.put(AstConcatenation.class, new AstConcatenationVisitor());
            this.visitorMap.put(AstNegative.class, new AstNegativeVisitor());
            this.visitorMap.put(AstGreaterThan.class, new AstGreaterThanVisitor());
            this.visitorMap.put(AstLessThan.class, new AstLessThanVisitor());
            this.visitorMap.put(AstGreaterThanEqual.class, new AstGreaterThanEqualVisitor());
            this.visitorMap.put(AstLessThanEqual.class, new AstLessThanEqualVisitor());
            this.visitorMap.put(AstLiteralExpression.class, new AstLiteralExpressionVisitor());
            this.visitorMap.put(AstFunction.class, new AstFunctionVisitor());
            this.visitorMap.put(AstNull.class, new AstNullVisitor());
            this.visitorMap.put(AstBracketSuffix.class, new AstBracketSuffixVisitor());
            this.visitorMap.put(AstCompositeExpression.class, new AstCompositeExpressionVisitor());
            this.visitorMap.put(AstDynamicExpression.class, new AstDynamicExpressionVisitor());
            this.visitorMap.put(AstListData.class, new AstListDataVisitor());
            this.process(this.root);
        }
    }

    public String getJavaCode() {
        return this.result.toString();
    }

    private void process(Node node) {
        Visitor visitor = this.visitorMap.get(node.getClass());
        if (visitor == null) {
            throw new UnsupportedOperationException("Unknown AST node " + node.getClass() + ". Expression was '" + this.el + "'");
        }
        visitor.visit(node);
    }

    private class AstListDataVisitor
    implements Visitor {
        private AstListDataVisitor() {
        }

        @Override
        public void visit(Node node) {
            JspExpressionConverter.this.result.append("java.util.Arrays.asList(");
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                if (i > 0) {
                    JspExpressionConverter.this.result.append(", ");
                }
                JspExpressionConverter.this.process(node.jjtGetChild(i));
            }
            JspExpressionConverter.this.result.append(")");
        }
    }

    private class AstDynamicExpressionVisitor
    implements Visitor {
        private AstDynamicExpressionVisitor() {
        }

        @Override
        public void visit(Node node) {
            JspExpressionConverter.this.result.append("${");
            JspExpressionConverter.this.process(node.jjtGetChild(0));
            JspExpressionConverter.this.result.append("}");
        }
    }

    private class AstCompositeExpressionVisitor
    implements Visitor {
        private AstCompositeExpressionVisitor() {
        }

        @Override
        public void visit(Node node) {
            JspExpressionConverter.this.result.append("@`");
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                JspExpressionConverter.this.process(node.jjtGetChild(i));
            }
            JspExpressionConverter.this.result.append("`");
        }
    }

    private class AstBracketSuffixVisitor
    implements Visitor {
        private AstBracketSuffixVisitor() {
        }

        @Override
        public void visit(Node node) {
            JspExpressionConverter.this.result.append(".get(");
            JspExpressionConverter.this.process(node.jjtGetChild(0));
            JspExpressionConverter.this.result.append(")");
        }
    }

    private class AstNegativeVisitor
    implements Visitor {
        private AstNegativeVisitor() {
        }

        @Override
        public void visit(Node node) {
            JspExpressionConverter.this.result.append('-');
            JspExpressionConverter.this.process(node.jjtGetChild(0));
        }
    }

    private class AstNullVisitor
    implements Visitor {
        private AstNullVisitor() {
        }

        @Override
        public void visit(Node node) {
            JspExpressionConverter.this.result.append("null");
        }
    }

    private class AstFunctionVisitor
    implements Visitor {
        private AstFunctionVisitor() {
        }

        @Override
        public void visit(Node node) {
            AstFunction function = (AstFunction)node;
            JspExpressionConverter.this.result.append(function.getPrefix());
            JspExpressionConverter.this.result.append(':');
            JspExpressionConverter.this.result.append(function.getLocalName());
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                if (i > 0) {
                    JspExpressionConverter.this.result.append(", ");
                }
                JspExpressionConverter.this.process(node.jjtGetChild(i));
            }
        }
    }

    private class AstLiteralExpressionVisitor
    implements Visitor {
        private AstLiteralExpressionVisitor() {
        }

        @Override
        public void visit(Node node) {
            JspExpressionConverter.this.result.append(node.getImage());
        }
    }

    private class AstLessThanEqualVisitor
    extends AstBinaryOperatorVisitor {
        private AstLessThanEqualVisitor() {
        }

        @Override
        protected String getOperator() {
            return "<=";
        }
    }

    private class AstGreaterThanEqualVisitor
    extends AstBinaryOperatorVisitor {
        private AstGreaterThanEqualVisitor() {
        }

        @Override
        protected String getOperator() {
            return ">=";
        }
    }

    private class AstLessThanVisitor
    extends AstBinaryOperatorVisitor {
        private AstLessThanVisitor() {
        }

        @Override
        protected String getOperator() {
            return "<";
        }
    }

    private class AstGreaterThanVisitor
    extends AstBinaryOperatorVisitor {
        private AstGreaterThanVisitor() {
        }

        @Override
        protected String getOperator() {
            return ">";
        }
    }

    private class AstConcatenationVisitor
    extends AstBinaryOperatorVisitor {
        private AstConcatenationVisitor() {
        }

        @Override
        protected String getOperator() {
            return "+";
        }
    }

    private class AstModVisitor
    extends AstBinaryOperatorVisitor {
        private AstModVisitor() {
        }

        @Override
        protected String getOperator() {
            return "%";
        }
    }

    private class AstDivVisitor
    extends AstBinaryOperatorVisitor {
        private AstDivVisitor() {
        }

        @Override
        protected String getOperator() {
            return "/";
        }
    }

    private class AstMultVisitor
    extends AstBinaryOperatorVisitor {
        private AstMultVisitor() {
        }

        @Override
        protected String getOperator() {
            return "*";
        }
    }

    private class AstMinusVisitor
    extends AstBinaryOperatorVisitor {
        private AstMinusVisitor() {
        }

        @Override
        protected String getOperator() {
            return "-";
        }
    }

    private class AstPlusVisitor
    extends AstBinaryOperatorVisitor {
        private AstPlusVisitor() {
        }

        @Override
        protected String getOperator() {
            return "+";
        }
    }

    private class AstFloatingPointVisitor
    implements Visitor {
        private AstFloatingPointVisitor() {
        }

        @Override
        public void visit(Node node) {
            JspExpressionConverter.this.result.append(node.getImage());
        }
    }

    private class AstChoiceVisitor
    implements Visitor {
        private AstChoiceVisitor() {
        }

        @Override
        public void visit(Node node) {
            JspExpressionConverter.this.process(node.jjtGetChild(0));
            JspExpressionConverter.this.result.append(" ? ");
            JspExpressionConverter.this.process(node.jjtGetChild(1));
            JspExpressionConverter.this.result.append(" : ");
            JspExpressionConverter.this.process(node.jjtGetChild(2));
        }
    }

    private class AstDotSuffixVisitor
    implements Visitor {
        private AstDotSuffixVisitor() {
        }

        @Override
        public void visit(Node node) {
            JspExpressionConverter.this.result.append(".").append(node.getImage());
        }
    }

    private class AstStringVisitor
    implements Visitor {
        private AstStringVisitor() {
        }

        @Override
        public void visit(Node node) {
            AstString astString = (AstString)node;
            JspExpressionConverter.this.result.append('\"');
            StringUtils.appendEscaped((StringBuilder)JspExpressionConverter.this.result, (String)astString.getString());
            JspExpressionConverter.this.result.append('\"');
        }
    }

    private class AstIntegerVisitor
    implements Visitor {
        private AstIntegerVisitor() {
        }

        @Override
        public void visit(Node node) {
            JspExpressionConverter.this.result.append(node.getImage());
        }
    }

    private class AstNotEqualVisitor
    extends AstBinaryOperatorVisitor {
        private AstNotEqualVisitor() {
        }

        @Override
        protected String getOperator() {
            return "!=";
        }
    }

    private class AstEqualVisitor
    extends AstBinaryOperatorVisitor {
        private AstEqualVisitor() {
        }

        @Override
        protected String getOperator() {
            return "==";
        }
    }

    private class AstValueVisitor
    implements Visitor {
        private AstValueVisitor() {
        }

        @Override
        public void visit(Node node) {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                JspExpressionConverter.this.process(node.jjtGetChild(i));
            }
        }
    }

    private class AstFalseVisitor
    implements Visitor {
        private AstFalseVisitor() {
        }

        @Override
        public void visit(Node node) {
            JspExpressionConverter.this.result.append("false");
        }
    }

    private class AstTrueVisitor
    implements Visitor {
        private AstTrueVisitor() {
        }

        @Override
        public void visit(Node node) {
            JspExpressionConverter.this.result.append("true");
        }
    }

    private class AstAndVisitor
    extends AstBinaryOperatorVisitor {
        private AstAndVisitor() {
        }

        @Override
        protected String getOperator() {
            return "&&";
        }
    }

    private class AstOrVisitor
    extends AstBinaryOperatorVisitor {
        private AstOrVisitor() {
        }

        @Override
        protected String getOperator() {
            return "||";
        }
    }

    private abstract class AstBinaryOperatorVisitor
    implements Visitor {
        private AstBinaryOperatorVisitor() {
        }

        @Override
        public void visit(Node node) {
            boolean parenthesisNeeded = this.isParenthesisNeeded(node);
            if (parenthesisNeeded) {
                JspExpressionConverter.this.result.append('(');
            }
            JspExpressionConverter.this.process(node.jjtGetChild(0));
            JspExpressionConverter.this.result.append(' ').append(this.getOperator()).append(' ');
            JspExpressionConverter.this.process(node.jjtGetChild(1));
            if (parenthesisNeeded) {
                JspExpressionConverter.this.result.append(')');
            }
        }

        protected abstract String getOperator();

        private boolean isParenthesisNeeded(Node node) {
            if (node == JspExpressionConverter.this.root) {
                return false;
            }
            return !(node.jjtGetParent() instanceof AstChoice);
        }
    }

    private class AstNotVisitor
    implements Visitor {
        private AstNotVisitor() {
        }

        @Override
        public void visit(Node node) {
            JspExpressionConverter.this.result.append('!');
            JspExpressionConverter.this.process(node.jjtGetChild(0));
        }
    }

    private class AstEmptyVisitor
    implements Visitor {
        private AstEmptyVisitor() {
        }

        @Override
        public void visit(Node node) {
            JspExpressionConverter.this.result.append("isEmpty(");
            JspExpressionConverter.this.process(node.jjtGetChild(0));
            JspExpressionConverter.this.result.append(")");
        }
    }

    private class AstIdentifierVisitor
    implements Visitor {
        private AstIdentifierVisitor() {
        }

        @Override
        public void visit(Node node) {
            JspExpressionConverter.this.result.append(node.getImage());
        }
    }

    private class AstMethodParametersVisitor
    implements Visitor {
        private AstMethodParametersVisitor() {
        }

        @Override
        public void visit(Node node) {
            JspExpressionConverter.this.result.append('(');
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                if (i > 0) {
                    JspExpressionConverter.this.result.append(", ");
                }
                JspExpressionConverter.this.process(node.jjtGetChild(i));
            }
            JspExpressionConverter.this.result.append(')');
        }
    }

    private static interface Visitor {
        public void visit(Node var1);
    }
}

