/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import gg.jte.convert.ConverterOutput;
import gg.jte.convert.CustomTagConverter;
import gg.jte.convert.jsp.Converter;
import gg.jte.convert.jsp.JspElementType;
import gg.jte.convert.jsp.converter.JspAttributeConverter;
import gg.jte.convert.jsp.converter.JspExpressionConverter;
import java.io.IOException;
import java.net.URL;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.JtpAttribute;
import org.apache.jasper.compiler.JtpCustomTag;
import org.apache.jasper.compiler.JtpParser;
import org.apache.jasper.compiler.Node;

public class JtpConverter
extends Node.Visitor
implements Converter {
    private static final Pattern NEW_LINE_CLEANUP = Pattern.compile("\n{3,}");
    private static final Pattern NEW_LINE_WHITESPACE_CLEANUP = Pattern.compile("\n([\\t ]+)\n");
    private final String relativeFilePath;
    private final byte[] input;
    private final URL resourceBase;
    private final boolean tagFile;
    private final ConverterOutput output;
    private final Map<String, CustomTagConverter> converters = new HashMap<String, CustomTagConverter>();
    private final Set<String> inlinedIncludes = new HashSet<String>();
    private final Map<String, EnumSet<JspElementType>> suppressions = new HashMap<String, EnumSet<JspElementType>>();
    private final Set<String> imports = new TreeSet<String>();
    private final Set<String> params = new TreeSet<String>();
    private String prefix;
    private String lineSeparator = "\n";

    public JtpConverter(String relativeFilePath, byte[] input, URL resourceBase, boolean tagFile, ConverterOutput output) {
        this.relativeFilePath = relativeFilePath;
        this.input = input;
        this.resourceBase = resourceBase;
        this.tagFile = tagFile;
        this.output = output;
    }

    @Override
    public void register(String tagName, CustomTagConverter converter) {
        this.converters.put(tagName, converter);
    }

    @Override
    public void addInlinedInclude(String path) {
        this.inlinedIncludes.add(path);
    }

    @Override
    public void addSuppressions(String path, EnumSet<JspElementType> suppressions) {
        this.suppressions.put(path, suppressions);
    }

    @Override
    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    @Override
    public void setIndentationCount(int indentationCount) {
        this.output.setIndentationCount(indentationCount);
    }

    @Override
    public void setIndentationChar(char indentationChar) {
        this.output.setIndentationChar(indentationChar);
    }

    @Override
    public String convert() {
        try {
            Node.Nodes nodes = JtpParser.parse(this.relativeFilePath, this.input, this.resourceBase, this.tagFile);
            nodes.visit((Node.Visitor)this);
            return this.cleanResult(this.output.trim().prepend(this.createPrefix()).toString());
        }
        catch (IOException | JasperException e) {
            throw new RuntimeException(e);
        }
    }

    private String createPrefix() {
        StringBuilder result = new StringBuilder(this.prefix == null ? "" : this.prefix);
        for (String type : this.imports) {
            result.append("@import ").append(type).append('\n');
        }
        if (result.length() > 0) {
            result.append('\n');
        }
        for (String param : this.params) {
            result.append("@param ").append(param).append('\n');
        }
        return result.toString();
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void addImport(String className) {
        this.imports.add(className);
    }

    public void addParam(String param) {
        this.params.add(param);
    }

    private String cleanResult(String result) {
        result = NEW_LINE_WHITESPACE_CLEANUP.matcher(result).replaceAll("\n");
        result = NEW_LINE_CLEANUP.matcher(result).replaceAll("\n\n");
        result = result.replace("\n", this.lineSeparator);
        return result;
    }

    public void visit(Node.TemplateText n) {
        if (this.output.isTrimWhitespace()) {
            this.output.append(n.getText().trim());
        } else {
            this.output.append(n.getText());
        }
    }

    public void visit(Node.UseBean n) throws JasperException {
        if (this.isSuppressed((Node)n)) {
            return;
        }
        super.visit(n);
    }

    public void visit(Node.ELExpression n) {
        if (!this.output.isInsideScript()) {
            this.output.append("${");
        }
        this.output.append(JspExpressionConverter.convertAttributeValue("${" + n.getText() + "}"));
        if (!this.output.isInsideScript()) {
            this.output.append("}");
        }
    }

    public void visit(Node.PageDirective n) {
    }

    public void visit(Node.Root n) throws JasperException {
        this.visitBody((Node)n);
    }

    public void visit(Node.TaglibDirective n) {
    }

    public void visit(Node.TagDirective n) {
    }

    public void visit(Node.SetProperty n) {
        String name = n.getAttributeValue("name");
        String value = n.getAttributeValue("value");
        String property = n.getAttributeValue("property");
        this.output.append("!{");
        this.output.append(name).append(".set");
        this.output.append(Character.toUpperCase(property.charAt(0)) + property.substring(1));
        this.output.append("(");
        this.output.append(JspExpressionConverter.convertAttributeValue(value));
        this.output.append(");}");
    }

    public void visit(Node.AttributeDirective n) {
        new JspAttributeConverter().convert(this, new JtpAttribute(n), this.output);
    }

    public void visit(Node.Declaration n) throws JasperException {
        if (this.isSuppressed((Node)n)) {
            return;
        }
        super.visit(n);
    }

    public void visit(Node.CustomTag n) throws JasperException {
        if (this.isSuppressed((Node)n)) {
            return;
        }
        CustomTagConverter converter = this.converters.get(n.getQName());
        if (converter == null) {
            throw new RuntimeException("Missing converter for custom tag: <" + n.getQName() + " />");
        }
        JtpCustomTag tag = new JtpCustomTag(n);
        this.output.pushTrimWhitespace(converter.isTrimWhitespace());
        converter.convert(this, tag, this.output, () -> tag.visitBody(this));
        this.output.popTrimWhitespace();
    }

    public void visit(Node.Comment n) {
        if (this.isSuppressed((Node)n)) {
            return;
        }
        this.output.append("<%--").append(n.getText()).append("--%>");
        if (this.output.isTrimWhitespace()) {
            this.output.setAllowNextWhitespace();
        }
    }

    public void visit(Node.Scriptlet n) throws JasperException {
        if (this.isSuppressed((Node)n)) {
            return;
        }
        super.visit(n);
    }

    public static JspElementType getType(Node n) {
        return JspElementType.valueOf(n.getClass().getSimpleName());
    }

    public void visit(Node.IncludeDirective n) throws JasperException {
        String file = n.getAttributeValue("file");
        if (!this.inlinedIncludes.contains(file)) {
            throw new UnsupportedOperationException("Includes are not supported. You should convert it to a tag first, or suppress with addInlinedInclude(\"" + file + "\")");
        }
        this.visitBody((Node)n);
    }

    public void visit(Node.DoBodyAction n) {
        this.addImport("gg.jte.Content");
        this.addParam("Content bodyContent");
        this.output.append("${bodyContent}");
    }

    protected void doVisit(Node n) {
        throw new RuntimeException("Unsupported feature detected: " + n.getClass().getSimpleName());
    }

    private boolean isSuppressed(Node n) {
        EnumSet<JspElementType> suppressedTypes = this.suppressions.get(n.getStart().getFile());
        if (suppressedTypes == null) {
            return false;
        }
        JspElementType type = JtpConverter.getType(n);
        return suppressedTypes.contains((Object)type);
    }
}

