/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.convert;

import java.util.ArrayDeque;
import java.util.Deque;

public class ConverterOutput {
    private final StringBuilder buffer = new StringBuilder();
    private final Deque<Boolean> trimWhitespaceStack = new ArrayDeque<Boolean>();
    private final Deque<Boolean> insideScriptStack = new ArrayDeque<Boolean>();
    private int indentationCount = 4;
    private char indentationChar = (char)32;
    private int skipIndent;
    private boolean trimWhitespace = false;
    private boolean insideScript = false;
    private boolean allowNextWhitespace = false;

    public ConverterOutput append(String s) {
        if (s != null) {
            this.buffer.append(this.trimIndent(s));
        }
        return this;
    }

    public ConverterOutput prepend(String s) {
        if (s != null) {
            this.buffer.insert(0, s);
        }
        return this;
    }

    public boolean isTrimWhitespace() {
        if (this.allowNextWhitespace) {
            this.allowNextWhitespace = false;
            return false;
        }
        return this.trimWhitespace;
    }

    public boolean isInsideScript() {
        return this.insideScript;
    }

    public ConverterOutput trim() {
        String trimmed = this.buffer.toString().trim();
        this.buffer.setLength(0);
        this.buffer.append(trimmed);
        return this;
    }

    public ConverterOutput newLine(String newLinePrefix) {
        this.buffer.append("\n");
        this.buffer.append(newLinePrefix);
        return this;
    }

    public int getCurrentLineCharCount() {
        int indentationBegin = this.buffer.lastIndexOf("\n");
        return this.buffer.length() - indentationBegin - 1;
    }

    public ConverterOutput newLine() {
        int indentationBegin = this.buffer.lastIndexOf("\n");
        int indentationEnd = -1;
        if (indentationBegin != -1) {
            for (int i = ++indentationBegin; i < this.buffer.length(); ++i) {
                if (Character.isWhitespace(this.buffer.charAt(i))) continue;
                indentationEnd = i;
                break;
            }
        }
        if (indentationBegin != -1 && indentationEnd != -1) {
            String indent = this.buffer.substring(indentationBegin, indentationEnd);
            this.newLine(indent);
        } else {
            this.newLine("");
        }
        return this;
    }

    public ConverterOutput indent(int amount) {
        for (int i = 0; i < amount * this.indentationCount; ++i) {
            this.buffer.append(this.indentationChar);
        }
        return this;
    }

    public void incrementSkipIndent() {
        ++this.skipIndent;
    }

    public void decrementSkipIndent() {
        --this.skipIndent;
    }

    private String trimIndent(String content) {
        if (this.skipIndent == 0) {
            return content;
        }
        StringBuilder result = new StringBuilder(content.length());
        int trim = 0;
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (c == '\n') {
                trim = this.skipIndent * this.indentationCount;
            } else if (trim > 0) {
                if (c == this.indentationChar) {
                    --trim;
                    continue;
                }
                trim = 0;
            }
            result.append(c);
        }
        return result.toString();
    }

    public char getIndentationChar() {
        return this.indentationChar;
    }

    public void setIndentationChar(char indentationChar) {
        this.indentationChar = indentationChar;
    }

    public void setIndentationCount(int indentationCount) {
        this.indentationCount = indentationCount;
    }

    public void pushTrimWhitespace(boolean trimWhitespace) {
        this.trimWhitespaceStack.push(trimWhitespace);
        this.trimWhitespace = trimWhitespace;
    }

    public void popTrimWhitespace() {
        this.trimWhitespaceStack.pop();
        this.trimWhitespace = this.trimWhitespaceStack.isEmpty() ? false : this.trimWhitespaceStack.peek();
    }

    public void pushInsideScript(boolean insideScript) {
        this.insideScriptStack.push(this.insideScript);
        this.insideScript = insideScript;
    }

    public void popInsideScript() {
        this.insideScriptStack.pop();
        this.insideScript = this.insideScriptStack.isEmpty() ? false : this.insideScriptStack.peek();
    }

    public void setAllowNextWhitespace() {
        this.allowNextWhitespace = true;
    }

    public String toString() {
        return this.buffer.toString();
    }
}

