/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.maven;

import gg.jte.CodeResolver;
import gg.jte.ContentType;
import gg.jte.TemplateEngine;
import gg.jte.html.HtmlPolicy;
import gg.jte.resolve.DirectoryCodeResolver;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="precompile", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class CompilerMojo
extends AbstractMojo {
    @Parameter
    public String sourceDirectory;
    @Parameter
    public String targetDirectory;
    @Parameter(defaultValue="${project.compileClasspathElements}", readonly=true, required=true)
    public List<String> compilePath;
    @Parameter(readonly=true, required=true)
    public String contentType;
    @Parameter(readonly=true)
    public boolean trimControlStructures;
    @Parameter(readonly=true)
    public String[] htmlTags;
    @Parameter(readonly=true)
    public String[] htmlAttributes;
    @Parameter(readonly=true)
    public String htmlPolicyClass;
    @Parameter(readonly=true)
    public boolean htmlCommentsPreserved;
    @Parameter(readonly=true)
    public String[] compileArgs;

    public void execute() {
        int amount;
        long start = System.nanoTime();
        Path source = Path.of(this.sourceDirectory, new String[0]);
        Path target = Path.of(this.targetDirectory, new String[0]);
        this.getLog().info((CharSequence)("Precompiling jte templates found in " + source));
        TemplateEngine templateEngine = TemplateEngine.create((CodeResolver)new DirectoryCodeResolver(source), (Path)target, (ContentType)ContentType.valueOf((String)this.contentType));
        templateEngine.setTrimControlStructures(this.trimControlStructures);
        templateEngine.setHtmlTags(this.htmlTags);
        templateEngine.setHtmlAttributes(this.htmlAttributes);
        if (this.htmlPolicyClass != null) {
            templateEngine.setHtmlPolicy(this.createHtmlPolicy(this.htmlPolicyClass));
        }
        templateEngine.setHtmlCommentsPreserved(this.htmlCommentsPreserved);
        templateEngine.setCompileArgs(this.compileArgs);
        try {
            templateEngine.cleanAll();
            amount = templateEngine.precompileAll(this.compilePath);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Failed to precompile templates.");
            this.getLog().error((Throwable)e);
            throw e;
        }
        long end = System.nanoTime();
        long duration = TimeUnit.NANOSECONDS.toSeconds(end - start);
        this.getLog().info((CharSequence)("Successfully precompiled " + amount + " jte file" + (amount == 1 ? "" : "s") + " in " + duration + "s to " + target));
    }

    private HtmlPolicy createHtmlPolicy(String htmlPolicyClass) {
        try {
            URLClassLoader projectClassLoader = this.createProjectClassLoader();
            Class<?> clazz = projectClassLoader.loadClass(htmlPolicyClass);
            return (HtmlPolicy)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to instantiate custom HtmlPolicy " + htmlPolicyClass, e);
        }
    }

    private URLClassLoader createProjectClassLoader() throws IOException {
        URL[] runtimeUrls = new URL[this.compilePath.size()];
        for (int i = 0; i < this.compilePath.size(); ++i) {
            String element = this.compilePath.get(i);
            runtimeUrls[i] = new File(element).toURI().toURL();
        }
        return new URLClassLoader(runtimeUrls, Thread.currentThread().getContextClassLoader());
    }
}

