/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.maven;

import gg.jte.CodeResolver;
import gg.jte.ContentType;
import gg.jte.TemplateEngine;
import gg.jte.resolve.DirectoryCodeResolver;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class GeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    public MavenProject project;
    @Parameter
    public String sourceDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/jte")
    public String targetDirectory;
    @Parameter(readonly=true, required=true)
    public String contentType;
    @Parameter(readonly=true)
    public boolean trimControlStructures;
    @Parameter(readonly=true)
    public String[] htmlTags;
    @Parameter(readonly=true)
    public String[] htmlAttributes;
    @Parameter(readonly=true)
    public boolean htmlCommentsPreserved;
    @Parameter(readonly=true)
    public boolean binaryStaticContent;
    @Parameter(readonly=true)
    public String packageName = "gg.jte.generated.precompiled";
    @Parameter
    public String targetResourceDirectory;
    @Parameter(defaultValue="false")
    public boolean generateNativeImageResources;

    public void execute() {
        int amount;
        long start = System.nanoTime();
        Path source = Paths.get(this.sourceDirectory, new String[0]);
        Path target = Paths.get(this.targetDirectory, new String[0]);
        this.getLog().info((CharSequence)("Generating jte templates found in " + source));
        TemplateEngine templateEngine = TemplateEngine.create((CodeResolver)new DirectoryCodeResolver(source), (Path)target, (ContentType)ContentType.valueOf((String)this.contentType), null, (String)this.packageName);
        templateEngine.setTrimControlStructures(this.trimControlStructures);
        templateEngine.setHtmlTags(this.htmlTags);
        templateEngine.setHtmlAttributes(this.htmlAttributes);
        templateEngine.setHtmlCommentsPreserved(this.htmlCommentsPreserved);
        templateEngine.setBinaryStaticContent(this.binaryStaticContent);
        if (this.targetResourceDirectory != null) {
            templateEngine.setTargetResourceDirectory(Paths.get(this.targetResourceDirectory, new String[0]));
            templateEngine.setGenerateNativeImageResources(this.generateNativeImageResources);
        }
        templateEngine.setProjectNamespace(this.project.getGroupId() + "/" + this.project.getArtifactId());
        try {
            templateEngine.cleanAll();
            amount = templateEngine.generateAll().size();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Failed to generate templates.");
            this.getLog().error((Throwable)e);
            throw e;
        }
        long end = System.nanoTime();
        long duration = TimeUnit.NANOSECONDS.toSeconds(end - start);
        this.getLog().info((CharSequence)("Successfully generated " + amount + " jte file" + (amount == 1 ? "" : "s") + " in " + duration + "s to " + target));
        this.project.addCompileSourceRoot(this.targetDirectory);
    }
}

