/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.maven;

import gg.jte.CodeResolver;
import gg.jte.ContentType;
import gg.jte.TemplateEngine;
import gg.jte.html.HtmlPolicy;
import gg.jte.resolve.DirectoryCodeResolver;
import gg.jte.runtime.StringUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="precompile", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class CompilerMojo
extends AbstractMojo {
    @Parameter(required=true)
    public String sourceDirectory;
    @Parameter(required=true)
    public String targetDirectory;
    @Parameter(defaultValue="${project.compileClasspathElements}", required=true)
    public List<String> compilePath;
    @Parameter(required=true)
    public String contentType;
    @Parameter
    public boolean trimControlStructures;
    @Parameter
    public String[] htmlTags;
    @Parameter
    public String htmlPolicyClass;
    @Parameter
    public boolean htmlCommentsPreserved;
    @Parameter
    public boolean binaryStaticContent;
    @Parameter
    public String[] compileArgs;
    @Parameter
    public String[] kotlinCompileArgs;
    @Parameter
    public String packageName = "gg.jte.generated.precompiled";
    @Parameter
    public boolean keepGeneratedSourceFiles;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;

    public void execute() {
        int amount;
        System.setProperty("kotlin.environment.keepalive", "false");
        long start = System.nanoTime();
        Path source = Paths.get(this.sourceDirectory, new String[0]);
        Path target = Paths.get(this.targetDirectory, new String[0]);
        this.getLog().info((CharSequence)("Precompiling jte templates found in " + String.valueOf(source)));
        TemplateEngine templateEngine = TemplateEngine.create((CodeResolver)new DirectoryCodeResolver(source), (Path)target, (ContentType)ContentType.valueOf((String)this.contentType), null, (String)this.packageName);
        templateEngine.setTrimControlStructures(this.trimControlStructures);
        templateEngine.setHtmlTags(this.htmlTags);
        if (this.htmlPolicyClass != null) {
            templateEngine.setHtmlPolicy(this.createHtmlPolicy(this.htmlPolicyClass));
        }
        templateEngine.setHtmlCommentsPreserved(this.htmlCommentsPreserved);
        templateEngine.setBinaryStaticContent(this.binaryStaticContent);
        templateEngine.setCompileArgs(this.calculateCompileArgs());
        templateEngine.setCompileArgs(this.kotlinCompileArgs);
        try {
            templateEngine.cleanAll();
            List generatedSourceFiles = templateEngine.precompileAll(this.compilePath);
            if (!this.keepGeneratedSourceFiles) {
                this.deleteGeneratedSourceFiles(target, generatedSourceFiles);
            }
            amount = generatedSourceFiles.size();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Failed to precompile templates.");
            this.getLog().error((Throwable)e);
            throw e;
        }
        long end = System.nanoTime();
        long duration = TimeUnit.NANOSECONDS.toSeconds(end - start);
        this.getLog().info((CharSequence)("Successfully precompiled " + amount + " jte file" + (amount == 1 ? "" : "s") + " in " + duration + "s to " + String.valueOf(target)));
    }

    private String[] calculateCompileArgs() {
        ArrayList<String> allCompileArgs = new ArrayList<String>();
        String javaRelease = this.project.getProperties().getProperty("maven.compiler.release");
        if (!StringUtils.isBlank((CharSequence)javaRelease)) {
            allCompileArgs.add("--release");
            allCompileArgs.add(javaRelease);
        } else {
            String javaTarget;
            String javaSource = this.project.getProperties().getProperty("maven.compiler.source");
            if (!StringUtils.isBlank((CharSequence)javaSource)) {
                allCompileArgs.add("-source");
                allCompileArgs.add(javaSource);
            }
            if (!StringUtils.isBlank((CharSequence)(javaTarget = this.project.getProperties().getProperty("maven.compiler.target")))) {
                allCompileArgs.add("-target");
                allCompileArgs.add(javaTarget);
            }
        }
        if (this.compileArgs != null) {
            allCompileArgs.addAll(Arrays.asList(this.compileArgs));
        }
        return allCompileArgs.toArray(new String[0]);
    }

    private void deleteGeneratedSourceFiles(Path target, List<String> generatedSources) {
        for (String generatedSource : generatedSources) {
            Path generatedSourceFile = target.resolve(generatedSource);
            if (generatedSourceFile.toFile().delete()) continue;
            this.getLog().warn((CharSequence)("Failed to delete generated source file " + String.valueOf(generatedSourceFile)));
        }
    }

    private HtmlPolicy createHtmlPolicy(String htmlPolicyClass) {
        HtmlPolicy htmlPolicy;
        block8: {
            URLClassLoader projectClassLoader = this.createProjectClassLoader();
            try {
                Class<?> clazz = projectClassLoader.loadClass(htmlPolicyClass);
                htmlPolicy = (HtmlPolicy)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (projectClassLoader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (projectClassLoader != null) {
                        try {
                            projectClassLoader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to instantiate custom HtmlPolicy " + htmlPolicyClass, e);
                }
            }
            projectClassLoader.close();
        }
        return htmlPolicy;
    }

    private URLClassLoader createProjectClassLoader() throws IOException {
        URL[] runtimeUrls = new URL[this.compilePath.size()];
        for (int i = 0; i < this.compilePath.size(); ++i) {
            String element = this.compilePath.get(i);
            runtimeUrls[i] = new File(element).toURI().toURL();
        }
        return new URLClassLoader(runtimeUrls, Thread.currentThread().getContextClassLoader());
    }
}

