/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.models.generator;

import gg.jte.ContentType;
import gg.jte.TemplateEngine;
import gg.jte.extension.api.JteConfig;
import gg.jte.extension.api.JteExtension;
import gg.jte.extension.api.TemplateDescription;
import gg.jte.models.generator.ModelConfig;
import gg.jte.models.generator.ModelGenerator;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ModelExtension
implements JteExtension {
    private ModelConfig modelConfig = new ModelConfig(Map.of());

    public String name() {
        return "Generate type-safe model facade for templates";
    }

    public JteExtension init(Map<String, String> value) {
        this.modelConfig = new ModelConfig(value);
        return this;
    }

    public Collection<Path> generate(JteConfig config, Set<TemplateDescription> templateDescriptions) {
        TemplateEngine engine = TemplateEngine.createPrecompiled((ContentType)ContentType.Plain);
        Pattern includePattern = this.modelConfig.includePattern();
        Pattern excludePattern = this.modelConfig.excludePattern();
        Set templateDescriptionsFiltered = templateDescriptions.stream().filter(x -> includePattern == null || includePattern.matcher(x.fullyQualifiedClassName()).matches()).filter(x -> excludePattern == null || !excludePattern.matcher(x.fullyQualifiedClassName()).matches()).collect(Collectors.toSet());
        return Stream.of(new ModelGenerator(engine, "interfacetemplates", "Templates", "Templates"), new ModelGenerator(engine, "statictemplates", "StaticTemplates", "Templates"), new ModelGenerator(engine, "dynamictemplates", "DynamicTemplates", "Templates")).map(g -> g.generate(config, templateDescriptionsFiltered, this.modelConfig)).collect(Collectors.toList());
    }
}

