/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.models.generator;

import gg.jte.models.generator.Language;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;

public class ModelConfig {
    private final Map<String, String> map;

    public ModelConfig(Map<String, String> value) {
        this.map = value;
    }

    public String interfaceAnnotation() {
        return this.map.getOrDefault("interfaceAnnotation", "");
    }

    public String implementationAnnotation() {
        return this.map.getOrDefault("implementationAnnotation", "");
    }

    public Language language() {
        String configuredLanguage = this.map.getOrDefault("language", "Java");
        try {
            return Language.valueOf(configuredLanguage);
        }
        catch (IllegalArgumentException ex) {
            String supportedValues = Arrays.toString((Object[])Language.values());
            throw new IllegalArgumentException(String.format("jte ModelExtension 'language' property is not configured correctly (current value is '%s'). Supported values: %s", configuredLanguage, supportedValues), ex);
        }
    }

    public Pattern includePattern() {
        String includePattern = this.map.get("includePattern");
        if (includePattern == null) {
            return null;
        }
        return Pattern.compile(includePattern);
    }

    public Pattern excludePattern() {
        String excludePattern = this.map.get("excludePattern");
        if (excludePattern == null) {
            return null;
        }
        return Pattern.compile(excludePattern);
    }
}

