/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.models.runtime;

import gg.jte.ContentType;
import gg.jte.TemplateException;
import gg.jte.TemplateOutput;
import gg.jte.html.HtmlInterceptor;
import gg.jte.html.HtmlTemplateOutput;
import gg.jte.html.OwaspHtmlTemplateOutput;
import gg.jte.models.runtime.JteModel;
import gg.jte.runtime.ClassInfo;
import gg.jte.runtime.DebugInfo;
import gg.jte.runtime.Template;
import gg.jte.runtime.TemplateLoader;
import java.util.List;
import java.util.function.BiConsumer;

public class StaticJteModel<OUTPUT extends TemplateOutput>
implements JteModel {
    ContentType contentType;
    BiConsumer<OUTPUT, HtmlInterceptor> renderer;
    StaticTemplateLoader loader;

    public StaticJteModel(ContentType contentType, BiConsumer<OUTPUT, HtmlInterceptor> renderer, String name, String packageName, int[] lineInfo) {
        this.contentType = contentType;
        this.renderer = renderer;
        this.loader = new StaticTemplateLoader(name, packageName, lineInfo);
    }

    @Override
    public void render(TemplateOutput output) {
        try {
            this.renderer.accept(this.getOutput(output), null);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    private TemplateException handleException(Exception e) {
        if (e instanceof TemplateException) {
            TemplateException exception = (TemplateException)e;
            return exception;
        }
        StackTraceElement[] stackTrace = e.getStackTrace();
        DebugInfo debugInfo = this.loader.resolveDebugInfo(null, stackTrace);
        String message = "Failed to render " + this.loader.name;
        if (debugInfo != null) {
            message = message + ", error at " + debugInfo.name + ":" + debugInfo.line;
            this.loader.rewriteStackTrace(e, null, stackTrace);
        }
        return new TemplateException(message, (Throwable)e);
    }

    public void writeTo(TemplateOutput output) {
        this.renderer.accept(this.getOutput(output), null);
    }

    private OUTPUT getOutput(TemplateOutput output) {
        if (this.contentType == ContentType.Html && !(output instanceof HtmlTemplateOutput)) {
            return (OUTPUT)new OwaspHtmlTemplateOutput(output);
        }
        return (OUTPUT)output;
    }

    private static class StaticTemplateLoader
    extends TemplateLoader {
        private final String name;
        private final ClassInfo classInfo;

        protected StaticTemplateLoader(String name, String packageName, int[] lineInfo) {
            super(null, packageName);
            this.name = name;
            this.classInfo = new ClassInfo(name, packageName);
            this.classInfo.lineInfo = lineInfo;
        }

        public Template hotReload(String name) {
            throw new UnsupportedOperationException("hotReload");
        }

        protected ClassInfo getClassInfo(ClassLoader ignored, String className) {
            if (this.classInfo.fullName.equals(className)) {
                return this.classInfo;
            }
            return null;
        }

        protected ClassLoader getClassLoader() {
            throw new UnsupportedOperationException("getClassLoader");
        }

        public List<String> getTemplatesUsing(String name) {
            throw new UnsupportedOperationException("getTemplatesUsing");
        }

        public void cleanAll() {
        }

        public List<String> generateAll() {
            throw new UnsupportedOperationException("generateAll");
        }

        public List<String> precompileAll() {
            throw new UnsupportedOperationException("precompileAll");
        }

        public boolean hasChanged(String name) {
            return false;
        }
    }
}

