/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.nativeimage;

import gg.jte.extension.api.JteConfig;
import gg.jte.extension.api.JteExtension;
import gg.jte.extension.api.TemplateDescription;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

public class NativeResourcesExtension
implements JteExtension {
    public String name() {
        return "native-image resource generator";
    }

    public Collection<Path> generate(JteConfig config, Set<TemplateDescription> templateDescriptions) {
        if (config.generatedResourcesRoot() == null || templateDescriptions.isEmpty()) {
            return Collections.emptyList();
        }
        String namespace = config.projectNamespace();
        if (namespace == null) {
            namespace = config.packageName();
        }
        Path resourceRoot = config.generatedResourcesRoot().resolve("META-INF/native-image/jte-generated/" + namespace);
        try {
            Files.createDirectories(resourceRoot, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return Arrays.asList(this.writeFile(resourceRoot.resolve("native-image.properties"), "Args = -H:ReflectionConfigurationResources=${.}/reflection-config.json -H:ResourceConfigurationResources=${.}/resource-config.json\n"), this.writeFile(resourceRoot.resolve("resource-config.json"), "{\"resources\": {\"includes\": [{\"pattern\": \".*Generated\\\\.bin$\"}]}}\n"), this.writeFile(resourceRoot.resolve("reflection-config.json"), templateDescriptions.stream().map(TemplateDescription::fullyQualifiedClassName).map(arg_0 -> NativeResourcesExtension.lambda$generate$0("{\"name\":\"%s\", \"allDeclaredMethods\":true, \"allDeclaredFields\":true}", arg_0)).collect(Collectors.joining(",\n", "[\n", "\n]\n"))));
    }

    private Path writeFile(Path path, String content) {
        try (FileWriter w = new FileWriter(path.toFile());){
            w.write(content);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return path;
    }

    private static /* synthetic */ String lambda$generate$0(String rec$, Object xva$0) {
        return "{\"name\":\"%s\", \"allDeclaredMethods\":true, \"allDeclaredFields\":true}".formatted(xva$0);
    }
}

