/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.internal;

import gg.jte.TemplateOutput;
import gg.jte.html.HtmlInterceptor;
import gg.jte.internal.TemplateType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

public final class Template {
    private final String name;
    private final TemplateType type;
    private final Class<?> clazz;
    private final int parameterCount;
    private Method render;
    private Method renderMap;

    public Template(String name, TemplateType type, Class<?> clazz) {
        this.name = name;
        this.type = type;
        this.clazz = clazz;
        this.findRenderMethods(clazz);
        this.parameterCount = this.resolveParameterCount();
    }

    public void render(TemplateOutput output, HtmlInterceptor htmlInterceptor, Object param) throws Throwable {
        try {
            if (this.parameterCount == 0) {
                this.render.invoke(null, output, htmlInterceptor);
            } else {
                this.render.invoke(null, output, htmlInterceptor, param);
            }
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public void renderMap(TemplateOutput output, HtmlInterceptor htmlInterceptor, Map<String, Object> params) throws Throwable {
        try {
            this.renderMap.invoke(null, output, htmlInterceptor, params);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public ClassLoader getClassLoader() {
        return this.clazz.getClassLoader();
    }

    private void findRenderMethods(Class<?> clazz) {
        for (Method declaredMethod : clazz.getDeclaredMethods()) {
            if ("render".equals(declaredMethod.getName())) {
                this.render = declaredMethod;
                continue;
            }
            if (!"renderMap".equals(declaredMethod.getName())) continue;
            this.renderMap = declaredMethod;
        }
        if (this.render == null) {
            throw new IllegalStateException("Failed to init " + this.type + " " + this.name + ", no method named 'render' found in " + clazz);
        }
        if (this.renderMap == null) {
            throw new IllegalStateException("Failed to init " + this.type + " " + this.name + ", no method named 'renderMap' found in " + clazz);
        }
    }

    private int resolveParameterCount() {
        if (this.type == TemplateType.Layout) {
            return this.render.getParameterCount() - 3;
        }
        return this.render.getParameterCount() - 2;
    }
}

