/*
 * Decompiled with CFR 0.152.
 */
package gg.jte;

import gg.jte.CodeResolver;
import gg.jte.ContentType;
import gg.jte.TemplateException;
import gg.jte.TemplateOutput;
import gg.jte.html.HtmlInterceptor;
import gg.jte.html.HtmlPolicy;
import gg.jte.html.HtmlTemplateOutput;
import gg.jte.html.OwaspHtmlTemplateOutput;
import gg.jte.runtime.DebugInfo;
import gg.jte.runtime.RuntimeTemplateLoader;
import gg.jte.runtime.Template;
import gg.jte.runtime.TemplateLoader;
import gg.jte.runtime.TemplateMode;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class TemplateEngine {
    private final TemplateLoader templateLoader;
    private final TemplateMode templateMode;
    private final ConcurrentMap<String, Template> templateCache;
    private final ContentType contentType;
    private final Path classDirectory;
    private final ClassLoader parentClassLoader;
    private HtmlInterceptor htmlInterceptor;

    public static TemplateEngine create(CodeResolver codeResolver, ContentType contentType) {
        return TemplateEngine.create(codeResolver, Paths.get("jte-classes", new String[0]), contentType);
    }

    public static TemplateEngine create(CodeResolver codeResolver, Path classDirectory, ContentType contentType) {
        return TemplateEngine.create(codeResolver, classDirectory, contentType, null);
    }

    public static TemplateEngine create(CodeResolver codeResolver, Path classDirectory, ContentType contentType, ClassLoader parentClassLoader) {
        return new TemplateEngine(codeResolver, classDirectory, contentType, TemplateMode.OnDemand, parentClassLoader);
    }

    public static TemplateEngine createPrecompiled(Path classDirectory, ContentType contentType) {
        return TemplateEngine.createPrecompiled(classDirectory, contentType, null);
    }

    public static TemplateEngine createPrecompiled(ContentType contentType) {
        return TemplateEngine.createPrecompiled(null, contentType);
    }

    public static TemplateEngine createPrecompiled(Path classDirectory, ContentType contentType, ClassLoader parentClassLoader) {
        return new TemplateEngine(null, classDirectory, contentType, TemplateMode.Precompiled, parentClassLoader);
    }

    private TemplateEngine(CodeResolver codeResolver, Path classDirectory, ContentType contentType, TemplateMode templateMode, ClassLoader parentClassLoader) {
        if (contentType == null) {
            throw new NullPointerException("Content type must be specified.");
        }
        this.templateLoader = TemplateEngine.createTemplateLoader(codeResolver, classDirectory, contentType, templateMode, parentClassLoader);
        this.templateMode = templateMode;
        this.templateCache = new ConcurrentHashMap<String, Template>();
        this.contentType = contentType;
        this.classDirectory = classDirectory;
        this.parentClassLoader = parentClassLoader;
        if (templateMode == TemplateMode.OnDemand) {
            this.cleanAll();
        }
    }

    private static TemplateLoader createTemplateLoader(CodeResolver codeResolver, Path classDirectory, ContentType contentType, TemplateMode templateMode, ClassLoader parentClassLoader) {
        if (templateMode == TemplateMode.Precompiled) {
            return new RuntimeTemplateLoader(classDirectory, parentClassLoader);
        }
        try {
            Class<?> compilerClass = Class.forName("gg.jte.compiler.TemplateCompiler");
            return (TemplateLoader)compilerClass.getConstructor(CodeResolver.class, Path.class, ContentType.class, ClassLoader.class).newInstance(new Object[]{codeResolver, classDirectory, contentType, parentClassLoader});
        }
        catch (Exception e) {
            throw new TemplateException("TemplateCompiler could not be located. Maybe jte isn't on your classpath?", e);
        }
    }

    public void render(String name, Object param, TemplateOutput output) throws TemplateException {
        Template template = this.resolveTemplate(name);
        try {
            template.render(this.checkOutput(output), this.htmlInterceptor, param);
        }
        catch (Throwable e) {
            throw this.handleRenderException(name, template, e);
        }
    }

    public void render(String name, Map<String, Object> params, TemplateOutput output) throws TemplateException {
        Template template = this.resolveTemplate(name);
        try {
            template.renderMap(this.checkOutput(output), this.htmlInterceptor, params);
        }
        catch (Throwable e) {
            throw this.handleRenderException(name, template, e);
        }
    }

    public void renderTag(String name, Map<String, Object> params, TemplateOutput output) throws TemplateException {
        Template template = this.resolveTemplate(name);
        try {
            template.renderMap(this.checkOutput(output), this.htmlInterceptor, params);
        }
        catch (Throwable e) {
            throw this.handleRenderException(name, template, e);
        }
    }

    public void renderLayout(String name, Map<String, Object> params, TemplateOutput output) throws TemplateException {
        this.renderTag(name, params, output);
    }

    private TemplateOutput checkOutput(TemplateOutput templateOutput) {
        if (this.contentType == ContentType.Html && !(templateOutput instanceof HtmlTemplateOutput)) {
            return new OwaspHtmlTemplateOutput(templateOutput);
        }
        return templateOutput;
    }

    private TemplateException handleRenderException(String name, Template template, Throwable e) {
        if (e instanceof TemplateException) {
            return (TemplateException)e;
        }
        DebugInfo debugInfo = this.templateLoader.resolveDebugInfo(template.getClassLoader(), e.getStackTrace());
        String message = "Failed to render " + name;
        if (debugInfo != null) {
            message = message + ", error at " + debugInfo.name + ":" + debugInfo.line;
        }
        return new TemplateException(message, e);
    }

    public List<String> getTemplatesUsing(String name) {
        if (name.startsWith("tag/") || name.startsWith("layout/")) {
            return this.templateLoader.getTemplatesUsing(name);
        }
        return Collections.singletonList(name);
    }

    public Map<String, Class<?>> getParamInfo(String name) throws TemplateException {
        return this.resolveTemplate(name).getParamInfo();
    }

    public void prepareForRendering(String name) {
        this.resolveTemplate(name);
    }

    public void cleanAll() {
        this.templateLoader.cleanAll();
    }

    public int generateAll() {
        return this.templateLoader.generateAll();
    }

    public int precompileAll() {
        return this.precompileAll(null);
    }

    public int precompileAll(List<String> compilePath) {
        return this.templateLoader.precompileAll(compilePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Template resolveTemplate(String name) {
        if (this.templateMode == TemplateMode.OnDemand && this.templateLoader.hasChanged(name)) {
            ConcurrentMap<String, Template> concurrentMap = this.templateCache;
            synchronized (concurrentMap) {
                if (this.templateLoader.hasChanged(name)) {
                    Template template = this.templateLoader.load(name);
                    this.templateCache.put(name, template);
                    return template;
                }
            }
        }
        return this.templateCache.computeIfAbsent(name, this.templateLoader::load);
    }

    public TemplateEngine reloadPrecompiled(TemplateEngine precompiler) throws TemplateException {
        precompiler.precompileAll();
        return this.reloadPrecompiled(precompiler.classDirectory);
    }

    public TemplateEngine reloadPrecompiled(Path classDirectory) throws TemplateException {
        TemplateEngine engine = TemplateEngine.createPrecompiled(classDirectory, this.contentType, this.parentClassLoader);
        engine.setHtmlInterceptor(this.htmlInterceptor);
        HashSet templates = new HashSet(this.templateCache.keySet());
        for (String templateName : templates) {
            engine.prepareForRendering(templateName);
        }
        return engine;
    }

    public void setCompileArgs(String ... compileArgs) {
        this.templateLoader.setCompileArgs(compileArgs);
    }

    public void setTrimControlStructures(boolean value) {
        this.templateLoader.setTrimControlStructures(value);
    }

    public void setHtmlPolicy(HtmlPolicy htmlPolicy) {
        if (htmlPolicy == null) {
            throw new NullPointerException("htmlPolicy must not be null");
        }
        this.templateLoader.setHtmlPolicy(htmlPolicy);
    }

    public void setHtmlTags(String ... htmlTags) {
        this.templateLoader.setHtmlTags(htmlTags);
    }

    public void setHtmlAttributes(String ... htmlAttributes) {
        this.templateLoader.setHtmlAttributes(htmlAttributes);
    }

    public void setHtmlInterceptor(HtmlInterceptor htmlInterceptor) {
        this.htmlInterceptor = htmlInterceptor;
    }

    public void setHtmlCommentsPreserved(boolean htmlCommentsPreserved) {
        this.templateLoader.setHtmlCommentsPreserved(htmlCommentsPreserved);
    }
}

