/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.runtime;

import gg.jte.TemplateException;
import gg.jte.html.HtmlPolicy;
import gg.jte.runtime.ClassInfo;
import gg.jte.runtime.DebugInfo;
import gg.jte.runtime.Template;
import gg.jte.runtime.TemplateType;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.List;

public abstract class TemplateLoader {
    protected final Path classDirectory;

    protected TemplateLoader(Path classDirectory) {
        this.classDirectory = classDirectory;
    }

    public Template load(String name) {
        ClassInfo templateInfo = new ClassInfo(name, "gg.jte.generated");
        TemplateType templateType = this.getTemplateType(name);
        try {
            Class<?> clazz = this.getClassLoader().loadClass(templateInfo.fullName);
            return new Template(name, templateType, clazz);
        }
        catch (Exception e) {
            throw new TemplateException("Failed to load " + name, e);
        }
    }

    public DebugInfo resolveDebugInfo(ClassLoader classLoader, StackTraceElement[] stackTrace) {
        if (stackTrace.length == 0) {
            return null;
        }
        for (StackTraceElement stackTraceElement : stackTrace) {
            ClassInfo classInfo;
            if (!stackTraceElement.getClassName().startsWith("gg.jte.generated") || (classInfo = this.getClassInfo(classLoader, stackTraceElement.getClassName())) == null) continue;
            return new DebugInfo(classInfo.name, this.resolveLineNumber(classInfo, stackTraceElement.getLineNumber()));
        }
        return null;
    }

    protected abstract ClassInfo getClassInfo(ClassLoader var1, String var2);

    private int resolveLineNumber(ClassInfo classInfo, int lineNumber) {
        int lineIndex = lineNumber - 1;
        int[] javaLineToTemplateLine = classInfo.lineInfo;
        if (lineIndex >= javaLineToTemplateLine.length) {
            return 0;
        }
        return javaLineToTemplateLine[lineIndex] + 1;
    }

    protected TemplateType getTemplateType(String name) {
        if (name.startsWith("tag/")) {
            return TemplateType.Tag;
        }
        if (name.startsWith("layout/")) {
            return TemplateType.Layout;
        }
        return TemplateType.Template;
    }

    protected abstract ClassLoader getClassLoader();

    protected ClassLoader createClassLoader(ClassLoader parentClassLoader) {
        try {
            URL[] urls = new URL[]{this.classDirectory.toUri().toURL()};
            if (parentClassLoader == null) {
                return new URLClassLoader(urls);
            }
            return new URLClassLoader(urls, parentClassLoader);
        }
        catch (MalformedURLException e) {
            throw new TemplateException("Failed to create class loader for " + this.classDirectory, e);
        }
    }

    public abstract void setHtmlPolicy(HtmlPolicy var1);

    public abstract void setTrimControlStructures(boolean var1);

    public abstract void setHtmlTags(String[] var1);

    public abstract void setHtmlAttributes(String[] var1);

    public abstract void setHtmlCommentsPreserved(boolean var1);

    public abstract void setCompileArgs(String[] var1);

    public abstract List<String> getTemplatesUsing(String var1);

    public abstract void cleanAll();

    public abstract int generateAll();

    public abstract int precompileAll(List<String> var1);

    public abstract boolean hasChanged(String var1);
}

