/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.runtime;

import gg.jte.html.HtmlPolicy;
import gg.jte.runtime.ClassInfo;
import gg.jte.runtime.TemplateLoader;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;

public class RuntimeTemplateLoader
extends TemplateLoader {
    private final ClassLoader singleClassLoader;

    public RuntimeTemplateLoader(Path classDirectory, ClassLoader parentClassLoader) {
        super(classDirectory);
        this.singleClassLoader = this.createClassLoader(parentClassLoader);
    }

    @Override
    protected ClassLoader createClassLoader(ClassLoader parentClassLoader) {
        if (this.classDirectory == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return super.createClassLoader(parentClassLoader);
    }

    @Override
    protected ClassInfo getClassInfo(ClassLoader classLoader, String className) {
        try {
            Class<?> clazz = classLoader.loadClass(className);
            ClassInfo classInfo = new ClassInfo((String)clazz.getField("JTE_NAME").get(null), "");
            classInfo.lineInfo = (int[])clazz.getField("JTE_LINE_INFO").get(null);
            return classInfo;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected ClassLoader getClassLoader() {
        return this.singleClassLoader;
    }

    @Override
    public void setTrimControlStructures(boolean value) {
    }

    @Override
    public void setHtmlPolicy(HtmlPolicy htmlPolicy) {
    }

    @Override
    public void setHtmlTags(String[] htmlTags) {
    }

    @Override
    public void setHtmlAttributes(String[] htmlAttributes) {
    }

    @Override
    public void setHtmlCommentsPreserved(boolean htmlCommentsPreserved) {
    }

    @Override
    public void setBinaryStaticContent(boolean binaryStaticContent) {
    }

    @Override
    public void setCompileArgs(String[] compileArgs) {
    }

    @Override
    public List<String> getTemplatesUsing(String name) {
        return Collections.emptyList();
    }

    @Override
    public void cleanAll() {
    }

    @Override
    public List<String> generateAll() {
        return null;
    }

    @Override
    public List<String> precompileAll(List<String> compilePath) {
        return null;
    }

    @Override
    public boolean hasChanged(String name) {
        return false;
    }
}

