/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.output;

import gg.jte.TemplateOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;

public final class Utf8ByteOutput
extends Writer
implements TemplateOutput {
    private final int chunkSize;
    private final char[] tempBuffer;
    private final int tempBufferSize;
    private ArrayList<Chunk> chunks;
    private byte[] buffer;
    private int lastIndex;
    private int currentIndex;
    private char highSurrogate;

    public Utf8ByteOutput() {
        this(1024, 512);
    }

    public Utf8ByteOutput(int chunkSize, int tempBufferSize) {
        this.chunkSize = chunkSize;
        this.buffer = new byte[this.chunkSize];
        this.tempBufferSize = tempBufferSize;
        this.tempBuffer = new char[tempBufferSize];
    }

    public int getContentLength() {
        int contentLength = this.currentIndex - this.lastIndex;
        if (this.chunks != null) {
            for (Chunk chunk : this.chunks) {
                contentLength += chunk.length;
            }
        }
        return contentLength;
    }

    public void writeTo(OutputStream os) throws IOException {
        this.writeTo(os::write);
    }

    public void writeTo(DataConsumer dataConsumer) throws IOException {
        int remaining;
        if (this.chunks != null) {
            for (Chunk chunk : this.chunks) {
                dataConsumer.accept(chunk.data, chunk.startIndex, chunk.length);
            }
        }
        if ((remaining = this.currentIndex - this.lastIndex) > 0) {
            dataConsumer.accept(this.buffer, this.lastIndex, remaining);
        }
    }

    @Override
    public Writer getWriter() {
        return this;
    }

    @Override
    public void writeContent(String s) {
        int len = s.length();
        for (int i = 0; i < len; i += this.tempBufferSize) {
            int size = Math.min(this.tempBufferSize, len - i);
            s.getChars(i, i + size, this.tempBuffer, 0);
            this.write(this.tempBuffer, 0, size);
        }
    }

    @Override
    public void writeBinaryContent(byte[] value) {
        if (value.length < 16) {
            this.doAppend(value);
        } else {
            if (this.lastIndex < this.currentIndex) {
                this.addCurrentChunk();
                this.lastIndex = this.currentIndex;
            }
            this.addChunk(new Chunk(value, 0, value.length));
        }
    }

    @Override
    public void writeUserContent(boolean value) {
        this.appendLatin1(String.valueOf(value));
    }

    @Override
    public void writeUserContent(byte value) {
        this.appendLatin1(Byte.toString(value));
    }

    @Override
    public void writeUserContent(char value) {
        this.appendUtf8Char(value);
    }

    @Override
    public void writeUserContent(int value) {
        this.appendLatin1(Integer.toString(value));
    }

    @Override
    public void writeUserContent(long value) {
        this.appendLatin1(Long.toString(value));
    }

    @Override
    public void writeUserContent(float value) {
        this.appendLatin1(Float.toString(value));
    }

    @Override
    public void writeUserContent(double value) {
        this.appendLatin1(Double.toString(value));
    }

    @Override
    public void write(char[] buffer, int off, int len) {
        int i = off;
        len += off;
        while (i < len) {
            this.write(buffer[i++]);
        }
    }

    public void write(char c) {
        if (this.highSurrogate != '\u0000') {
            if (Character.isLowSurrogate(c)) {
                this.appendUtf8CodePoint(Character.toCodePoint(this.highSurrogate, c));
            } else {
                this.doAppend((byte)-3);
                this.appendUtf8Char(c);
            }
            this.highSurrogate = '\u0000';
        } else if (Character.isHighSurrogate(c)) {
            this.highSurrogate = c;
        } else {
            this.appendUtf8Char(c);
        }
    }

    @Override
    public void write(int c) {
        this.write((char)c);
    }

    @Override
    public void write(char[] buffer) {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(String str) {
        this.writeContent(str);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    private void appendLatin1(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.doAppend((byte)s.charAt(i));
        }
    }

    private void appendUtf8Char(char c) {
        if (c < '\u0080') {
            this.doAppend((byte)c);
        } else if (c < '\u0800') {
            this.doAppend((byte)(0xC0 | c >> 6));
            this.doAppend((byte)(0x80 | c & 0x3F));
        } else {
            this.doAppend((byte)(0xE0 | c >> 12));
            this.doAppend((byte)(0x80 | c >> 6 & 0x3F));
            this.doAppend((byte)(0x80 | c & 0x3F));
        }
    }

    private void appendUtf8CodePoint(int c) {
        this.doAppend((byte)(0xF0 | c >> 18));
        this.doAppend((byte)(0x80 | c >> 12 & 0x3F));
        this.doAppend((byte)(0x80 | c >> 6 & 0x3F));
        this.doAppend((byte)(0x80 | c & 0x3F));
    }

    private void doAppend(byte[] bytes) {
        int length = bytes.length;
        if (this.currentIndex + length < this.chunkSize) {
            System.arraycopy(bytes, 0, this.buffer, this.currentIndex, length);
            this.currentIndex += length;
        } else {
            for (byte b : bytes) {
                this.doAppend(b);
            }
        }
    }

    private void doAppend(byte b) {
        if (this.currentIndex == this.chunkSize) {
            this.createNewChunk();
        }
        this.buffer[this.currentIndex++] = b;
    }

    private void createNewChunk() {
        this.addCurrentChunk();
        this.buffer = new byte[this.chunkSize];
        this.lastIndex = 0;
        this.currentIndex = 0;
    }

    private void addCurrentChunk() {
        this.addChunk(new Chunk(this.buffer, this.lastIndex, this.currentIndex - this.lastIndex));
    }

    private void addChunk(Chunk chunk) {
        if (this.chunks == null) {
            this.chunks = new ArrayList();
        }
        this.chunks.add(chunk);
    }

    private static final class Chunk {
        final byte[] data;
        final int startIndex;
        final int length;

        public Chunk(byte[] data, int startIndex, int length) {
            this.data = data;
            this.startIndex = startIndex;
            this.length = length;
        }
    }

    @FunctionalInterface
    public static interface DataConsumer {
        public void accept(byte[] var1, int var2, int var3) throws IOException;
    }
}

