/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.runtime;

import gg.jte.TemplateException;
import gg.jte.TemplateNotFoundException;
import gg.jte.runtime.ClassInfo;
import gg.jte.runtime.DebugInfo;
import gg.jte.runtime.Template;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.List;

public abstract class TemplateLoader {
    protected final Path classDirectory;
    protected final String packageName;

    protected TemplateLoader(Path classDirectory, String packageName) {
        this.classDirectory = classDirectory;
        this.packageName = packageName;
    }

    public Template load(String name) {
        ClassInfo templateInfo = new ClassInfo(name, this.packageName);
        try {
            Class<?> clazz = this.getClassLoader().loadClass(templateInfo.fullName);
            return new Template(name, clazz);
        }
        catch (Exception e) {
            throw new TemplateNotFoundException("Failed to load " + name, e);
        }
    }

    public abstract Template hotReload(String var1);

    public DebugInfo resolveDebugInfo(ClassLoader classLoader, StackTraceElement[] stackTrace) {
        if (stackTrace.length == 0) {
            return null;
        }
        for (StackTraceElement stackTraceElement : stackTrace) {
            ClassInfo classInfo;
            if (!stackTraceElement.getClassName().startsWith(this.packageName) || (classInfo = this.getClassInfo(classLoader, this.getClassName(stackTraceElement))) == null) continue;
            return new DebugInfo(classInfo.name, this.resolveLineNumber(classInfo, stackTraceElement.getLineNumber()));
        }
        return null;
    }

    public void rewriteStackTrace(Throwable e, ClassLoader classLoader, StackTraceElement[] stackTrace) {
        if (stackTrace.length == 0) {
            return;
        }
        for (int i = 0; i < stackTrace.length; ++i) {
            ClassInfo classInfo;
            StackTraceElement stackTraceElement = stackTrace[i];
            if (!stackTraceElement.getClassName().startsWith(this.packageName) || (classInfo = this.getClassInfo(classLoader, this.getClassName(stackTraceElement))) == null) continue;
            stackTrace[i] = new StackTraceElement(stackTraceElement.getClassName(), stackTraceElement.getMethodName(), classInfo.name, this.resolveLineNumber(classInfo, stackTraceElement.getLineNumber()));
        }
        e.setStackTrace(stackTrace);
    }

    private String getClassName(StackTraceElement stackTraceElement) {
        String className = stackTraceElement.getClassName();
        if (className.endsWith("$Companion")) {
            return className.substring(0, className.length() - "$Companion".length());
        }
        return className;
    }

    protected abstract ClassInfo getClassInfo(ClassLoader var1, String var2);

    private int resolveLineNumber(ClassInfo classInfo, int lineNumber) {
        if (lineNumber < 0) {
            return 0;
        }
        int lineIndex = lineNumber - 1;
        int[] codeLineToTemplateLine = classInfo.lineInfo;
        if (lineIndex >= codeLineToTemplateLine.length) {
            return 0;
        }
        return codeLineToTemplateLine[lineIndex] + 1;
    }

    protected abstract ClassLoader getClassLoader();

    protected ClassLoader createClassLoader(ClassLoader parentClassLoader) {
        try {
            URL[] urls = new URL[]{this.classDirectory.toUri().toURL()};
            if (parentClassLoader == null) {
                return new URLClassLoader(urls);
            }
            return new URLClassLoader(urls, parentClassLoader);
        }
        catch (MalformedURLException e) {
            throw new TemplateException("Failed to create class loader for " + String.valueOf(this.classDirectory), e);
        }
    }

    public abstract List<String> getTemplatesUsing(String var1);

    public abstract void cleanAll();

    public abstract List<String> generateAll();

    public abstract List<String> precompileAll();

    public abstract boolean hasChanged(String var1);
}

