/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.support;

import java.util.Iterator;

public class ForSupport<T>
implements Iterable<ForSupport<T>> {
    private final Iterator<T> iterator;
    private T item;
    private int index = -1;

    public static <T> ForSupport<T> of(Iterable<T> iterable) {
        return new ForSupport<T>(iterable.iterator());
    }

    public static <T> ForSupport<T> of(final T[] array) {
        return new ForSupport<T>(new Iterator<T>(){
            private int i;

            @Override
            public boolean hasNext() {
                return this.i < array.length;
            }

            @Override
            public T next() {
                return array[this.i++];
            }
        });
    }

    public ForSupport(Iterator<T> iterator) {
        this.iterator = iterator;
    }

    public boolean isLast() {
        return !this.iterator.hasNext();
    }

    public boolean isFirst() {
        return this.index == 0;
    }

    public int getIndex() {
        return this.index;
    }

    public T get() {
        return this.item;
    }

    @Override
    public Iterator<ForSupport<T>> iterator() {
        return new Iterator<ForSupport<T>>(){

            @Override
            public boolean hasNext() {
                return ForSupport.this.iterator.hasNext();
            }

            @Override
            public ForSupport<T> next() {
                ForSupport.this.item = ForSupport.this.iterator.next();
                ++ForSupport.this.index;
                return ForSupport.this;
            }
        };
    }
}

