/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.watcher;

import com.sun.nio.file.SensitivityWatchEventModifier;
import gg.jte.TemplateEngine;
import gg.jte.compiler.IoUtils;
import gg.jte.resolve.DirectoryCodeResolver;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import java.util.function.Consumer;

public class DirectoryWatcher {
    private final TemplateEngine templateEngine;
    private final Path root;
    private Thread reloadThread;

    public DirectoryWatcher(TemplateEngine templateEngine, DirectoryCodeResolver codeResolver) {
        this(templateEngine, codeResolver.getRoot());
    }

    public DirectoryWatcher(TemplateEngine templateEngine, Path root) {
        this.templateEngine = templateEngine;
        this.root = root;
    }

    public void start(Consumer<List<String>> onTemplatesChanged) {
        this.reloadThread = new Thread(() -> this.startBlocking(onTemplatesChanged));
        this.reloadThread.setName("jte-reloader");
        this.reloadThread.setDaemon(true);
        this.reloadThread.start();
    }

    public void stop() {
        this.reloadThread.interrupt();
        this.reloadThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBlocking(Consumer<List<String>> onTemplatesChanged) {
        try (WatchService watchService = FileSystems.getDefault().newWatchService();){
            WatchKey watchKey;
            Files.walk(this.root, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(p -> {
                try {
                    p.register(watchService, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY}, SensitivityWatchEventModifier.HIGH);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to register watch service for hot reload!", e);
                }
            });
            while ((watchKey = watchService.take()) != null) {
                try {
                    List<WatchEvent<?>> events = watchKey.pollEvents();
                    for (WatchEvent<?> event : events) {
                        Path file;
                        Path absoluteFile;
                        String eventContext = event.context().toString();
                        if (!IoUtils.isTemplateFile((String)eventContext) || (absoluteFile = this.root.resolve(file = this.root.relativize((Path)watchKey.watchable()).resolve(eventContext))).toFile().length() <= 0L) continue;
                        String name = file.toString().replace('\\', '/');
                        List changedTemplates = this.templateEngine.getTemplatesUsing(name);
                        if (onTemplatesChanged == null) continue;
                        onTemplatesChanged.accept(changedTemplates);
                    }
                }
                finally {
                    watchKey.reset();
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to watch page content", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

