package host.anzo.anticheat.proxy;

import com.sun.jna.Library;
import com.sun.jna.Native;

import java.util.Collections;

/**
 * @author ANZO
 * @since 9/17/2024
 */
public interface ProxyLibrary extends Library {
	ProxyLibrary instance = getLibraryInstance();

	static ProxyLibrary getLibraryInstance() {
		return Native.load("proxy", ProxyLibrary.class, Collections.singletonMap(Library.OPTION_STRING_ENCODING, "UTF-8"));
	}

	/**
	 * @param remoteUrl remote tunnel address
	 * @param localUrl local host and port (format: host:port)
	 * @return {@code 0} if a tunnel started successfully, any other codes otherwise
	 */
	int StartTunnelFor(String remoteUrl, String localUrl);
}
