package host.anzo.anticheat.utils;

import org.jetbrains.annotations.Nullable;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.regex.Pattern;

/**
 * @author ANZO
 * @since 9/17/2024
 */
public class IpUtils {
	private static final Pattern VALID_IPV4_PATTERN = Pattern.compile("(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])", Pattern.CASE_INSENSITIVE);
	private static String EXTERNAL_IP = null;

	private final static HttpClient client = HttpClient.newHttpClient();

	/**
	 * @return external IP address, {@code null} if can't detect external IP
	 */
	public static @Nullable String getExternalIP() {
		if (checkIPv4(EXTERNAL_IP)) {
			return EXTERNAL_IP;
		}
		String ip = httpGet("https://api.ipify.org/");
		if (!checkIPv4(ip)) {
			ip = httpGet("http://ipinfo.io/ip");
		}
		if (!checkIPv4(ip)) {
			ip = httpGet("https://www.trackip.net/ip");
		}
		if (!checkIPv4(ip)) {
			ip = httpGet("http://checkip.amazonaws.com/");
		}
		if (checkIPv4(ip)) {
			EXTERNAL_IP = ip;
			return ip;
		}
		return null;
	}

	/**
	 * @param ip IP for check
	 * @return {@code true} if specified IP string is valid IPv4 address
	 */
	private static boolean checkIPv4(final String ip) {
		if (ip == null || ip.isEmpty()) {
			return false;
		}
		return VALID_IPV4_PATTERN.matcher(ip).matches();
	}

	private static @Nullable String httpGet(String url) {
		final HttpRequest request = HttpRequest.newBuilder()
				.uri(URI.create(url))
				.GET()
				.build();
		try {
			return client.send(request, HttpResponse.BodyHandlers.ofString()).body();
		}
		catch (Exception e) {
			return null;
		}
	}
}