package host.anzo.anticheat.server.api.model;

import host.anzo.anticheat.server.api.interfaces.IAntiCheatClientAPI;
import host.anzo.anticheat.server.api.enums.EAntiCheatClientState;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.jetbrains.annotations.NotNull;

import java.io.Serializable;

/**
 * @author ANZO
 * @since 9/15/2024
 */
@ToString
public @Getter class AntiCheatClientInfo implements Serializable {
	private final int id;
	private final String name;
	private final String ip;
	private final String password;
	private @Setter EAntiCheatClientState state;
	private @Setter long playersOnline;

	private @Setter IAntiCheatClientAPI connection;

	/**
	 * Default constructor for loading client info from a predefined list (server side)
	 * @param id client ID
	 * @param name client name
	 * @param ip client IP address
	 * @param password client password
	 */
	public AntiCheatClientInfo(int id, String name, String ip, String password) {
		this.id = id;
		this.name = name;
		this.ip = ip;
		this.password = password;
		this.state = EAntiCheatClientState.DISCONNECTED;
	}

	public void update(IAntiCheatClientAPI connection, @NotNull AntiCheatClientInfo channelInfo) {
		this.connection = connection;
		this.state = EAntiCheatClientState.CONNECTED;
		this.playersOnline = channelInfo.getPlayersOnline();
	}

	public void reset() {
		this.state = EAntiCheatClientState.DISCONNECTED;
		this.connection = null;
		this.playersOnline = 0;
	}
}