package host.anzo.anticheat.server.api.interfaces;

import host.anzo.anticheat.server.api.enums.EAntiClientRegisterResult;
import host.anzo.anticheat.server.api.model.AntiCheatClientInfo;
import org.jetbrains.annotations.NotNull;

/**
 * @author ANZO
 * @since 9/15/2024
 */
public interface IAntiCheatServerAPI {
	/**
	 * @return {@code true} if server API connection is alive, {@code false} otherwise
	 */
	boolean testConnection();

	/**
	 * Register a client at master server
	 * @param connection client connection
	 * @param clientInfo client information
	 * @return client registration result
	 */
	EAntiClientRegisterResult registerClient(IAntiCheatClientAPI connection, @NotNull AntiCheatClientInfo clientInfo);

	void updateClient(IAntiCheatClientAPI connection, @NotNull AntiCheatClientInfo clientInfo);
}