package host.anzo.anticheat.commons;

import lombok.extern.slf4j.Slf4j;

/**
 * @author ANZO
 */
@Slf4j
public class RunnableWrapper implements Runnable {
	private final Runnable runnable;
    private final String name;

	public RunnableWrapper(final Runnable r) {
		this(r, null);
	}

    public RunnableWrapper(final Runnable r, final String name) {
	    this.runnable = r;
        this.name = name != null ? name : r.getClass().getSimpleName();
    }

	@Override
	public void run() {
		if (runnable != null) {
			try {
				runnable.run();
			} catch (final Throwable e) {
				log.error("Error while running RunnableWrapper:", e);
				throw new RuntimeException(e);
			}
		}
	}
}