package host.anzo.anticheat.config;

import host.anzo.commons.annotations.config.ConfigComments;
import host.anzo.commons.annotations.config.ConfigFile;
import host.anzo.commons.annotations.config.ConfigProperty;

/**
 * @author ANZO
 * @since 9/18/2024
 */
@ConfigFile(name = "config/anticheatserver.properties")
public class AntiCheatServerConfig {
	@ConfigComments(comment = {"Enable Epic Online Services", "Default: false"})
	@ConfigProperty(name = "eos.enable", value = "false")
	public static boolean ENABLE;

	@ConfigComments(comment = {"Enable debug mode", "Default: false"})
	@ConfigProperty(name = "eos.debug", value = "false")
	public static boolean DEBUG;

	@ConfigComments(comment = {"EOS product name", "Default: "})
	@ConfigProperty(name = "eos.product_name")
	public static String PRODUCT_NAME;

	@ConfigComments(comment = {"EOS product version", "Default: 1.0"})
	@ConfigProperty(name = "eos.product_version", value = "1.0")
	public static String PRODUCT_VERSION;

	@ConfigComments(comment = {"EOS product ID", "Default: "})
	@ConfigProperty(name = "eos.product_id")
	public static String PRODUCT_ID;

	@ConfigComments(comment = {"EOS sandbox ID", "Default: "})
	@ConfigProperty(name = "eos.sandbox_id")
	public static String SANDBOX_ID;

	@ConfigComments(comment = {"EOS deployment ID", "Default: "})
	@ConfigProperty(name = "eos.deployment_id")
	public static String DEPLOYMENT_ID;

	@ConfigComments(comment = {"EOS client ID", "Default: "})
	@ConfigProperty(name = "eos.client_id")
	public static String CLIENT_ID;

	@ConfigComments(comment = {"EOS client secret", "Default:"})
	@ConfigProperty(name = "eos.client_secret")
	public static String CLIENT_SECRET;

	@ConfigComments(comment = {"Platform tick event frequency (in milliseconds)", "Default: 100"})
	@ConfigProperty(name = "eos.platform_tick_period", value = "100")
	public static int PLATFORM_TICK_PERIOD;

	@ConfigComments(comment = {"Anti-cheat server instance name", "Default: Test Server"})
	@ConfigProperty(name = "eos.anti_cheat_server_name", value = "Test Server")
	public static String ANTI_CHEAT_SERVER_NAME;

	@ConfigComments(comment = {"Anti-cheat client register timeout (in seconds)", "Default: 30"})
	@ConfigProperty(name = "eos.anti_cheat_client_register_timeout", value = "30")
	public static int ANTI_CHEAT_CLIENT_REGISTER_TIMEOUT;

	@ConfigComments(comment = {"Enable gameplay data collection", "Default: false"})
	@ConfigProperty(name = "eos.anti_cheat_enable_gameplay_data", value = "false")
	public static boolean ANTI_CHEAT_ENABLE_GAMEPLAY_DATA;
}