/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.anticheat.server.api;

import host.anzo.anticheat.commons.utils.IpUtils;
import host.anzo.anticheat.config.AntiCheatClientConfig;
import host.anzo.anticheat.proxy.AntiCheatProxyLibrary;
import host.anzo.anticheat.server.api.enums.EAntiClientRegisterResult;
import host.anzo.anticheat.server.api.interfaces.rmi.IRMIAntiCheatClientAPI;
import host.anzo.anticheat.server.api.interfaces.rmi.IRMIAntiCheatServerAPI;
import host.anzo.anticheat.server.api.model.AntiCheatClientInfo;
import host.anzo.anticheat.server.api.model.AntiCheatTokenInfo;
import host.anzo.simon.ClosedListener;
import host.anzo.simon.Lookup;
import host.anzo.simon.Simon;
import host.anzo.simon.exceptions.EstablishConnectionFailed;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AAntiCheatClientAPIConnection {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AAntiCheatClientAPIConnection.class);
    private Lookup nameLookup;
    private IRMIAntiCheatServerAPI serverAPI;
    private transient ScheduledFuture<?> reconnectTask;
    private transient ScheduledFuture<?> updateTask;
    private final ApiDisconnectedListener disconnectedListener = new ApiDisconnectedListener();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private int rmiLocalProxyPort = -1;

    public abstract long getPlayersOnline();

    public abstract IRMIAntiCheatClientAPI getClientAPI();

    protected void initialize() {
        if (!AntiCheatClientConfig.RMI_ENABLED) {
            return;
        }
        this.rmiLocalProxyPort = IpUtils.getFreePort();
        if (this.rmiLocalProxyPort == -1) {
            throw new RuntimeException("Failed to find free port for RMI proxy");
        }
        int proxyStartResult = AntiCheatProxyLibrary.instance.StartTunnelFor("rmi.anzo.host", "127.0.0.1:" + this.rmiLocalProxyPort);
        if (proxyStartResult != 0) {
            throw new RuntimeException("RMI proxy startup failed. Code: " + proxyStartResult);
        }
        this.connectToAntiCheatServer();
    }

    private void connectToAntiCheatServer() {
        block19: {
            EAntiClientRegisterResult registerResult = EAntiClientRegisterResult.NONE;
            try {
                try {
                    if (this.nameLookup == null) {
                        this.nameLookup = Simon.createNameLookup((String)"127.0.0.1", (int)this.rmiLocalProxyPort);
                    }
                    this.serverAPI = (IRMIAntiCheatServerAPI)this.nameLookup.lookup("master_server");
                    if (this.serverAPI != null) {
                        this.nameLookup.addClosedListener((Object)this.serverAPI, (ClosedListener)this.disconnectedListener);
                        registerResult = this.serverAPI.registerClient(this.getClientAPI(), this.getClientInfo());
                    }
                }
                catch (EstablishConnectionFailed establishConnectionFailed) {
                    log.warn("Master Anti-Cheat API server isn't available. Make sure it's up and running.");
                    if (registerResult == EAntiClientRegisterResult.SUCCESS) {
                        this.onConnected();
                        log.info("Anti-cheat client registered on master API successfully.");
                    } else {
                        if (this.nameLookup != null && this.serverAPI != null) {
                            this.nameLookup.release((Object)this.serverAPI);
                        } else {
                            this.disconnectedListener.closed();
                        }
                        log.warn("Anti-cheat client failed to connect to master API. Reason: {}", (Object)registerResult.toString());
                    }
                }
                catch (Exception e) {
                    block20: {
                        log.error("Error while connecting to Anti-Cheat API.", (Throwable)e);
                        if (registerResult != EAntiClientRegisterResult.SUCCESS) break block20;
                        this.onConnected();
                        log.info("Anti-cheat client registered on master API successfully.");
                        break block19;
                    }
                    if (this.nameLookup != null && this.serverAPI != null) {
                        this.nameLookup.release((Object)this.serverAPI);
                    } else {
                        this.disconnectedListener.closed();
                    }
                    log.warn("Anti-cheat client failed to connect to master API. Reason: {}", (Object)registerResult.toString());
                }
            }
            finally {
                if (registerResult == EAntiClientRegisterResult.SUCCESS) {
                    this.onConnected();
                    log.info("Anti-cheat client registered on master API successfully.");
                } else {
                    if (this.nameLookup != null && this.serverAPI != null) {
                        this.nameLookup.release((Object)this.serverAPI);
                    } else {
                        this.disconnectedListener.closed();
                    }
                    log.warn("Anti-cheat client failed to connect to master API. Reason: {}", (Object)registerResult.toString());
                }
            }
        }
    }

    public void updateClientInfo() {
        if (this.reconnectTask != null || this.serverAPI == null) {
            return;
        }
        AntiCheatClientInfo clientInfo = this.getClientInfo();
        try {
            this.serverAPI.updateClient(this.getClientAPI(), clientInfo);
        }
        catch (Exception e) {
            log.error("Error while updateClientInfo for client [{}]", (Object)clientInfo, (Object)e);
        }
    }

    @NotNull
    private AntiCheatClientInfo getClientInfo() {
        AntiCheatClientInfo clientInfo = new AntiCheatClientInfo(AntiCheatClientConfig.RMI_CLIENT_ID, AntiCheatClientConfig.EOS_ANTI_CHEAT_SERVER_NAME, IpUtils.getExternalIP(), AntiCheatClientConfig.RMI_CLIENT_PASSWORD);
        clientInfo.setPlayersOnline(this.getPlayersOnline());
        return clientInfo;
    }

    public AntiCheatTokenInfo validateToken(String token) {
        return this.getClientAPI().validateToken(token);
    }

    void onConnected() {
        if (this.updateTask != null) {
            this.updateTask.cancel(true);
            this.updateTask = null;
        }
        this.updateTask = this.scheduler.scheduleAtFixedRate(this::updateClientInfo, 1L, 10L, TimeUnit.SECONDS);
    }

    static /* synthetic */ Logger access$0() {
        return log;
    }

    static /* synthetic */ void access$1(AAntiCheatClientAPIConnection aAntiCheatClientAPIConnection) {
        aAntiCheatClientAPIConnection.connectToAntiCheatServer();
    }

    private class ApiDisconnectedListener
    implements ClosedListener {
        private ApiDisconnectedListener() {
        }

        public void closed() {
            log.info("Connection with anti-cheat master server API lost.");
            AAntiCheatClientAPIConnection.this.serverAPI = null;
            try {
                if (AAntiCheatClientAPIConnection.this.updateTask != null) {
                    AAntiCheatClientAPIConnection.this.updateTask.cancel(true);
                    AAntiCheatClientAPIConnection.this.updateTask = null;
                }
                if (AAntiCheatClientAPIConnection.this.reconnectTask != null) {
                    AAntiCheatClientAPIConnection.this.reconnectTask.cancel(true);
                    AAntiCheatClientAPIConnection.this.reconnectTask = null;
                }
            }
            catch (Exception exception) {}
            AAntiCheatClientAPIConnection.this.reconnectTask = AAntiCheatClientAPIConnection.this.scheduler.schedule(() -> {
                log.info("Reconnecting to anti-cheat master server API...");
                AAntiCheatClientAPIConnection.this.connectToAntiCheatServer();
            }, 2L, TimeUnit.SECONDS);
        }
    }
}

