package host.anzo.anticheat.commons.model;

import lombok.extern.slf4j.Slf4j;

/**
 * @author ANZO
 */
@Slf4j
public class RunnableWrapper implements Runnable {
	private final Runnable runnable;
	public RunnableWrapper(final Runnable runnable) {
		this.runnable = runnable;
	}

	@Override
	public void run() {
		if (runnable != null) {
			try {
				runnable.run();
			} catch (final Throwable e) {
				log.error("Error while running RunnableWrapper:", e);
				throw new RuntimeException(e);
			}
		}
	}
}