package host.anzo.anticheat.server.api.interfaces;

import host.anzo.eossdk.eos.sdk.anticheat.common.EOS_AntiCheatCommon_ClientHandle;
import host.anzo.eossdk.eos.sdk.anticheat.common.callbackresults.EOS_AntiCheatCommon_OnMessageToClientCallbackInfo;

/**
 * @author ANZO
 * @since 9/18/2024
 */
public interface IAntiCheatNetworkClient {
	/**
	 * @return Epic Online Services anti-cheat client handle
	 */
	EOS_AntiCheatCommon_ClientHandle getEOSHandle();

	/**
	 * @return Epic Online Services local user ID string representation
	 */
	String getEosLocalUserID();

	/**
	 * @return network client IP address
	 */
	String getIpAddress();

	/**
	 * @return network client connection ID
	 */
	int getConnectionId();

	/**
	 * @return account name related to the current network client
	 */
	String getAccountName();

	/**
	 * @return {@code true} if current player has admin rights, {@code false} if its general player
	 */
	boolean isAdmin();

	/**
	 * @return {@code true} if protection is disabled for the current client, {@code false} otherwise
	 */
	boolean isProtectionDisabled();

	/**
	 * Send a text message to the network client with error or information
	 * @param message message text to send
	 */
	void sendMessageToClient(String message);

	/**
	 * Send an internal anti-cheat message to a network client
	 * @param eosAntiCheatCommonOnMessageToClientCallbackInfo callback with message information
	 */
	void sendEacMessageToClient(EOS_AntiCheatCommon_OnMessageToClientCallbackInfo eosAntiCheatCommonOnMessageToClientCallbackInfo);
}