/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.anticheat.commons.utils;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IpUtils.class);
    private static final Pattern VALID_IPV4_PATTERN = Pattern.compile("(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])", 2);
    private static String EXTERNAL_IP = null;
    private static final HttpClient client = HttpClient.newHttpClient();

    @Nullable
    public static String getExternalIP() {
        if (IpUtils.checkIPv4(EXTERNAL_IP)) {
            return EXTERNAL_IP;
        }
        String ip = IpUtils.httpGet("https://api.ipify.org/");
        if (!IpUtils.checkIPv4(ip)) {
            ip = IpUtils.httpGet("http://ipinfo.io/ip");
        }
        if (!IpUtils.checkIPv4(ip)) {
            ip = IpUtils.httpGet("https://www.trackip.net/ip");
        }
        if (!IpUtils.checkIPv4(ip)) {
            ip = IpUtils.httpGet("http://checkip.amazonaws.com/");
        }
        if (IpUtils.checkIPv4(ip)) {
            EXTERNAL_IP = ip;
            return ip;
        }
        return null;
    }

    private static boolean checkIPv4(String ip) {
        if (ip == null || ip.isEmpty()) {
            return false;
        }
        return VALID_IPV4_PATTERN.matcher(ip).matches();
    }

    @Nullable
    private static String httpGet(String url) {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).GET().build();
        try {
            return client.send(request, HttpResponse.BodyHandlers.ofString()).body();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int getFreePort() {
        try {
            Throwable throwable = null;
            Object var1_2 = null;
            try (ServerSocket socket = new ServerSocket(0);){
                return socket.getLocalPort();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return -1;
        }
    }
}

