/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.anticheat.server.api;

import host.anzo.anticheat.commons.model.RunnableWrapper;
import host.anzo.anticheat.config.AntiCheatClientConfig;
import host.anzo.anticheat.server.api.interfaces.IAntiCheatNetworkClient;
import host.anzo.commons.interfaces.startup.IShutdownable;
import host.anzo.eossdk.eos.sdk.EOS;
import host.anzo.eossdk.eos.sdk.EOS_AntiCheatServer_Interface;
import host.anzo.eossdk.eos.sdk.EOS_Logging_Interface;
import host.anzo.eossdk.eos.sdk.EOS_Platform_Interface;
import host.anzo.eossdk.eos.sdk.anticheat.common.callbackresults.EOS_AntiCheatCommon_OnClientActionRequiredCallbackInfo;
import host.anzo.eossdk.eos.sdk.anticheat.common.callbackresults.EOS_AntiCheatCommon_OnClientAuthStatusChangedCallbackInfo;
import host.anzo.eossdk.eos.sdk.anticheat.common.callbackresults.EOS_AntiCheatCommon_OnMessageToClientCallbackInfo;
import host.anzo.eossdk.eos.sdk.anticheat.common.enums.EOS_EAntiCheatCommonClientAction;
import host.anzo.eossdk.eos.sdk.anticheat.common.enums.EOS_EAntiCheatCommonClientFlags;
import host.anzo.eossdk.eos.sdk.anticheat.common.enums.EOS_EAntiCheatCommonClientPlatform;
import host.anzo.eossdk.eos.sdk.anticheat.common.enums.EOS_EAntiCheatCommonClientType;
import host.anzo.eossdk.eos.sdk.anticheat.common.options.EOS_AntiCheatCommon_SetClientDetailsOptions;
import host.anzo.eossdk.eos.sdk.anticheat.server.options.EOS_AntiCheatServer_BeginSessionOptions;
import host.anzo.eossdk.eos.sdk.anticheat.server.options.EOS_AntiCheatServer_RegisterClientOptions;
import host.anzo.eossdk.eos.sdk.common.EOS_Bool;
import host.anzo.eossdk.eos.sdk.common.EOS_NotificationId;
import host.anzo.eossdk.eos.sdk.common.EOS_ProductUserId;
import host.anzo.eossdk.eos.sdk.common.enums.EOS_EResult;
import host.anzo.eossdk.eos.sdk.init.options.EOS_InitializeOptions;
import host.anzo.eossdk.eos.sdk.logging.EOS_LogMessage;
import host.anzo.eossdk.eos.sdk.logging.enums.EOS_ELogCategory;
import host.anzo.eossdk.eos.sdk.logging.enums.EOS_ELogLevel;
import host.anzo.eossdk.eos.sdk.platform.EOS_Platform_ClientCredentials;
import host.anzo.eossdk.eos.sdk.platform.enums.EOS_Platform_Create_Flag;
import host.anzo.eossdk.eos.sdk.platform.options.EOS_Platform_Options;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AEpicOnlineService
implements IShutdownable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"ANTICHEAT");
    private static final ScheduledExecutorService taskExecutor = Executors.newScheduledThreadPool(1);
    private EOS_Platform_Interface platform;
    private EOS_AntiCheatServer_Interface antiCheatServer;
    private EOS_NotificationId messageToClientNotificationId;
    private EOS_NotificationId clientActionRequiredNotificationId;
    private EOS_NotificationId clientAuthStatusChangedNotificationId;

    protected void initialize() {
        if (!AntiCheatClientConfig.EOS_ENABLE) {
            log.info("Connection to the Epic Online Services disabled by configuration");
            return;
        }
        this.callApi(() -> {
            EOS_InitializeOptions initializeOptions = new EOS_InitializeOptions();
            initializeOptions.ProductName = AntiCheatClientConfig.EOS_PRODUCT_NAME;
            initializeOptions.ProductVersion = AntiCheatClientConfig.EOS_PRODUCT_VERSION;
            EOS_EResult initResult = EOS.EOS_Initialize((EOS_InitializeOptions)initializeOptions);
            if (!initResult.isSuccess()) {
                throw new RuntimeException("Failed to EOS_Initialize with message: " + String.valueOf(initResult));
            }
            EOS_EResult setLogCallbackResult = EOS_Logging_Interface.setCallback(this::onLogMessage);
            if (!setLogCallbackResult.isSuccess()) {
                throw new RuntimeException("Failed to EOS_Logging_SetCallback with message: " + String.valueOf(setLogCallbackResult));
            }
            EOS_EResult setLogLevelResult = EOS_Logging_Interface.setLogLevel((EOS_ELogCategory)EOS_ELogCategory.EOS_LC_ALL_CATEGORIES, (EOS_ELogLevel)(AntiCheatClientConfig.DEBUG ? EOS_ELogLevel.EOS_LOG_VeryVerbose : EOS_ELogLevel.EOS_LOG_Info));
            if (!setLogLevelResult.isSuccess()) {
                throw new RuntimeException("Failed to EOS_Logging_SetLogLevel with message: " + String.valueOf(setLogLevelResult));
            }
            EOS_Platform_Options platformOptions = new EOS_Platform_Options();
            platformOptions.ProductId = AntiCheatClientConfig.EOS_PRODUCT_ID;
            platformOptions.SandboxId = AntiCheatClientConfig.EOS_SANDBOX_ID;
            platformOptions.DeploymentId = AntiCheatClientConfig.EOS_DEPLOYMENT_ID;
            platformOptions.ClientCredentials = new EOS_Platform_ClientCredentials(AntiCheatClientConfig.EOS_CLIENT_ID, AntiCheatClientConfig.EOS_CLIENT_SECRET);
            platformOptions.IsServer = EOS_Bool.EOS_TRUE;
            platformOptions.EncryptionKey = "1111111111111111111111111111111111111111111111111111111111111111";
            platformOptions.Flags = EOS_Platform_Create_Flag.of((int[])new int[]{2});
            platformOptions.CacheDirectory = System.getProperty("java.io.tmpdir");
            this.platform = EOS.EOS_Platform_Create((EOS_Platform_Options)platformOptions);
            if (this.platform == null) {
                throw new RuntimeException("Failed to EOS_Platform_Create: pointer is null");
            }
            this.antiCheatServer = this.platform.getAntiCheatServerInterface();
            if (this.antiCheatServer == null) {
                throw new RuntimeException("Failed to getAntiCheatServerInterface");
            }
            this.messageToClientNotificationId = this.antiCheatServer.addNotifyMessageToClient(null, this::onMessageToClient);
            if (!this.messageToClientNotificationId.isValid()) {
                throw new RuntimeException("Failed to addNotifyMessageToClient");
            }
            this.clientActionRequiredNotificationId = this.antiCheatServer.addNotifyClientActionRequired(null, this::onClientActionRequired);
            if (!this.clientActionRequiredNotificationId.isValid()) {
                throw new RuntimeException("Failed to addNotifyClientActionRequired");
            }
            this.clientAuthStatusChangedNotificationId = this.antiCheatServer.addNotifyClientAuthStatusChanged(null, this::onClientAuthStatusChanged);
            if (!this.clientAuthStatusChangedNotificationId.isValid()) {
                throw new RuntimeException("Failed to addNotifyClientAuthStatusChanged");
            }
            EOS_AntiCheatServer_BeginSessionOptions beginSessionOptions = new EOS_AntiCheatServer_BeginSessionOptions();
            beginSessionOptions.RegisterTimeoutSeconds = AntiCheatClientConfig.EOS_ANTI_CHEAT_CLIENT_REGISTER_TIMEOUT;
            beginSessionOptions.ServerName = AntiCheatClientConfig.EOS_ANTI_CHEAT_SERVER_NAME;
            beginSessionOptions.EnableGameplayData = EOS_Bool.of((boolean)AntiCheatClientConfig.EOS_ANTI_CHEAT_ENABLE_GAMEPLAY_DATA);
            beginSessionOptions.LocalUserId = null;
            EOS_EResult beginSessionResult = this.antiCheatServer.beginSession(beginSessionOptions);
            if (!beginSessionResult.isSuccess()) {
                throw new RuntimeException("Failed to anti-cheat beginSession: " + String.valueOf(beginSessionResult));
            }
        });
        taskExecutor.scheduleAtFixedRate(() -> {
            if (this.platform != null) {
                this.platform.tick();
            }
        }, 0L, AntiCheatClientConfig.EOS_PLATFORM_TICK_PERIOD, TimeUnit.MILLISECONDS);
    }

    protected abstract IAntiCheatNetworkClient getClient(int var1);

    public void onClientConnected(IAntiCheatNetworkClient client) {
        this.callApi(() -> {
            EOS_AntiCheatServer_RegisterClientOptions registerClientOptions = new EOS_AntiCheatServer_RegisterClientOptions();
            registerClientOptions.ClientHandle = client.getEOSHandle();
            registerClientOptions.UserId = EOS_ProductUserId.fromString((String)client.getEosLocalUserID());
            registerClientOptions.IpAddress = client.getIpAddress();
            registerClientOptions.ClientType = EOS_EAntiCheatCommonClientType.EOS_ACCCT_ProtectedClient;
            registerClientOptions.ClientPlatform = EOS_EAntiCheatCommonClientPlatform.EOS_ACCCP_Windows;
            EOS_EResult registerClientResult = this.antiCheatServer.registerClient(registerClientOptions);
            if (!registerClientResult.isSuccess()) {
                log.error("RegisterClient failed for clientId=[{}] with error=[{}]", (Object)client.getConnectionId(), (Object)registerClientResult);
                client.sendMessageToClient("Failed to register client");
                return;
            }
            EOS_AntiCheatCommon_SetClientDetailsOptions setClientDetailsOptions = new EOS_AntiCheatCommon_SetClientDetailsOptions();
            setClientDetailsOptions.ClientHandle = client.getEOSHandle();
            setClientDetailsOptions.ClientFlags = client.isAdmin() ? EOS_EAntiCheatCommonClientFlags.EOS_ACCCF_Admin : EOS_EAntiCheatCommonClientFlags.EOS_ACCCF_None;
            EOS_EResult setClientDetailsResult = this.antiCheatServer.setClientDetails(setClientDetailsOptions);
            if (!setClientDetailsResult.isSuccess()) {
                log.error("SetClientDetails failed for clientId=[{}] with error=[{}]", (Object)client.getConnectionId(), (Object)setClientDetailsResult);
                client.sendMessageToClient("Client details set failed");
            }
        });
    }

    public void onClientMessage(IAntiCheatNetworkClient client, byte[] data) {
        this.callApi(() -> {
            EOS_EResult receiveMessageFromClientResult = this.antiCheatServer.receiveMessageFromClient(client.getEOSHandle(), data);
            if (!receiveMessageFromClientResult.isSuccess()) {
                log.error("ReceiveMessageFromClient failed for clientId=[{}] with result=[{}]", (Object)client.getConnectionId(), (Object)receiveMessageFromClientResult);
                client.sendMessageToClient("Failed to receive security data");
            }
        });
    }

    public void onClientDisconnected(@NotNull IAntiCheatNetworkClient client) {
        log.info("Client id=[{}] disconnected", (Object)client.getConnectionId());
        this.callApi(() -> {
            EOS_EResult eOS_EResult = this.antiCheatServer.unregisterClient(client.getEOSHandle());
        });
    }

    private void onClientActionRequired(@NotNull EOS_AntiCheatCommon_OnClientActionRequiredCallbackInfo callbackInfo) {
        log.warn("onClientActionRequired: action={} reasonCode={}", (Object)callbackInfo.ClientAction, (Object)callbackInfo.ActionReasonCode);
        IAntiCheatNetworkClient client = this.getClient((int)callbackInfo.ClientHandle.getValue());
        if (client == null) {
            log.warn("Received OnClientActionRequiredCallback for unknown client clientId=[{}]", (Object)callbackInfo.ClientHandle.getValue());
            return;
        }
        if (callbackInfo.ClientAction == EOS_EAntiCheatCommonClientAction.EOS_ACCCA_RemovePlayer) {
            log.warn("Kicking client with account=[{}] productUserId=[{}]: reasonCode=[{}] reasonDetails=[{}]", new Object[]{client.getAccountName(), client.getEosLocalUserID(), callbackInfo.ActionReasonCode, callbackInfo.ActionReasonDetailsString});
            client.sendMessageToClient(callbackInfo.ActionReasonDetailsString);
        }
    }

    private void onMessageToClient(@NotNull EOS_AntiCheatCommon_OnMessageToClientCallbackInfo callbackInfo) {
        IAntiCheatNetworkClient client = this.getClient((int)callbackInfo.ClientHandle.getValue());
        if (client != null) {
            client.sendEacMessageToClient(callbackInfo);
        }
    }

    private void onClientAuthStatusChanged(@NotNull EOS_AntiCheatCommon_OnClientAuthStatusChangedCallbackInfo callbackInfo) {
        EOS_EResult setClientNetworkStateResult;
        log.info("onClientAuthStatusChanged: clientHandle={} authStatus={}", (Object)callbackInfo.ClientHandle.getValue(), (Object)callbackInfo.ClientAuthStatus);
        IAntiCheatNetworkClient client = this.getClient((int)callbackInfo.ClientHandle.getValue());
        if (client != null && !(setClientNetworkStateResult = this.antiCheatServer.setClientNetworkState(client.getEOSHandle(), true)).isSuccess()) {
            log.error("SetClientNetworkState failed for clientId=[{}] result=[{}]", (Object)client.getConnectionId(), (Object)setClientNetworkStateResult);
            client.sendMessageToClient("Client set network state failed");
        }
    }

    public void onShutdown() {
        if (this.antiCheatServer != null) {
            if (this.messageToClientNotificationId.isValid()) {
                this.antiCheatServer.removeNotifyMessageToClient(this.messageToClientNotificationId);
            }
            if (this.clientActionRequiredNotificationId.isValid()) {
                this.antiCheatServer.removeNotifyClientActionRequired(this.clientActionRequiredNotificationId);
            }
            if (this.clientAuthStatusChangedNotificationId.isValid()) {
                this.antiCheatServer.removeNotifyClientAuthStatusChanged(this.clientAuthStatusChangedNotificationId);
            }
        }
        if (this.platform != null) {
            this.platform.release();
        }
        EOS.EOS_Shutdown();
    }

    private void callApi(Runnable methodToCall) {
        taskExecutor.execute(new RunnableWrapper(methodToCall));
    }

    private void onLogMessage(@NotNull EOS_LogMessage logMessage) {
        switch (logMessage.Level) {
            case EOS_LOG_Fatal: 
            case EOS_LOG_Error: {
                log.error(logMessage.Message);
                break;
            }
            case EOS_LOG_Warning: {
                log.warn(logMessage.Message);
                break;
            }
            case EOS_LOG_Info: {
                log.info(logMessage.Message);
                break;
            }
            case EOS_LOG_Verbose: 
            case EOS_LOG_VeryVerbose: {
                log.debug(logMessage.Message);
            }
        }
    }
}

