package host.anzo.anticheat.server.api.interfaces.rmi;

import host.anzo.anticheat.server.api.enums.EAntiClientRegisterResult;
import host.anzo.anticheat.server.api.model.AntiCheatClientInfo;
import org.jetbrains.annotations.NotNull;

/**
 * @author ANZO
 * @since 9/15/2024
 */
public interface IRMIAntiCheatServerAPI {
	/**
	 * @return {@code true} if server API connection is alive, {@code false} otherwise
	 */
	boolean testConnection();

	/**
	 * Register a client at master server
	 * @param connection client connection
	 * @param clientInfo client information
	 * @return client registration result
	 */
	EAntiClientRegisterResult registerClient(IRMIAntiCheatClientAPI connection, @NotNull AntiCheatClientInfo clientInfo);

	void updateClient(IRMIAntiCheatClientAPI connection, @NotNull AntiCheatClientInfo clientInfo);
}