/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.classindex;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.stream.Collectors;

public class ClassIndex {
    public static final String SUBCLASS_INDEX_PREFIX = "META-INF/services/";
    public static final String ANNOTATED_INDEX_PREFIX = "META-INF/annotations/";
    public static final String PACKAGE_INDEX_NAME = "jaxb.index";
    public static final String JAVADOC_PREFIX = "META-INF/javadocs/";
    private static final ForkJoinPool FORK_JOIN_POOL = new ForkJoinPool(Math.max(1, Runtime.getRuntime().availableProcessors()), pool -> {
        ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
        worker.setName("ClassIndex-FJP-" + worker.getPoolIndex());
        return worker;
    }, null, false);

    private ClassIndex() {
    }

    public static <T> List<Class<? extends T>> getSubclasses(Class<T> superClass) {
        return ClassIndex.getSubclasses(superClass, Thread.currentThread().getContextClassLoader());
    }

    public static <T> List<Class<? extends T>> getSubclasses(Class<T> superClass, ClassLoader classLoader) {
        List<String> entries = ClassIndex.getSubclassesNames(superClass, classLoader);
        return ClassIndex.findClasses(classLoader, entries).stream().filter(superClass::isAssignableFrom).map(klass -> klass).collect(Collectors.toList());
    }

    public static <T> List<String> getSubclassesNames(Class<T> superClass) {
        return ClassIndex.getSubclassesNames(superClass, Thread.currentThread().getContextClassLoader());
    }

    public static <T> List<String> getSubclassesNames(Class<T> superClass, ClassLoader classLoader) {
        return ClassIndex.readIndexFile(classLoader, SUBCLASS_INDEX_PREFIX + superClass.getCanonicalName());
    }

    public static List<Class<?>> getPackageClasses(String packageName) {
        return ClassIndex.getPackageClasses(packageName, Thread.currentThread().getContextClassLoader());
    }

    public static List<Class<?>> getPackageClasses(String packageName, ClassLoader classLoader) {
        List<String> entries = ClassIndex.readIndexFile(classLoader, packageName.replace(".", "/") + "/jaxb.index");
        Set<Class<?>> classes = ClassIndex.findClassesInPackage(classLoader, packageName, entries);
        classes.addAll(ClassIndex.findClasses(classLoader, entries));
        return new ArrayList(classes);
    }

    public static List<String> getPackageClassesNames(String packageName) {
        return ClassIndex.getPackageClassesNames(packageName, Thread.currentThread().getContextClassLoader());
    }

    public static List<String> getPackageClassesNames(String packageName, ClassLoader classLoader) {
        List<String> entries = ClassIndex.readIndexFile(classLoader, packageName.replace(".", "/") + "/jaxb.index");
        return entries.stream().map(simpleName -> packageName + "." + simpleName).collect(Collectors.toList());
    }

    public static List<Class<?>> getAnnotated(Class<? extends Annotation> annotation) {
        return ClassIndex.getAnnotated(annotation, Thread.currentThread().getContextClassLoader());
    }

    public static List<Class<?>> getAnnotated(Class<? extends Annotation> annotation, ClassLoader classLoader) {
        List<String> entries = ClassIndex.getAnnotatedNames(annotation, classLoader);
        return new ArrayList(ClassIndex.findClasses(classLoader, entries));
    }

    public static List<String> getAnnotatedNames(Class<? extends Annotation> annotation) {
        return ClassIndex.getAnnotatedNames(annotation, Thread.currentThread().getContextClassLoader());
    }

    public static List<String> getAnnotatedNames(Class<? extends Annotation> annotation, ClassLoader classLoader) {
        return ClassIndex.readIndexFile(classLoader, ANNOTATED_INDEX_PREFIX + annotation.getCanonicalName());
    }

    public static String getClassSummary(Class<?> klass) {
        return ClassIndex.getClassSummary(klass, Thread.currentThread().getContextClassLoader());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getClassSummary(Class<?> klass, ClassLoader classLoader) {
        URL resource = classLoader.getResource(JAVADOC_PREFIX + klass.getCanonicalName());
        if (resource == null) {
            return null;
        }
        try {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream(), StandardCharsets.UTF_8));){
                StringBuilder builder = new StringBuilder();
                String line = reader.readLine();
                while (line != null) {
                    int dotIndex = line.indexOf(46);
                    if (dotIndex != -1) {
                        builder.append(line.subSequence(0, dotIndex));
                        String string = builder.toString().trim();
                        return string;
                    }
                    builder.append(line);
                    line = reader.readLine();
                }
                String string = builder.toString().trim();
                return string;
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("ClassIndex: Cannot read Javadoc index", e);
        }
    }

    private static List<String> readIndexFile(ClassLoader classLoader, String resourceFile) {
        HashSet<String> entries = new HashSet<String>();
        try {
            Enumeration<URL> resources = classLoader.getResources(resourceFile);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream(), StandardCharsets.UTF_8));){
                    String line = reader.readLine();
                    while (line != null) {
                        entries.add(line);
                        line = reader.readLine();
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
        }
        catch (IOException e) {
            throw new RuntimeException("ClassIndex: Cannot read class index", e);
        }
        return new ArrayList<String>(entries);
    }

    private static Set<Class<?>> findClasses(ClassLoader classLoader, List<String> entries) {
        try {
            ConcurrentHashMap.KeySetView foundClasses = ConcurrentHashMap.newKeySet();
            ((ForkJoinTask)FORK_JOIN_POOL.submit(() -> entries.parallelStream().forEach(entry -> {
                try {
                    foundClasses.add(Class.forName(entry, true, classLoader));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }))).get();
            return foundClasses;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while findClasses", e);
        }
    }

    private static Set<Class<?>> findClassesInPackage(ClassLoader classLoader, String packageName, List<String> entries) {
        ConcurrentHashMap.KeySetView foundClasses = ConcurrentHashMap.newKeySet();
        try {
            ((ForkJoinTask)FORK_JOIN_POOL.submit(() -> entries.parallelStream().filter(entry -> !entry.contains(".")).map(entry -> packageName + "." + entry).forEach(entry -> {
                try {
                    foundClasses.add(Class.forName(entry, false, classLoader));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }))).get();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while findClassesInPackage", e);
        }
        return foundClasses;
    }
}

